/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.solarcooker.blockentity;

import com.google.common.collect.Lists;
import de.cech12.solarcooker.Constants;
import de.cech12.solarcooker.ModTags;
import de.cech12.solarcooker.block.SolarCookerBlock;
import de.cech12.solarcooker.inventory.SolarCookerContainer;
import de.cech12.solarcooker.platform.Services;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class SolarCookerBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible,
LidBlockEntity {
    public static final int CONTAINER_IS_SUNLIT = 0;
    public static final int CONTAINER_COOK_TIME = 1;
    public static final int CONTAINER_COOK_TIME_TOTAL = 2;
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    public static final int REFLECTOR_LEFT = 2;
    public static final int REFLECTOR_RIGHT = 3;
    private static final int[] SLOTS = new int[]{0, 1};
    private static final int[] SLOTS_UP = new int[0];
    private static final int[] SLOTS_REFLECTORS = new int[]{2, 3};
    protected NonNullList<ItemStack> items = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    protected int cookTime;
    protected int cookTimeTotal;
    protected boolean reflectorLeft;
    protected boolean reflectorRight;
    protected final RecipeType<? extends AbstractCookingRecipe> specificRecipeType;
    private final ContainerOpenersCounter openersCounter;
    private final ChestLidController chestLidController;
    private boolean isLidOpen = false;
    private final Object2IntOpenHashMap<ResourceKey<Recipe<?>>> usedRecipes = new Object2IntOpenHashMap();
    protected RecipeHolder<? extends AbstractCookingRecipe> curRecipe;
    protected ItemStack failedMatch = ItemStack.EMPTY;
    protected final ContainerData dataAccess = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> {
                    if (SolarCookerBlockEntity.this.isSunlit()) {
                        yield 1;
                    }
                    yield 0;
                }
                case 1 -> SolarCookerBlockEntity.this.cookTime;
                case 2 -> SolarCookerBlockEntity.this.cookTimeTotal;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 1: {
                    SolarCookerBlockEntity.this.cookTime = value;
                    break;
                }
                case 2: {
                    SolarCookerBlockEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int getCount() {
            return 3;
        }
    };

    public SolarCookerBlockEntity(BlockEntityType<?> tileTypeIn, BlockPos pos, BlockState state, RecipeType<? extends AbstractCookingRecipe> specificRecipeTypeIn) {
        super(tileTypeIn, pos, state);
        this.specificRecipeType = specificRecipeTypeIn;
        this.openersCounter = new ContainerOpenersCounter(){

            protected void onOpen(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state) {
                SolarCookerBlockEntity blockEntity;
                BlockEntity blockEntity2 = level.getBlockEntity(pos);
                if (blockEntity2 instanceof SolarCookerBlockEntity && !(blockEntity = (SolarCookerBlockEntity)blockEntity2).shouldLidBeOpen(0)) {
                    SolarCookerBlockEntity.playSound(level, pos, SoundEvents.CHEST_OPEN);
                }
            }

            protected void onClose(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state) {
                SolarCookerBlockEntity blockEntity;
                BlockEntity blockEntity2 = level.getBlockEntity(pos);
                if (blockEntity2 instanceof SolarCookerBlockEntity && !(blockEntity = (SolarCookerBlockEntity)blockEntity2).shouldLidBeOpen(0)) {
                    SolarCookerBlockEntity.playSound(level, pos, SoundEvents.CHEST_CLOSE);
                }
            }

            protected void openerCountChanged(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, int unknown, int numPlayerUsing) {
                SolarCookerBlockEntity.signalOpenCount(level, pos, state, numPlayerUsing, false);
            }

            protected boolean isOwnContainer(@Nonnull Player player) {
                if (!(player.containerMenu instanceof SolarCookerContainer)) {
                    return false;
                }
                Container container = ((SolarCookerContainer)player.containerMenu).getContainer();
                return container == SolarCookerBlockEntity.this || container instanceof CompoundContainer && ((CompoundContainer)container).contains((Container)SolarCookerBlockEntity.this);
            }
        };
        this.chestLidController = new ChestLidController();
    }

    public SolarCookerBlockEntity(BlockPos pos, BlockState state) {
        this(Constants.SOLAR_COOKER_ENTITY_TYPE.get(), pos, state, Constants.SOLAR_COOKING_RECIPE_TYPE.get());
    }

    @Nonnull
    protected Component getDefaultName() {
        return Component.translatable((String)"block.solarcooker.solar_cooker");
    }

    @Nonnull
    protected AbstractContainerMenu createMenu(int id, @Nonnull Inventory player) {
        return new SolarCookerContainer(this.specificRecipeType, id, player, (Container)this, this.dataAccess);
    }

    private boolean hasShiningBlockAbove() {
        BlockPos checkPos;
        if (this.level != null && !this.level.isClientSide && this.level.getBlockState(checkPos = this.worldPosition.above()).propagatesSkylightDown()) {
            for (int i = 0; i < 5; ++i) {
                BlockState state = this.level.getBlockState(checkPos = checkPos.above());
                if (state.is(ModTags.Blocks.SOLAR_COOKER_SHINING)) {
                    return true;
                }
                if (state.propagatesSkylightDown()) continue;
                return false;
            }
        }
        return false;
    }

    public boolean isSunlit() {
        if (this.level != null) {
            if (!this.level.isClientSide) {
                return this.hasShiningBlockAbove() || this.level.dimensionType().hasSkyLight() && this.level.isBrightOutside() && !this.level.isRaining() && this.level.canSeeSky(this.worldPosition.above());
            }
            return (Boolean)this.getBlockState().getValue((Property)SolarCookerBlock.SUNLIT);
        }
        return false;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public int getCookTimeTotal() {
        return this.cookTimeTotal;
    }

    protected void loadAdditional(@Nonnull ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((ValueInput)valueInput, this.items);
        this.cookTime = valueInput.getIntOr("CookTime", 0);
        this.cookTimeTotal = valueInput.getIntOr("CookTimeTotal", 200);
        this.updateShouldLidBeOpen(this.openersCounter.getOpenerCount());
    }

    protected void saveAdditional(@Nonnull ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        valueOutput.putInt("CookTime", this.cookTime);
        valueOutput.putInt("CookTimeTotal", this.cookTimeTotal);
        ContainerHelper.saveAllItems((ValueOutput)valueOutput, this.items);
    }

    @Nonnull
    public CompoundTag getUpdateTag(@Nonnull HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SolarCookerBlockEntity entity) {
        if (level != null) {
            boolean isBurning;
            boolean dirty = false;
            entity.updateReflectorStates();
            boolean isSunlit = entity.isSunlit();
            if (isSunlit && !((ItemStack)entity.items.get(0)).isEmpty()) {
                RecipeHolder<? extends AbstractCookingRecipe> recipe = entity.getRecipe();
                if (entity.canSmelt(level.registryAccess(), recipe)) {
                    ++entity.cookTime;
                    if (entity.cookTime == entity.cookTimeTotal) {
                        entity.cookTime = 0;
                        entity.cookTimeTotal = entity.getRecipeCookTime();
                        if (!level.isClientSide) {
                            entity.smeltItem(level.registryAccess(), recipe);
                            dirty = true;
                        }
                    }
                } else {
                    entity.cookTime = 0;
                }
            } else if (!isSunlit && entity.cookTime > 0) {
                entity.cookTime = Mth.clamp((int)(entity.cookTime - 2), (int)0, (int)entity.cookTimeTotal);
            }
            boolean bl = isBurning = entity.cookTime > 0;
            if (!(level.isClientSide || (Boolean)state.getValue((Property)SolarCookerBlock.BURNING) == isBurning && (Boolean)state.getValue((Property)SolarCookerBlock.SUNLIT) == isSunlit && (Boolean)state.getValue((Property)SolarCookerBlock.LEFT_REFLECTOR) == entity.reflectorLeft && (Boolean)state.getValue((Property)SolarCookerBlock.RIGHT_REFLECTOR) == entity.reflectorRight)) {
                dirty = true;
                level.setBlock(entity.worldPosition, (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)SolarCookerBlock.SUNLIT, (Comparable)Boolean.valueOf(isSunlit))).setValue((Property)SolarCookerBlock.BURNING, (Comparable)Boolean.valueOf(isBurning))).setValue((Property)SolarCookerBlock.LEFT_REFLECTOR, (Comparable)Boolean.valueOf(entity.reflectorLeft))).setValue((Property)SolarCookerBlock.RIGHT_REFLECTOR, (Comparable)Boolean.valueOf(entity.reflectorRight)), 3);
            }
            if (dirty) {
                entity.setChanged();
                SolarCookerBlockEntity.signalOpenCount(level, pos, state, entity.openersCounter.getOpenerCount(), true);
            }
        }
    }

    public boolean shouldLidBeOpen(int numPlayersUsing) {
        boolean recipeActive = this.cookTime > 0 || this.getLevel() != null && this.canSmelt(this.getLevel().registryAccess(), this.getRecipe());
        return numPlayersUsing > 0 || recipeActive && this.isSunlit();
    }

    public void updateShouldLidBeOpen(int numPlayersUsing) {
        this.isLidOpen = this.shouldLidBeOpen(numPlayersUsing);
        this.chestLidController.shouldBeOpen(this.isLidOpen);
    }

    public static void lidAnimateTick(Level level, BlockPos pos, BlockState state, SolarCookerBlockEntity blockEntity) {
        blockEntity.chestLidController.tickLid();
        blockEntity.updateReflectorStates();
    }

    public boolean triggerEvent(int id, int numPlayersUsing) {
        if (id == 1) {
            this.updateShouldLidBeOpen(numPlayersUsing);
            return true;
        }
        return super.triggerEvent(id, numPlayersUsing);
    }

    public void startOpen(@Nonnull Player player) {
        if (!this.remove && !player.isSpectator() && this.getLevel() != null) {
            this.openersCounter.incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(@Nonnull Player player) {
        if (!this.remove && !player.isSpectator() && this.getLevel() != null) {
            this.openersCounter.decrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove && this.getLevel() != null) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public static void signalOpenCount(Level level, BlockPos pos, BlockState state, int numPlayersUsing, boolean playSound) {
        SolarCookerBlockEntity blockEntity;
        BlockEntity blockEntity2;
        if (playSound && numPlayersUsing < 1 && (blockEntity2 = level.getBlockEntity(pos)) instanceof SolarCookerBlockEntity && blockEntity.isLidOpen != (blockEntity = (SolarCookerBlockEntity)blockEntity2).shouldLidBeOpen(numPlayersUsing)) {
            if (blockEntity.isLidOpen) {
                SolarCookerBlockEntity.playSound(blockEntity.level, blockEntity.getBlockPos(), SoundEvents.CHEST_CLOSE);
            } else {
                SolarCookerBlockEntity.playSound(blockEntity.level, blockEntity.getBlockPos(), SoundEvents.CHEST_OPEN);
            }
        }
        Block block = state.getBlock();
        level.blockEvent(pos, block, 1, numPlayersUsing);
    }

    public static void playSound(Level level, BlockPos pos, SoundEvent soundEvent) {
        if (level != null && !level.isClientSide) {
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 0.5;
            double z = (double)pos.getZ() + 0.5;
            level.playSound(null, x, y, z, soundEvent, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
        }
    }

    protected boolean canSmelt(RegistryAccess registryAccess, @Nullable RecipeHolder<?> recipe) {
        AbstractCookingRecipe cookingRecipe;
        ItemStack recipeOutput;
        Recipe recipe2;
        if (!((ItemStack)this.items.get(0)).isEmpty() && recipe != null && (recipe2 = recipe.value()) instanceof AbstractCookingRecipe && !(recipeOutput = (cookingRecipe = (AbstractCookingRecipe)recipe2).assemble(new SingleRecipeInput((ItemStack)this.items.get(0)), (HolderLookup.Provider)registryAccess)).isEmpty()) {
            ItemStack output = (ItemStack)this.items.get(1);
            if (output.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItem((ItemStack)output, (ItemStack)recipeOutput)) {
                return false;
            }
            return output.getCount() + recipeOutput.getCount() <= output.getMaxStackSize();
        }
        return false;
    }

    private void smeltItem(RegistryAccess registryAccess, @Nullable RecipeHolder<?> recipe) {
        Recipe recipe2;
        if (recipe != null && this.canSmelt(registryAccess, recipe) && (recipe2 = recipe.value()) instanceof AbstractCookingRecipe) {
            AbstractCookingRecipe cookingRecipe = (AbstractCookingRecipe)recipe2;
            ItemStack itemstack = (ItemStack)this.items.get(0);
            ItemStack itemstack1 = cookingRecipe.assemble(new SingleRecipeInput(itemstack), (HolderLookup.Provider)registryAccess);
            ItemStack itemstack2 = (ItemStack)this.items.get(1);
            if (itemstack2.isEmpty()) {
                this.items.set(1, (Object)itemstack1.copy());
            } else if (itemstack2.getItem() == itemstack1.getItem()) {
                itemstack2.grow(itemstack1.getCount());
            }
            if (this.level != null && !this.level.isClientSide) {
                this.setRecipeUsed(recipe);
            }
            itemstack.shrink(1);
        }
    }

    protected int getRecipeCookTime() {
        double reflectorFactor;
        RecipeHolder<? extends AbstractCookingRecipe> rec = this.getRecipe();
        if (rec == null) {
            return 200;
        }
        int reflectorCount = this.getReflectorCount();
        double d = reflectorFactor = reflectorCount > 0 ? 1.0 - (1.0 - Services.CONFIG.getMaxReflectorTimeFactor()) / (double)SLOTS_REFLECTORS.length * (double)reflectorCount : 1.0;
        if (this.specificRecipeType.getClass().isInstance(((AbstractCookingRecipe)rec.value()).getType())) {
            return (int)((double)((AbstractCookingRecipe)rec.value()).cookingTime() * reflectorFactor);
        }
        return (int)((double)((AbstractCookingRecipe)rec.value()).cookingTime() * (Services.CONFIG.getCookTimeFactor() * reflectorFactor));
    }

    protected RecipeHolder<? extends AbstractCookingRecipe> getRecipe() {
        ItemStack input = this.getItem(0);
        if (input.isEmpty() || input == this.failedMatch) {
            return null;
        }
        SingleRecipeInput recipeInput = new SingleRecipeInput(input);
        if (this.level != null && this.curRecipe != null && ((AbstractCookingRecipe)this.curRecipe.value()).matches(recipeInput, this.level)) {
            return this.curRecipe;
        }
        RecipeHolder rec = null;
        if (this.level != null && this.level.getServer() != null && (rec = (RecipeHolder)this.level.getServer().getRecipeManager().getRecipeFor(this.specificRecipeType, (RecipeInput)recipeInput, this.level).orElse(null)) == null && Services.CONFIG.areVanillaRecipesEnabled()) {
            rec = this.level.getServer().getRecipeManager().getRecipes().stream().filter(recipe -> recipe.value().getType() == Services.CONFIG.getRecipeType()).filter(recipe -> recipe.value() instanceof AbstractCookingRecipe).map(recipe -> recipe).filter(recipe -> ((AbstractCookingRecipe)recipe.value()).matches(recipeInput, this.level)).filter(recipe -> Services.CONFIG.isRecipeAllowed(recipe.id().location())).findFirst().orElse(null);
        }
        this.failedMatch = rec == null ? input : ItemStack.EMPTY;
        this.curRecipe = rec;
        return this.curRecipe;
    }

    private boolean slotContainsReflector(int slot) {
        return this.getItem(slot).is(ModTags.Items.SOLAR_COOKER_REFLECTOR);
    }

    private int getReflectorCount() {
        int count = 0;
        for (int slot : SLOTS_REFLECTORS) {
            if (!this.slotContainsReflector(slot)) continue;
            ++count;
        }
        return count;
    }

    private void updateReflectorStates() {
        boolean slotValue = this.slotContainsReflector(2);
        if (this.reflectorLeft != slotValue) {
            this.reflectorLeft = slotValue;
        }
        if (this.reflectorRight != (slotValue = this.slotContainsReflector(3))) {
            this.reflectorRight = slotValue;
        }
    }

    public boolean hasLeftReflector() {
        return this.reflectorLeft;
    }

    public boolean hasRightReflector() {
        return this.reflectorRight;
    }

    @Nonnull
    public int[] getSlotsForFace(@Nonnull Direction side) {
        if (side == Direction.UP) {
            return SLOTS_UP;
        }
        return SLOTS;
    }

    public boolean canPlaceItemThroughFace(int index, @Nonnull ItemStack itemStackIn, @Nullable Direction direction) {
        return this.canPlaceItem(index, itemStackIn);
    }

    public boolean canTakeItemThroughFace(int index, @Nonnull ItemStack stack, @Nullable Direction direction) {
        return direction != Direction.UP && index == 1;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Nonnull
    public ItemStack getItem(int index) {
        return (ItemStack)this.items.get(index);
    }

    @Nonnull
    public ItemStack removeItem(int index, int count) {
        return ContainerHelper.removeItem(this.items, (int)index, (int)count);
    }

    @Nonnull
    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.items, (int)index);
    }

    protected void setItems(@Nonnull NonNullList<ItemStack> nonNullList) {
        this.items = nonNullList;
    }

    public void setItem(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.items.get(index);
        boolean flag = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)stack);
        this.items.set(index, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        if (index == 0 && !flag) {
            this.cookTimeTotal = this.getRecipeCookTime();
            this.cookTime = 0;
            this.setChanged();
        }
    }

    public boolean stillValid(@Nonnull Player player) {
        if (this.level != null && this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public boolean canPlaceItem(int index, @Nonnull ItemStack stack) {
        return index == 0;
    }

    public void clearContent() {
        this.items.clear();
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            this.usedRecipes.addTo((Object)recipe.id(), 1);
        }
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void awardUsedRecipesAndPopExperience(Player p_235645_1_) {
        List<RecipeHolder<?>> list = this.getRecipesToAwardAndPopExperience(p_235645_1_.level(), p_235645_1_.position());
        p_235645_1_.awardRecipes(list);
        this.usedRecipes.clear();
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(Level p_235640_1_, Vec3 p_235640_2_) {
        ArrayList list = Lists.newArrayList();
        if (p_235640_1_.getServer() != null) {
            for (Object2IntMap.Entry entry : this.usedRecipes.object2IntEntrySet()) {
                p_235640_1_.getServer().getRecipeManager().byKey((ResourceKey)entry.getKey()).ifPresent(recipeHolder -> {
                    list.add(recipeHolder);
                    SolarCookerBlockEntity.createExperience(p_235640_1_, p_235640_2_, entry.getIntValue(), ((AbstractCookingRecipe)recipeHolder.value()).experience());
                });
            }
        }
        return list;
    }

    private static void createExperience(Level p_235641_0_, Vec3 p_235641_1_, int p_235641_2_, float p_235641_3_) {
        int i = Mth.floor((float)((float)p_235641_2_ * p_235641_3_));
        float f = Mth.frac((float)((float)p_235641_2_ * p_235641_3_));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        while (i > 0) {
            int j = ExperienceOrb.getExperienceValue((int)i);
            i -= j;
            p_235641_0_.addFreshEntity((Entity)new ExperienceOrb(p_235641_0_, p_235641_1_.x, p_235641_1_.y, p_235641_1_.z, j));
        }
    }

    public void fillStackedContents(@Nonnull StackedItemContents stackedContents) {
        for (ItemStack itemstack : this.items) {
            stackedContents.accountStack(itemstack);
        }
    }

    public float getOpenNess(float partialTicks) {
        return this.chestLidController.getOpenness(partialTicks);
    }
}

