/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.solarcooker.blockentity;

import com.google.common.collect.Lists;
import de.cech12.solarcooker.Constants;
import de.cech12.solarcooker.ModTags;
import de.cech12.solarcooker.block.SolarCookerBlock;
import de.cech12.solarcooker.inventory.SolarCookerContainer;
import de.cech12.solarcooker.platform.Services;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1258;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1732;
import net.minecraft.class_1737;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2618;
import net.minecraft.class_2622;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5560;
import net.minecraft.class_5561;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import net.minecraft.class_9875;

public class SolarCookerBlockEntity
extends class_2624
implements class_1278,
class_1732,
class_1737,
class_2618 {
    public static final int CONTAINER_IS_SUNLIT = 0;
    public static final int CONTAINER_COOK_TIME = 1;
    public static final int CONTAINER_COOK_TIME_TOTAL = 2;
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    public static final int REFLECTOR_LEFT = 2;
    public static final int REFLECTOR_RIGHT = 3;
    private static final int[] SLOTS = new int[]{0, 1};
    private static final int[] SLOTS_UP = new int[0];
    private static final int[] SLOTS_REFLECTORS = new int[]{2, 3};
    protected class_2371<class_1799> items = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    protected int cookTime;
    protected int cookTimeTotal;
    protected boolean reflectorLeft;
    protected boolean reflectorRight;
    protected final class_3956<? extends class_1874> specificRecipeType;
    private final class_5561 openersCounter;
    private final class_5560 chestLidController;
    private boolean isLidOpen = false;
    private final Object2IntOpenHashMap<class_5321<class_1860<?>>> usedRecipes = new Object2IntOpenHashMap();
    protected class_8786<? extends class_1874> curRecipe;
    protected class_1799 failedMatch = class_1799.field_8037;
    protected final class_3913 dataAccess = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> {
                    if (SolarCookerBlockEntity.this.isSunlit()) {
                        yield 1;
                    }
                    yield 0;
                }
                case 1 -> SolarCookerBlockEntity.this.cookTime;
                case 2 -> SolarCookerBlockEntity.this.cookTimeTotal;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 1: {
                    SolarCookerBlockEntity.this.cookTime = value;
                    break;
                }
                case 2: {
                    SolarCookerBlockEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int method_17389() {
            return 3;
        }
    };

    public SolarCookerBlockEntity(class_2591<?> tileTypeIn, class_2338 pos, class_2680 state, class_3956<? extends class_1874> specificRecipeTypeIn) {
        super(tileTypeIn, pos, state);
        this.specificRecipeType = specificRecipeTypeIn;
        this.openersCounter = new class_5561(){

            protected void method_31681(@Nonnull class_1937 level, @Nonnull class_2338 pos, @Nonnull class_2680 state) {
                SolarCookerBlockEntity blockEntity;
                class_2586 class_25862 = level.method_8321(pos);
                if (class_25862 instanceof SolarCookerBlockEntity && !(blockEntity = (SolarCookerBlockEntity)class_25862).shouldLidBeOpen(0)) {
                    SolarCookerBlockEntity.playSound(level, pos, class_3417.field_14982);
                }
            }

            protected void method_31683(@Nonnull class_1937 level, @Nonnull class_2338 pos, @Nonnull class_2680 state) {
                SolarCookerBlockEntity blockEntity;
                class_2586 class_25862 = level.method_8321(pos);
                if (class_25862 instanceof SolarCookerBlockEntity && !(blockEntity = (SolarCookerBlockEntity)class_25862).shouldLidBeOpen(0)) {
                    SolarCookerBlockEntity.playSound(level, pos, class_3417.field_14823);
                }
            }

            protected void method_31682(@Nonnull class_1937 level, @Nonnull class_2338 pos, @Nonnull class_2680 state, int unknown, int numPlayerUsing) {
                SolarCookerBlockEntity.signalOpenCount(level, pos, state, numPlayerUsing, false);
            }

            protected boolean method_31679(@Nonnull class_1657 player) {
                if (!(player.field_7512 instanceof SolarCookerContainer)) {
                    return false;
                }
                class_1263 container = ((SolarCookerContainer)player.field_7512).getContainer();
                return container == SolarCookerBlockEntity.this || container instanceof class_1258 && ((class_1258)container).method_5405((class_1263)SolarCookerBlockEntity.this);
            }
        };
        this.chestLidController = new class_5560();
    }

    public SolarCookerBlockEntity(class_2338 pos, class_2680 state) {
        this(Constants.SOLAR_COOKER_ENTITY_TYPE.get(), pos, state, Constants.SOLAR_COOKING_RECIPE_TYPE.get());
    }

    @Nonnull
    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"block.solarcooker.solar_cooker");
    }

    @Nonnull
    protected class_1703 method_5465(int id, @Nonnull class_1661 player) {
        return new SolarCookerContainer(this.specificRecipeType, id, player, (class_1263)this, this.dataAccess);
    }

    private boolean hasShiningBlockAbove() {
        class_2338 checkPos;
        if (this.field_11863 != null && !this.field_11863.field_9236 && this.field_11863.method_8320(checkPos = this.field_11867.method_10084()).method_26167()) {
            for (int i = 0; i < 5; ++i) {
                class_2680 state = this.field_11863.method_8320(checkPos = checkPos.method_10084());
                if (state.method_26164(ModTags.Blocks.SOLAR_COOKER_SHINING)) {
                    return true;
                }
                if (state.method_26167()) continue;
                return false;
            }
        }
        return false;
    }

    public boolean isSunlit() {
        if (this.field_11863 != null) {
            if (!this.field_11863.field_9236) {
                return this.hasShiningBlockAbove() || this.field_11863.method_8597().comp_642() && this.field_11863.method_8530() && !this.field_11863.method_8419() && this.field_11863.method_8311(this.field_11867.method_10084());
            }
            return (Boolean)this.method_11010().method_11654((class_2769)SolarCookerBlock.SUNLIT);
        }
        return false;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public int getCookTimeTotal() {
        return this.cookTimeTotal;
    }

    protected void method_11014(@Nonnull class_11368 valueInput) {
        super.method_11014(valueInput);
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_11368)valueInput, this.items);
        this.cookTime = valueInput.method_71424("CookTime", 0);
        this.cookTimeTotal = valueInput.method_71424("CookTimeTotal", 200);
        this.updateShouldLidBeOpen(this.openersCounter.method_31678());
    }

    protected void method_11007(@Nonnull class_11372 valueOutput) {
        super.method_11007(valueOutput);
        valueOutput.method_71465("CookTime", this.cookTime);
        valueOutput.method_71465("CookTimeTotal", this.cookTimeTotal);
        class_1262.method_5426((class_11372)valueOutput, this.items);
    }

    @Nonnull
    public class_2487 method_16887(@Nonnull class_7225.class_7874 provider) {
        return this.method_38244(provider);
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, SolarCookerBlockEntity entity) {
        if (level != null) {
            boolean isBurning;
            boolean dirty = false;
            entity.updateReflectorStates();
            boolean isSunlit = entity.isSunlit();
            if (isSunlit && !((class_1799)entity.items.get(0)).method_7960()) {
                class_8786<? extends class_1874> recipe = entity.getRecipe();
                if (entity.canSmelt(level.method_30349(), recipe)) {
                    ++entity.cookTime;
                    if (entity.cookTime == entity.cookTimeTotal) {
                        entity.cookTime = 0;
                        entity.cookTimeTotal = entity.getRecipeCookTime();
                        if (!level.field_9236) {
                            entity.smeltItem(level.method_30349(), recipe);
                            dirty = true;
                        }
                    }
                } else {
                    entity.cookTime = 0;
                }
            } else if (!isSunlit && entity.cookTime > 0) {
                entity.cookTime = class_3532.method_15340((int)(entity.cookTime - 2), (int)0, (int)entity.cookTimeTotal);
            }
            boolean bl = isBurning = entity.cookTime > 0;
            if (!(level.field_9236 || (Boolean)state.method_11654((class_2769)SolarCookerBlock.BURNING) == isBurning && (Boolean)state.method_11654((class_2769)SolarCookerBlock.SUNLIT) == isSunlit && (Boolean)state.method_11654((class_2769)SolarCookerBlock.LEFT_REFLECTOR) == entity.reflectorLeft && (Boolean)state.method_11654((class_2769)SolarCookerBlock.RIGHT_REFLECTOR) == entity.reflectorRight)) {
                dirty = true;
                level.method_8652(entity.field_11867, (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)SolarCookerBlock.SUNLIT, (Comparable)Boolean.valueOf(isSunlit))).method_11657((class_2769)SolarCookerBlock.BURNING, (Comparable)Boolean.valueOf(isBurning))).method_11657((class_2769)SolarCookerBlock.LEFT_REFLECTOR, (Comparable)Boolean.valueOf(entity.reflectorLeft))).method_11657((class_2769)SolarCookerBlock.RIGHT_REFLECTOR, (Comparable)Boolean.valueOf(entity.reflectorRight)), 3);
            }
            if (dirty) {
                entity.method_5431();
                SolarCookerBlockEntity.signalOpenCount(level, pos, state, entity.openersCounter.method_31678(), true);
            }
        }
    }

    public boolean shouldLidBeOpen(int numPlayersUsing) {
        boolean recipeActive = this.cookTime > 0 || this.method_10997() != null && this.canSmelt(this.method_10997().method_30349(), this.getRecipe());
        return numPlayersUsing > 0 || recipeActive && this.isSunlit();
    }

    public void updateShouldLidBeOpen(int numPlayersUsing) {
        this.isLidOpen = this.shouldLidBeOpen(numPlayersUsing);
        this.chestLidController.method_31674(this.isLidOpen);
    }

    public static void lidAnimateTick(class_1937 level, class_2338 pos, class_2680 state, SolarCookerBlockEntity blockEntity) {
        blockEntity.chestLidController.method_31672();
        blockEntity.updateReflectorStates();
    }

    public boolean method_11004(int id, int numPlayersUsing) {
        if (id == 1) {
            this.updateShouldLidBeOpen(numPlayersUsing);
            return true;
        }
        return super.method_11004(id, numPlayersUsing);
    }

    public void method_5435(@Nonnull class_1657 player) {
        if (!this.field_11865 && !player.method_7325() && this.method_10997() != null) {
            this.openersCounter.method_31684(player, this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public void method_5432(@Nonnull class_1657 player) {
        if (!this.field_11865 && !player.method_7325() && this.method_10997() != null) {
            this.openersCounter.method_31685(player, this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public void recheckOpen() {
        if (!this.field_11865 && this.method_10997() != null) {
            this.openersCounter.method_31686(this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public static void signalOpenCount(class_1937 level, class_2338 pos, class_2680 state, int numPlayersUsing, boolean playSound) {
        SolarCookerBlockEntity blockEntity;
        class_2586 class_25862;
        if (playSound && numPlayersUsing < 1 && (class_25862 = level.method_8321(pos)) instanceof SolarCookerBlockEntity && blockEntity.isLidOpen != (blockEntity = (SolarCookerBlockEntity)class_25862).shouldLidBeOpen(numPlayersUsing)) {
            if (blockEntity.isLidOpen) {
                SolarCookerBlockEntity.playSound(blockEntity.field_11863, blockEntity.method_11016(), class_3417.field_14823);
            } else {
                SolarCookerBlockEntity.playSound(blockEntity.field_11863, blockEntity.method_11016(), class_3417.field_14982);
            }
        }
        class_2248 block = state.method_26204();
        level.method_8427(pos, block, 1, numPlayersUsing);
    }

    public static void playSound(class_1937 level, class_2338 pos, class_3414 soundEvent) {
        if (level != null && !level.field_9236) {
            double x = (double)pos.method_10263() + 0.5;
            double y = (double)pos.method_10264() + 0.5;
            double z = (double)pos.method_10260() + 0.5;
            level.method_43128(null, x, y, z, soundEvent, class_3419.field_15245, 0.5f, level.field_9229.method_43057() * 0.1f + 0.9f);
        }
    }

    protected boolean canSmelt(class_5455 registryAccess, @Nullable class_8786<?> recipe) {
        class_1874 cookingRecipe;
        class_1799 recipeOutput;
        class_1860 class_18602;
        if (!((class_1799)this.items.get(0)).method_7960() && recipe != null && (class_18602 = recipe.comp_1933()) instanceof class_1874 && !(recipeOutput = (cookingRecipe = (class_1874)class_18602).method_59998(new class_9696((class_1799)this.items.get(0)), (class_7225.class_7874)registryAccess)).method_7960()) {
            class_1799 output = (class_1799)this.items.get(1);
            if (output.method_7960()) {
                return true;
            }
            if (!class_1799.method_7984((class_1799)output, (class_1799)recipeOutput)) {
                return false;
            }
            return output.method_7947() + recipeOutput.method_7947() <= output.method_7914();
        }
        return false;
    }

    private void smeltItem(class_5455 registryAccess, @Nullable class_8786<?> recipe) {
        class_1860 class_18602;
        if (recipe != null && this.canSmelt(registryAccess, recipe) && (class_18602 = recipe.comp_1933()) instanceof class_1874) {
            class_1874 cookingRecipe = (class_1874)class_18602;
            class_1799 itemstack = (class_1799)this.items.get(0);
            class_1799 itemstack1 = cookingRecipe.method_59998(new class_9696(itemstack), (class_7225.class_7874)registryAccess);
            class_1799 itemstack2 = (class_1799)this.items.get(1);
            if (itemstack2.method_7960()) {
                this.items.set(1, (Object)itemstack1.method_7972());
            } else if (itemstack2.method_7909() == itemstack1.method_7909()) {
                itemstack2.method_7933(itemstack1.method_7947());
            }
            if (this.field_11863 != null && !this.field_11863.field_9236) {
                this.method_7662(recipe);
            }
            itemstack.method_7934(1);
        }
    }

    protected int getRecipeCookTime() {
        double reflectorFactor;
        class_8786<? extends class_1874> rec = this.getRecipe();
        if (rec == null) {
            return 200;
        }
        int reflectorCount = this.getReflectorCount();
        double d = reflectorFactor = reflectorCount > 0 ? 1.0 - (1.0 - Services.CONFIG.getMaxReflectorTimeFactor()) / (double)SLOTS_REFLECTORS.length * (double)reflectorCount : 1.0;
        if (this.specificRecipeType.getClass().isInstance(((class_1874)rec.comp_1933()).method_17716())) {
            return (int)((double)((class_1874)rec.comp_1933()).method_8167() * reflectorFactor);
        }
        return (int)((double)((class_1874)rec.comp_1933()).method_8167() * (Services.CONFIG.getCookTimeFactor() * reflectorFactor));
    }

    protected class_8786<? extends class_1874> getRecipe() {
        class_1799 input = this.method_5438(0);
        if (input.method_7960() || input == this.failedMatch) {
            return null;
        }
        class_9696 recipeInput = new class_9696(input);
        if (this.field_11863 != null && this.curRecipe != null && ((class_1874)this.curRecipe.comp_1933()).method_64719(recipeInput, this.field_11863)) {
            return this.curRecipe;
        }
        class_8786 rec = null;
        if (this.field_11863 != null && this.field_11863.method_8503() != null && (rec = (class_8786)this.field_11863.method_8503().method_3772().method_8132(this.specificRecipeType, (class_9695)recipeInput, this.field_11863).orElse(null)) == null && Services.CONFIG.areVanillaRecipesEnabled()) {
            rec = this.field_11863.method_8503().method_3772().method_8126().stream().filter(recipe -> recipe.comp_1933().method_17716() == Services.CONFIG.getRecipeType()).filter(recipe -> recipe.comp_1933() instanceof class_1874).map(recipe -> recipe).filter(recipe -> ((class_1874)recipe.comp_1933()).method_64719(recipeInput, this.field_11863)).filter(recipe -> Services.CONFIG.isRecipeAllowed(recipe.comp_1932().method_29177())).findFirst().orElse(null);
        }
        this.failedMatch = rec == null ? input : class_1799.field_8037;
        this.curRecipe = rec;
        return this.curRecipe;
    }

    private boolean slotContainsReflector(int slot) {
        return this.method_5438(slot).method_31573(ModTags.Items.SOLAR_COOKER_REFLECTOR);
    }

    private int getReflectorCount() {
        int count = 0;
        for (int slot : SLOTS_REFLECTORS) {
            if (!this.slotContainsReflector(slot)) continue;
            ++count;
        }
        return count;
    }

    private void updateReflectorStates() {
        boolean slotValue = this.slotContainsReflector(2);
        if (this.reflectorLeft != slotValue) {
            this.reflectorLeft = slotValue;
        }
        if (this.reflectorRight != (slotValue = this.slotContainsReflector(3))) {
            this.reflectorRight = slotValue;
        }
    }

    public boolean hasLeftReflector() {
        return this.reflectorLeft;
    }

    public boolean hasRightReflector() {
        return this.reflectorRight;
    }

    @Nonnull
    public int[] method_5494(@Nonnull class_2350 side) {
        if (side == class_2350.field_11036) {
            return SLOTS_UP;
        }
        return SLOTS;
    }

    public boolean method_5492(int index, @Nonnull class_1799 itemStackIn, @Nullable class_2350 direction) {
        return this.method_5437(index, itemStackIn);
    }

    public boolean method_5493(int index, @Nonnull class_1799 stack, @Nullable class_2350 direction) {
        return direction != class_2350.field_11036 && index == 1;
    }

    public int method_5439() {
        return this.items.size();
    }

    public boolean method_5442() {
        for (class_1799 itemstack : this.items) {
            if (itemstack.method_7960()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    protected class_2371<class_1799> method_11282() {
        return this.items;
    }

    @Nonnull
    public class_1799 method_5438(int index) {
        return (class_1799)this.items.get(index);
    }

    @Nonnull
    public class_1799 method_5434(int index, int count) {
        return class_1262.method_5430(this.items, (int)index, (int)count);
    }

    @Nonnull
    public class_1799 method_5441(int index) {
        return class_1262.method_5428(this.items, (int)index);
    }

    protected void method_11281(@Nonnull class_2371<class_1799> nonNullList) {
        this.items = nonNullList;
    }

    public void method_5447(int index, class_1799 stack) {
        class_1799 itemstack = (class_1799)this.items.get(index);
        boolean flag = !stack.method_7960() && class_1799.method_31577((class_1799)itemstack, (class_1799)stack);
        this.items.set(index, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        if (index == 0 && !flag) {
            this.cookTimeTotal = this.getRecipeCookTime();
            this.cookTime = 0;
            this.method_5431();
        }
    }

    public boolean method_5443(@Nonnull class_1657 player) {
        if (this.field_11863 != null && this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public boolean method_5437(int index, @Nonnull class_1799 stack) {
        return index == 0;
    }

    public void method_5448() {
        this.items.clear();
    }

    public void method_7662(@Nullable class_8786<?> recipe) {
        if (recipe != null) {
            this.usedRecipes.addTo((Object)recipe.comp_1932(), 1);
        }
    }

    @Nullable
    public class_8786<?> method_7663() {
        return null;
    }

    public void awardUsedRecipesAndPopExperience(class_1657 p_235645_1_) {
        List<class_8786<?>> list = this.getRecipesToAwardAndPopExperience(p_235645_1_.method_37908(), p_235645_1_.method_19538());
        p_235645_1_.method_7254(list);
        this.usedRecipes.clear();
    }

    public List<class_8786<?>> getRecipesToAwardAndPopExperience(class_1937 p_235640_1_, class_243 p_235640_2_) {
        ArrayList list = Lists.newArrayList();
        if (p_235640_1_.method_8503() != null) {
            for (Object2IntMap.Entry entry : this.usedRecipes.object2IntEntrySet()) {
                p_235640_1_.method_8503().method_3772().method_8130((class_5321)entry.getKey()).ifPresent(recipeHolder -> {
                    list.add(recipeHolder);
                    SolarCookerBlockEntity.createExperience(p_235640_1_, p_235640_2_, entry.getIntValue(), ((class_1874)recipeHolder.comp_1933()).method_8171());
                });
            }
        }
        return list;
    }

    private static void createExperience(class_1937 p_235641_0_, class_243 p_235641_1_, int p_235641_2_, float p_235641_3_) {
        int i = class_3532.method_15375((float)((float)p_235641_2_ * p_235641_3_));
        float f = class_3532.method_22450((float)((float)p_235641_2_ * p_235641_3_));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        while (i > 0) {
            int j = class_1303.method_5918((int)i);
            i -= j;
            p_235641_0_.method_8649((class_1297)new class_1303(p_235641_0_, p_235641_1_.field_1352, p_235641_1_.field_1351, p_235641_1_.field_1350, j));
        }
    }

    public void method_7683(@Nonnull class_9875 stackedContents) {
        for (class_1799 itemstack : this.items) {
            stackedContents.method_61541(itemstack);
        }
    }

    public float method_11274(float partialTicks) {
        return this.chestLidController.method_31673(partialTicks);
    }
}

