/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.solarcooker.client;

import de.cech12.solarcooker.Constants;
import de.cech12.solarcooker.inventory.SolarCookerContainer;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SolarCookerScreen
extends AbstractContainerScreen<SolarCookerContainer> {
    private static final ResourceLocation guiTexture = Constants.id("textures/gui/container/solar_cooker.png");
    private static final ResourceLocation litSprite = Constants.id("container/solarcooker/lit");
    private static final ResourceLocation burnProgressSprite = Constants.id("container/solarcooker/burn_progress");
    private static final ResourceLocation sunlightSprite = Constants.id("container/solarcooker/sunlight");

    public SolarCookerScreen(SolarCookerContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
    }

    public void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(@Nonnull GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        if (this.minecraft != null) {
            int left = this.leftPos;
            int top = this.topPos;
            guiGraphics.blit(RenderType::guiTextured, guiTexture, left, top, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
            if (((SolarCookerContainer)this.menu).isBurning()) {
                guiGraphics.blitSprite(RenderType::guiTextured, litSprite, 14, 14, 0, 0, left + 56, top + 36, 14, 14);
            }
            int progress = ((SolarCookerContainer)this.menu).getCookProgressionScaled();
            guiGraphics.blitSprite(RenderType::guiTextured, burnProgressSprite, 24, 16, 0, 0, left + 79, top + 34, progress, 16);
            if (((SolarCookerContainer)this.menu).isSunlit()) {
                guiGraphics.blitSprite(RenderType::guiTextured, sunlightSprite, 18, 18, 0, 0, left + 55, top + 52, 18, 18);
            }
        }
    }
}

