/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.solarcooker.init;

import de.cech12.solarcooker.Constants;
import de.cech12.solarcooker.item.ReflectorItem;
import de.cech12.solarcooker.item.ShiningDiamondItem;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"solarcooker");

    private static ResourceKey<Item> id(String name) {
        return ResourceKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)Constants.id(name));
    }

    private static RegistryObject<Item> item(String name, Supplier<Item> itemSupplier) {
        return ITEMS.register(name, itemSupplier);
    }

    private static RegistryObject<Item> shiningDiamondItem(String name, Supplier<Block> block) {
        return ModItems.item(name, () -> new ShiningDiamondItem((Block)block.get(), new Item.Properties().setId(ModItems.id(name))));
    }

    private static RegistryObject<Item> solarCookerItem() {
        return ModItems.item("solar_cooker", () -> new BlockItem(Constants.SOLAR_COOKER_BLOCK.get(), new Item.Properties().setId(ModItems.id("solar_cooker"))));
    }

    static {
        Constants.SOLAR_COOKER_ITEM = ModItems.solarCookerItem();
        Constants.REFLECTOR_ITEM = ModItems.item("reflector", () -> new ReflectorItem(new Item.Properties().setId(ModItems.id("reflector"))));
        Constants.SHINING_DIAMOND_BLOCK_ITEM = ModItems.shiningDiamondItem("shining_diamond_block", Constants.SHINING_DIAMOND_BLOCK_BLOCK);
    }
}

