/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.solarcooker;

import de.cech12.solarcooker.CommonLoader;
import de.cech12.solarcooker.Constants;
import de.cech12.solarcooker.client.SolarCookerBlockEntityRenderer;
import de.cech12.solarcooker.client.SolarCookerScreen;
import de.cech12.solarcooker.init.ModBlockEntityTypes;
import de.cech12.solarcooker.init.ModBlocks;
import de.cech12.solarcooker.init.ModItems;
import de.cech12.solarcooker.init.ModMenuTypes;
import de.cech12.solarcooker.init.ModRecipeTypes;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;

@Mod(value="solarcooker")
@EventBusSubscriber(modid="solarcooker", bus=EventBusSubscriber.Bus.MOD)
public class NeoForgeSolarCookerMod {
    public NeoForgeSolarCookerMod(IEventBus eventBus) {
        ModBlocks.BLOCKS.register(eventBus);
        ModBlockEntityTypes.BLOCK_ENTITY_TYPES.register(eventBus);
        ModItems.ITEMS.register(eventBus);
        ModRecipeTypes.RECIPE_TYPES.register(eventBus);
        ModRecipeTypes.RECIPE_SERIALIZERS.register(eventBus);
        ModMenuTypes.MENU_TYPES.register(eventBus);
        CommonLoader.init();
    }

    @SubscribeEvent
    public static void onClientRegister(FMLClientSetupEvent event) {
        BlockEntityRenderers.register(Constants.SOLAR_COOKER_ENTITY_TYPE.get(), SolarCookerBlockEntityRenderer::new);
    }

    @SubscribeEvent
    public static void onMenuScreenRegister(RegisterMenuScreensEvent event) {
        event.register(Constants.SOLAR_COOKER_MENU_TYPE.get(), SolarCookerScreen::new);
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, Constants.SOLAR_COOKER_ENTITY_TYPE.get(), SidedInvWrapper::new);
    }

    @SubscribeEvent
    public static void addItemsToTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            event.accept((ItemLike)Constants.SOLAR_COOKER_ITEM.get());
            event.accept((ItemLike)Constants.REFLECTOR_ITEM.get());
            event.accept((ItemLike)Constants.SHINING_DIAMOND_BLOCK_ITEM.get());
        }
    }
}

