/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.dye_depot.data;

import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.ninni.dye_depot.registry.DyedHolders;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ModCompat {
    public static final String SUPPLEMENTARIES = "supplementaries";
    public static final String SUPPLEMENTARIES_SQUARED = "suppsquared";

    public static <T> DyedHolders<T, T> supplementariesHolders(HolderLookup.RegistryLookup<T> registry, String name) {
        return ModCompat.supplementariesHolders(registry, name, DyedHolders.modColors());
    }

    public static <T> DyedHolders<T, T> supplementariesHolders(HolderLookup.RegistryLookup<T> registry, String name, Stream<DyeColor> colors) {
        return DyedHolders.fromRegistry(registry, colors, color -> ResourceLocation.fromNamespaceAndPath((String)SUPPLEMENTARIES, (String)(name + "_" + String.valueOf(color))));
    }

    public static <T> DyedHolders<T, T> supplementariesSquaredHolders(HolderLookup.RegistryLookup<T> registry, String name) {
        return ModCompat.supplementariesSquaredHolders(registry, name, DyedHolders.modColors());
    }

    public static <T> DyedHolders<T, T> supplementariesSquaredHolders(HolderLookup.RegistryLookup<T> registry, String name, Stream<DyeColor> colors) {
        return DyedHolders.fromRegistry(registry, colors, color -> ResourceLocation.fromNamespaceAndPath((String)SUPPLEMENTARIES_SQUARED, (String)(name + "_" + String.valueOf(color))));
    }

    public static ICondition[] supplementariesFlag(String flag) {
        ResourceKey serializerId = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.CONDITION_CODECS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)SUPPLEMENTARIES, (String)"flag"));
        MapCodec serializer = (MapCodec)NeoForgeRegistries.CONDITION_SERIALIZERS.getOrThrow(serializerId);
        JsonObject supplementariesJson = new JsonObject();
        supplementariesJson.addProperty("type", serializerId.location().toString());
        supplementariesJson.addProperty("flag", flag);
        return new ICondition[]{new ModLoadedCondition(SUPPLEMENTARIES), (ICondition)serializer.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)supplementariesJson).getOrThrow()};
    }
}

