/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.dye_depot.data.server;

import com.ninni.dye_depot.DyeDepot;
import com.ninni.dye_depot.data.ModCompat;
import com.ninni.dye_depot.registry.DDBlocks;
import com.ninni.dye_depot.registry.DDDyes;
import com.ninni.dye_depot.registry.DDItems;
import com.ninni.dye_depot.registry.DDTags;
import com.ninni.dye_depot.registry.DyedHolders;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.fabric.impl.resource.conditions.conditions.AnyModsLoadedResourceCondition;
import net.fabricmc.fabric.impl.resource.conditions.conditions.NotResourceCondition;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2073;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2454;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_7924;
import net.minecraft.class_8790;

public class DDRecipes
extends FabricRecipeProvider {
    private final DyedHolders<class_1792, class_1792> dyes;
    private final class_7225.class_7226<class_2248> blockLookup;
    private final class_7225.class_7226<class_1792> itemLookup;

    public DDRecipes(FabricDataOutput output, CompletableFuture<class_7225.class_7874> lookupFuture) {
        super(output, lookupFuture);
        class_7225.class_7874 lookup = lookupFuture.join();
        this.dyes = DDItems.DYES.mergeVanilla((class_7225.class_7226<class_1792>)lookup.method_46762(class_7924.field_41197));
        this.blockLookup = lookup.method_46762(class_7924.field_41254);
        this.itemLookup = lookup.method_46762(class_7924.field_41197);
    }

    public void method_10419(class_8790 output) {
        String namespace = "dye_depot:";
        DDBlocks.BANNERS.forEach((dye, block) -> DDRecipes.method_24889((class_8790)output, (class_1935)((class_1935)block.comp_349()), (class_1935)((class_1935)DDBlocks.WOOL.getOrThrow((class_1767)dye))));
        this.dyeing(output, class_7800.field_40635, DDBlocks.BEDS.mergeVanilla(this.blockLookup), (class_6862<class_1792>)class_3489.field_16444);
        DDBlocks.BEDS.forEach((dye, block) -> DDRecipes.method_24887((class_8790)output, (class_1935)((class_1935)block.comp_349()), (class_1935)((class_1935)DDBlocks.WOOL.getOrThrow((class_1767)dye))));
        DDBlocks.CANDLES.forEach((dye, block) -> DDRecipes.method_32233((class_8790)output, (class_1935)((class_1935)block.comp_349()), (class_1935)((class_1935)this.dyes.getOrThrow((class_1767)dye))));
        this.dyeing(output, class_7800.field_40635, DDBlocks.CARPETS.mergeVanilla(this.blockLookup), (class_6862<class_1792>)class_3489.field_15542);
        DDBlocks.CARPETS.forEach((dye, block) -> DDRecipes.method_24885((class_8790)output, (class_1935)((class_1935)block.comp_349()), (class_1935)((class_1935)DDBlocks.WOOL.getOrThrow((class_1767)dye))));
        DDBlocks.CONCRETE_POWDER.forEach((dye, block) -> DDRecipes.method_24894((class_8790)output, (class_1935)((class_1935)block.comp_349()), (class_1935)((class_1935)this.dyes.getOrThrow((class_1767)dye))));
        DDBlocks.GLAZED_TERRACOTTA.forEach((dye, block) -> DDRecipes.method_34662((class_8790)output, (class_1935)((class_1935)block.comp_349()), (class_1935)((class_1935)DDBlocks.TERRACOTTA.getOrThrow((class_1767)dye))));
        DDBlocks.STAINED_GLASS.forEach((dye, block) -> DDRecipes.method_24890((class_8790)output, (class_1935)((class_1935)block.comp_349()), (class_1935)((class_1935)this.dyes.getOrThrow((class_1767)dye))));
        DDBlocks.STAINED_GLASS_PANES.forEach((dye, block) -> {
            class_1792 dyeItem = this.dyes.getOrThrow((class_1767)dye);
            class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)((class_1935)block.comp_349()), (int)8).method_10434(Character.valueOf('#'), (class_1935)class_2246.field_10285).method_10434(Character.valueOf('$'), (class_1935)dyeItem).method_10439("###").method_10439("#$#").method_10439("###").method_10435("stained_glass_pane").method_10429("has_glass_pane", DDRecipes.method_10426((class_1935)class_2246.field_10285)).method_10429(DDRecipes.method_32807((class_1935)dyeItem), DDRecipes.method_10426((class_1935)dyeItem)).method_36443(output, namespace + DDRecipes.method_33714((class_1935)((class_1935)block.comp_349()), (class_1935)class_2246.field_10285));
            DDRecipes.method_24891((class_8790)output, (class_1935)((class_1935)block.comp_349()), (class_1935)((class_1935)DDBlocks.STAINED_GLASS.getOrThrow((class_1767)dye)));
        });
        DDBlocks.TERRACOTTA.forEach((dye, block) -> DDRecipes.method_24893((class_8790)output, (class_1935)((class_1935)block.comp_349()), (class_1935)((class_1935)this.dyes.getOrThrow((class_1767)dye))));
        DDBlocks.DYE_BASKETS.forEach((dye, block) -> DDRecipes.method_36447((class_8790)output, (class_7800)class_7800.field_40642, (class_1935)((class_1935)this.dyes.getOrThrow((class_1767)dye)), (class_7800)class_7800.field_40635, (class_1935)((class_1935)block.comp_349()), (String)(namespace + DDRecipes.method_33716((class_1935)((class_1935)block.comp_349()))), null, (String)(namespace + String.valueOf(dye) + "_dye_from_basket"), (String)(String.valueOf(dye) + "_dye")));
        this.dyeing(output, class_7800.field_40642, DDBlocks.WOOL, (class_6862<class_1792>)class_3489.field_15544);
        this.dyeConversion(output, DDDyes.AMBER.get(), (class_1935)class_1802.field_28659, 1);
        this.dyeConversion(output, DDDyes.AMBER.get(), (class_1935)class_1802.field_20414, 2);
        this.dyeConversion(output, DDDyes.AQUA.get(), (class_1935)class_1802.field_28410, 1);
        this.dyeConversion(output, DDDyes.BEIGE.get(), (class_1935)class_1802.field_17512, 1);
        this.dyeConversion(output, DDDyes.CORAL.get(), (class_1935)class_1802.field_8864, 2);
        this.dyeSmelting(output, DDDyes.CORAL.get(), DDTags.SMELTS_INTO_CORAL_DYE);
        this.dyeConversion(output, DDDyes.FOREST.get(), (class_1935)class_1802.field_8648, 1);
        this.dyeSmelting(output, DDDyes.GINGER.get(), (class_1935)class_1802.field_17518);
        this.dyeConversion(output, DDDyes.MAROON.get(), (class_1935)class_1802.field_8680, 1);
        this.dyeConversion(output, DDDyes.OLIVE.get(), (class_1935)class_1802.field_8635, 1);
        this.dyeConversion(output, DDDyes.TAN.get(), (class_1935)class_1802.field_8601, 1);
        this.dyeConversion(output, DDDyes.VERDANT.get(), (class_1935)class_1802.field_8551, 1);
        this.dyeSmelting(output, DDDyes.VERDANT.get(), (class_1935)class_1802.field_17523);
        this.dyeConversion(output, DDDyes.ROSE.get(), (class_1935)class_1802.field_17527, 2);
        this.dyeSmelting(output, DDDyes.TEAL.get(), (class_1935)class_1802.field_8662);
        this.dyeMixing(output, class_1767.field_7963, class_1767.field_7944, class_1767.field_7963);
        this.dyeMixing(output, class_1767.field_7963, class_1767.field_7967, class_1767.field_7963, class_1767.field_7963);
        this.dyeMixing(output, class_1767.field_7963, class_1767.field_7952, class_1767.field_7963, class_1767.field_7963, class_1767.field_7963);
        this.dyeMixing(output, class_1767.field_7944, class_1767.field_7967, class_1767.field_7963);
        this.dyeMixing(output, class_1767.field_7944, class_1767.field_7952, class_1767.field_7963, class_1767.field_7963);
        this.dyeMixing(output, class_1767.field_7952, class_1767.field_7963, class_1767.field_7952, class_1767.field_7952, class_1767.field_7952);
        this.dyeMixing(output, class_1767.field_7952, class_1767.field_7944, class_1767.field_7952, class_1767.field_7952);
        this.dyeMixing(output, class_1767.field_7952, class_1767.field_7967, class_1767.field_7952);
        this.dyeColorSpectrum(output, DDDyes.CORAL.get(), class_1767.field_7964, class_1767.field_7945, DDDyes.ROSE.get(), DDDyes.MAROON.get());
        this.dyeColorSpectrum(output, DDDyes.AQUA.get(), class_1767.field_7955, class_1767.field_7942, DDDyes.MINT.get(), DDDyes.TEAL.get());
        this.dyeColorSpectrum(output, class_1767.field_7961, class_1767.field_7942, class_1767.field_7947, DDDyes.FOREST.get(), DDDyes.VERDANT.get());
        this.dyeColorSpectrum(output, class_1767.field_7954, class_1767.field_7958, class_1767.field_7966, class_1767.field_7945, DDDyes.INDIGO.get());
        this.dyeColorSpectrum(output, class_1767.field_7951, class_1767.field_7966, class_1767.field_7955, DDDyes.SLATE.get(), DDDyes.NAVY.get());
        this.dyeColorSpectrum(output, DDDyes.TAN.get(), class_1767.field_7946, class_1767.field_7964, DDDyes.GINGER.get(), class_1767.field_7957);
        this.dyeColorSpectrum(output, DDDyes.BEIGE.get(), class_1767.field_7947, class_1767.field_7946, DDDyes.AMBER.get(), DDDyes.OLIVE.get());
        this.dyeMixing(output, class_1767.field_7942, class_1767.field_7966, class_1767.field_7947);
        this.dyeMixing(output, class_1767.field_7958, DDDyes.INDIGO.get(), class_1767.field_7951);
        this.disable(output, class_2960.method_60656((String)"gray_dye"));
        this.disable(output, class_2960.method_60656((String)"light_gray_dye_from_oxeye_daisy"));
        this.disable(output, class_2960.method_60656((String)"magenta_dye_from_blue_red_pink"));
        this.disable(output, class_2960.method_60656((String)"magenta_dye_from_blue_red_white_dye"));
        this.disable(output, class_2960.method_60656((String)"magenta_dye_from_purple_and_pink"));
        this.disable(output, class_2960.method_60656((String)"pink_dye_from_red_white_dye"));
        this.disable(output, class_2960.method_60656((String)"purple_dye"));
        this.disable(output, class_2960.method_60656((String)"red_dye_from_rose_bush"));
        ModCompat.supplementariesHolders(this.itemLookup, "candle_holder").forEach((dye, block) -> {
            class_2248 candle = DDBlocks.CANDLES.getOrThrow((class_1767)dye);
            class_2447.method_10437((class_7800)class_7800.field_40635, (class_1935)((class_1935)block.comp_349())).method_10439("NCN").method_10439(" N ").method_10434(Character.valueOf('C'), (class_1935)candle).method_10434(Character.valueOf('N'), (class_1935)class_1802.field_8620).method_10435("candle_holder").method_10429("has_candle", DDRecipes.method_10426((class_1935)candle)).method_10431(this.withConditions(output, new ResourceCondition[]{ModCompat.supplementariesFlag("candle_holder")}));
        });
        ModCompat.supplementariesSquaredHolders(this.itemLookup, "gold_candle_holder").forEach((dye, block) -> {
            class_2248 candle = DDBlocks.CANDLES.getOrThrow((class_1767)dye);
            class_2447.method_10437((class_7800)class_7800.field_40635, (class_1935)((class_1935)block.comp_349())).method_10439("C").method_10439("N").method_10434(Character.valueOf('C'), (class_1935)candle).method_10434(Character.valueOf('N'), (class_1935)class_1802.field_8695).method_10435("gold_candle_holder").method_10429("has_candle", DDRecipes.method_10426((class_1935)candle)).method_10431(this.withConditions(output, new ResourceCondition[]{ModCompat.supplementariesFlag("candle_holder")}));
        });
        ModCompat.supplementariesHolders(this.itemLookup, "flag").forEach((dye, block) -> {
            class_2248 wool = DDBlocks.WOOL.getOrThrow((class_1767)dye);
            class_2447.method_10437((class_7800)class_7800.field_40635, (class_1935)((class_1935)block.comp_349())).method_10439("###").method_10439("###").method_10439("|  ").method_10434(Character.valueOf('#'), (class_1935)wool).method_10434(Character.valueOf('|'), (class_1935)class_1802.field_8600).method_10435("flag").method_10429("has_wool", DDRecipes.method_10426((class_1935)wool)).method_10431(this.withConditions(output, new ResourceCondition[]{ModCompat.supplementariesFlag("flag")}));
        });
    }

    private void dyeConversion(class_8790 output, class_1767 dye, class_1935 from, int amount) {
        class_1792 to = this.dyes.getOrThrow(dye);
        class_2450.method_10448((class_7800)class_7800.field_40642, (class_1935)to, (int)amount).method_10454(from).method_10452(String.valueOf(dye) + "_dye").method_10442(DDRecipes.method_32807((class_1935)from), DDRecipes.method_10426((class_1935)from)).method_17972(output, DyeDepot.modLoc(DDRecipes.method_33714((class_1935)to, (class_1935)from)));
    }

    private void dyeSmelting(class_8790 output, class_1767 dye, class_6862<class_1792> ingredient) {
        this.dyeSmelting(output, dye, class_1856.method_8106(ingredient), it -> it.method_10469(DDRecipes.getHasName(ingredient), DDRecipes.method_10420((class_6862)ingredient)));
    }

    private void dyeSmelting(class_8790 output, class_1767 dye, class_1935 ingredient) {
        this.dyeSmelting(output, dye, class_1856.method_8091((class_1935[])new class_1935[]{ingredient}), it -> it.method_10469(DDRecipes.method_32807((class_1935)ingredient), DDRecipes.method_10426((class_1935)ingredient)));
    }

    private void dyeSmelting(class_8790 output, class_1767 dye, class_1856 ingredient, UnaryOperator<class_2454> factory) {
        ((class_2454)factory.apply(class_2454.method_17802((class_1856)ingredient, (class_7800)class_7800.field_40642, (class_1935)((class_1935)this.dyes.getOrThrow(dye)), (float)0.1f, (int)200))).method_35917(String.valueOf(dye) + "_dye").method_17972(output, DyeDepot.modLoc(String.valueOf(dye) + "_dye_from_smelting"));
    }

    private void disable(class_8790 output, class_2960 id) {
        class_2450.method_10447((class_7800)class_7800.field_40642, (class_1935)class_1802.field_8688).method_10454((class_1935)class_1802.field_8688).method_10442("never", DDRecipes.method_10426((class_1935)class_1802.field_8688)).method_17972(this.withConditions(output, new ResourceCondition[]{new NotResourceCondition((ResourceCondition)new AnyModsLoadedResourceCondition(List.of("dye_depot")))}), id);
    }

    private void dyeing(class_8790 output, class_7800 category, DyedHolders<?, ? extends class_1935> dyed) {
        this.dyeing(output, category, dyed, class_1856.method_26964(dyed.values().map(class_1799::new)), builder -> builder.method_10442("has_base", DDRecipes.method_10423((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8977((class_1935[])dyed.values().toArray(class_1935[]::new)).method_8976()})));
    }

    private void dyeing(class_8790 output, class_7800 category, DyedHolders<?, ? extends class_1935> dyed, class_6862<class_1792> from) {
        this.dyeing(output, category, dyed, class_1856.method_8106(from), builder -> builder.method_10442(DDRecipes.getHasName(from), DDRecipes.method_10420((class_6862)from)));
    }

    private void dyeing(class_8790 output, class_7800 category, DyedHolders<?, ? extends class_1935> dyed, class_1856 from, UnaryOperator<class_2450> factory) {
        String group = dyed.detectBaseName();
        dyed.forEach((color, item) -> {
            class_2960 id = ((class_5321)item.method_40230().orElseThrow()).method_29177();
            class_1792 dye = this.dyes.getOrThrow((class_1767)color);
            ((class_2450)factory.apply(class_2450.method_10447((class_7800)category, (class_1935)((class_1935)item.comp_349())))).method_10451(from).method_10454((class_1935)dye).method_10452(group).method_10442(DDRecipes.method_32807((class_1935)dye), DDRecipes.method_10426((class_1935)dye)).method_17972(output, id.method_45138("dye_"));
        });
    }

    private void dyeColorSpectrum(class_8790 output, class_1767 light, class_1767 base, class_1767 aspect, class_1767 tinted, class_1767 dark) {
        this.lightBaseDark(output, light, base, dark);
        this.dyeHue(output, base, aspect, tinted);
        this.dyeMixing(output, light, tinted, class_1767.field_7952);
        this.dyeMixing(output, dark, tinted, class_1767.field_7963);
    }

    private void lightBaseDark(class_8790 output, class_1767 light, class_1767 base, class_1767 dark) {
        this.lightenAndDarken(output, light, base);
        this.lightenAndDarken(output, base, dark);
        this.dyeMixing(output, light, dark, class_1767.field_7952, class_1767.field_7952);
        this.dyeMixing(output, dark, light, class_1767.field_7963, class_1767.field_7963);
        this.dyeMixing(output, base, dark, light);
    }

    private void lightenAndDarken(class_8790 output, class_1767 light, class_1767 dark) {
        this.dyeMixing(output, light, dark, class_1767.field_7952);
        this.dyeMixing(output, dark, light, class_1767.field_7963);
    }

    private void dyeHue(class_8790 output, class_1767 base, class_1767 aspect, class_1767 result) {
        this.dyeMixing(output, result, base, aspect);
        this.dyeMixing(output, base, result, class_1767.field_7944);
        this.dyeMixing(output, base, result, class_1767.field_7967);
    }

    private void dyeMixing(class_8790 output, class_1767 to, class_1767 ... from) {
        class_1792 result = this.dyes.getOrThrow(to);
        class_2450 builder = class_2450.method_10448((class_7800)class_7800.field_40642, (class_1935)result, (int)from.length).method_10452(String.valueOf(to) + "_dye");
        HashSet<class_1767> unique = new HashSet<class_1767>();
        for (class_1767 color : from) {
            class_1792 item = this.dyes.getOrThrow(color);
            builder.method_10454((class_1935)item);
            if (!unique.add(color)) continue;
            builder.method_10442(DDRecipes.method_32807((class_1935)item), DDRecipes.method_10426((class_1935)item));
        }
        String name = DDRecipes.method_33716((class_1935)result) + "_from_" + unique.stream().sorted(Comparator.comparing(class_1767::method_7789)).map(class_1767::method_15434).collect(Collectors.joining("_and_"));
        builder.method_17972(output, DyeDepot.modLoc(name));
    }

    protected class_2960 getRecipeIdentifier(class_2960 id) {
        return id;
    }

    public static String getHasName(class_6862<?> tag) {
        return "has_" + tag.comp_327().method_12832();
    }
}

