/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.dye_depot.block;

import com.ninni.dye_depot.registry.DDParticles;
import com.ninni.dye_depot.registry.DDSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DyeBasketBlock
extends HorizontalDirectionalBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private DyeColor dyeColor;

    public DyeBasketBlock(DyeColor dyeColor, BlockBehaviour.Properties properties) {
        super(properties);
        this.dyeColor = dyeColor;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        super.m_7892_(blockState, level, blockPos, entity);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (serverLevel.f_46441_.m_188503_(15) == 0) {
                serverLevel.m_8767_((ParticleOptions)new BlockParticleOption((ParticleType)DDParticles.DYE_POOF.get(), blockState), entity.m_20185_(), entity.m_20186_() + 0.2, entity.m_20189_(), 1, 0.2, 0.2, 0.2, 1.0);
            }
        }
    }

    public void m_5581_(Level level, BlockState blockState, BlockHitResult blockHitResult, Projectile projectile) {
        super.m_5581_(level, blockState, blockHitResult, projectile);
        if (blockHitResult.m_82434_() == Direction.UP) {
            this.spawnParticles(level, blockHitResult.m_82425_(), blockState);
        }
    }

    public void m_142072_(Level level, BlockState blockState, BlockPos blockPos, Entity entity, float f) {
        super.m_142072_(level, blockState, blockPos, entity, f);
        this.spawnParticles(level, blockPos, blockState);
    }

    public void spawnParticles(Level level, BlockPos blockPos, BlockState state) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            level.m_5594_(null, blockPos, (SoundEvent)DDSoundEvents.DYE_BASKET_POOF.get(), SoundSource.BLOCKS, 1.5f, 1.0f);
            serverLevel.m_8767_((ParticleOptions)new BlockParticleOption((ParticleType)DDParticles.DYE_POOF.get(), state), (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 1.2, (double)blockPos.m_123343_() + 0.5, 60, 0.75, 0.2, 0.75, 3.0);
        }
    }

    public DyeColor getDyeColor() {
        return this.dyeColor;
    }

    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)blockPlaceContext.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    public VoxelShape m_7947_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return Shapes.m_83144_();
    }

    public VoxelShape m_5909_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return Shapes.m_83144_();
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return false;
    }

    public float m_7749_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return 0.2f;
    }
}

