/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.dye_depot.client;

import com.ninni.dye_depot.client.particles.PoofParticleProvider;
import com.ninni.dye_depot.registry.DDBlocks;
import com.ninni.dye_depot.registry.DDParticles;
import java.nio.file.Path;
import java.util.stream.Stream;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.PathPackResources;

@Mod.EventBusSubscriber(modid="dye_depot", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class DyeDepotClient {
    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        DyeDepotClient.registerModelLayers();
    }

    @SubscribeEvent
    public static void addResourcePacks(AddPackFindersEvent event) {
        if (event.getPackType() != PackType.CLIENT_RESOURCES) {
            return;
        }
        IModFile modFile = ModList.get().getModFileById("dye_depot").getFile();
        Path path = modFile.findResource(new String[]{"resourcepacks/dye_override"});
        try (PathPackResources pack = new PathPackResources(modFile.getFileName() + ":" + String.valueOf(path), true, path);){
            event.addRepositorySource(consumer -> consumer.accept(Pack.m_245429_((String)"builtin/dye_depot", (Component)Component.m_237113_((String)"Dye Overrides"), (boolean)false, ignored -> pack, (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_)));
        }
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)DDParticles.DYE_POOF.get(), PoofParticleProvider::new);
    }

    @SubscribeEvent
    public static void registerBlockRenderLayers(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)DDParticles.DYE_POOF.get(), PoofParticleProvider::new);
    }

    private static void registerModelLayers() {
        Stream.concat(DDBlocks.STAINED_GLASS.values(), DDBlocks.STAINED_GLASS_PANES.values()).forEach(it -> ItemBlockRenderTypes.setRenderLayer((Block)it, (RenderType)RenderType.m_110466_()));
    }
}

