/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.dye_depot.compat;

import com.ninni.dye_depot.DyeDepot;
import com.ninni.dye_depot.registry.DyedHolders;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;

@JeiPlugin
public class DyeDepotJei
implements IModPlugin {
    private static final ResourceLocation ID = DyeDepot.modLoc("jei");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List<CraftingRecipe> shulkerColoring = DyedHolders.modColors().map(this::createShulkerColoring).toList();
        registration.addRecipes(RecipeTypes.CRAFTING, shulkerColoring);
    }

    private CraftingRecipe createShulkerColoring(DyeColor color) {
        ItemStack baseShulkerStack = new ItemStack((ItemLike)Blocks.f_50456_);
        Ingredient baseShulkerIngredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{baseShulkerStack});
        Ingredient colorIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{DyeItem.m_41082_((DyeColor)color)});
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{baseShulkerIngredient, colorIngredient});
        ItemStack output = ShulkerBoxBlock.m_56250_((DyeColor)color);
        ResourceLocation id = new ResourceLocation("jei.shulker.color." + output.m_41778_());
        return new ShapelessRecipe(id, "jei.shulker.color", CraftingBookCategory.MISC, output, inputs);
    }
}

