/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.dye_depot.data.client;

import com.ninni.dye_depot.data.ModCompat;
import com.ninni.dye_depot.registry.DDBlocks;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PresentBlock;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class DDBlockModels
extends BlockStateProvider {
    private final CompletableFuture<HolderLookup.Provider> lookup;

    public DDBlockModels(PackOutput output, CompletableFuture<HolderLookup.Provider> lookup, ExistingFileHelper fileHelper) {
        super(output, "dye_depot", fileHelper);
        this.lookup = lookup;
    }

    protected void registerStatesAndModels() {
        HolderLookup.Provider lookup = this.lookup.join();
        HolderLookup.RegistryLookup blockLookup = lookup.m_255025_(Registries.f_256747_);
        DDBlocks.WOOL.values().forEach(arg_0 -> ((DDBlockModels)this).simpleBlock(arg_0));
        DDBlocks.CARPETS.forEach(this::carpet);
        DDBlocks.TERRACOTTA.values().forEach(arg_0 -> ((DDBlockModels)this).simpleBlock(arg_0));
        DDBlocks.CONCRETE.values().forEach(arg_0 -> ((DDBlockModels)this).simpleBlock(arg_0));
        DDBlocks.CONCRETE_POWDER.values().forEach(arg_0 -> ((DDBlockModels)this).simpleBlock(arg_0));
        DDBlocks.GLAZED_TERRACOTTA.holders().forEach(this::glazedTerracotta);
        DDBlocks.STAINED_GLASS.values().forEach(arg_0 -> ((DDBlockModels)this).simpleBlock(arg_0));
        DDBlocks.STAINED_GLASS_PANES.forEach(this::stainedGlassPane);
        DDBlocks.SHULKER_BOXES.holders().forEach(this::particleOnly);
        DDBlocks.CANDLES.holders().forEach(this::candle);
        DDBlocks.CANDLE_CAKES.forEach(this::candleCake);
        DDBlocks.BANNERS.holders().forEach(this::banner);
        DDBlocks.WALL_BANNERS.holders().forEach(this::banner);
        DDBlocks.BEDS.holders().forEach(this::bed);
        DDBlocks.DYE_BASKETS.holders().forEach(this::basket);
        ModCompat.supplementariesHolders(blockLookup, "flag").holders().forEach(this::flag);
        ModCompat.supplementariesHolders(blockLookup, "present").forEach(this::present);
        ModCompat.supplementariesHolders(blockLookup, "trapped_present").forEach(this::present);
        ModCompat.supplementariesHolders(blockLookup, "candle_holder").forEach(this::candleHolder);
        ModCompat.supplementariesSquaredHolders(blockLookup, "gold_candle_holder").forEach(this::candleHolder);
    }

    private void carpet(DyeColor color, Holder<? extends Block> block) {
        Holder<Block> wool = DDBlocks.WOOL.holderOrThrow(color);
        this.simpleBlock((Block)block.m_203334_(), (ModelFile)this.models().carpet(this.name(block), this.blockTexture(wool)));
    }

    private void glazedTerracotta(Holder<? extends Block> block) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.vanillaResource("template_glazed_terracotta"))).texture("pattern", this.blockTexture(block));
        this.horizontalBlock((Block)block.m_203334_(), (ModelFile)model);
    }

    private void stainedGlassPane(DyeColor color, Holder<? extends StainedGlassPaneBlock> block) {
        this.paneBlock((IronBarsBlock)block.m_203334_(), this.blockTexture(DDBlocks.STAINED_GLASS.getOrNull(color)), this.blockTexture(block).m_266382_("_top"));
    }

    private void particleOnly(Holder<? extends Block> block) {
        ResourceLocation texture = this.blockTexture(block);
        this.simpleBlock((Block)block.m_203334_(), (ModelFile)((BlockModelBuilder)this.models().getBuilder(this.name(block))).texture("particle", texture));
    }

    private void candle(Holder<? extends Block> block) {
        this.getVariantBuilder((Block)block.m_203334_()).forAllStatesExcept(state -> {
            Boolean lit = (Boolean)state.m_61143_((Property)CandleBlock.f_152791_);
            Integer count = (Integer)state.m_61143_((Property)CandleBlock.f_152790_);
            String litSuffix = lit != false ? "_lit" : "";
            String countSuffix = List.of("_candle", "_two_candles", "_three_candles", "_four_candles").get(count - 1);
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_" + count + litSuffix, this.vanillaResource("template" + countSuffix))).texture("all", String.valueOf(this.blockTexture(block)) + litSuffix)).texture("particle", String.valueOf(this.blockTexture(block)) + litSuffix);
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        }, new Property[]{BlockStateProperties.f_61362_});
    }

    private void candleCake(DyeColor color, Holder<? extends Block> block) {
        this.getVariantBuilder((Block)block.m_203334_()).forAllStates(state -> {
            Boolean lit = (Boolean)state.m_61143_((Property)CandleCakeBlock.f_152850_);
            String suffix = lit != false ? "_lit" : "";
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + suffix, this.vanillaResource("template_cake_with_candle"))).texture("candle", this.blockTexture(DDBlocks.CANDLES.getOrThrow(color)).m_266382_(suffix))).texture("bottom", this.vanillaResource("cake_bottom"))).texture("top", this.vanillaResource("cake_top"))).texture("side", this.vanillaResource("cake_side"))).texture("particle", this.vanillaResource("cake_side"));
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        });
    }

    private void banner(Holder<? extends Block> block) {
        this.simpleBlock((Block)block.m_203334_(), (ModelFile)this.models().getExistingFile(this.vanillaResource("banner")));
    }

    private void bed(Holder<? extends Block> block) {
        this.simpleBlock((Block)block.m_203334_(), (ModelFile)this.models().getExistingFile(this.vanillaResource("bed")));
    }

    private void basket(Holder<? extends Block> block) {
        ResourceLocation texture = this.blockTexture(block);
        BlockModelBuilder model = (BlockModelBuilder)this.models().orientableWithBottom(this.name(block), texture.m_266382_("_side"), texture.m_266382_("_front"), texture.m_266382_("_bottom"), texture.m_266382_("_top"));
        this.horizontalBlock((Block)block.m_203334_(), (ModelFile)model);
    }

    private void candleHolder(DyeColor color, Holder<? extends Block> block) {
        this.getVariantBuilder((Block)block.m_203334_()).forAllStatesExcept(state -> {
            Boolean lit = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_);
            Integer candles = (Integer)state.m_61143_((Property)BlockStateProperties.f_155994_);
            Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            AttachFace face = (AttachFace)state.m_61143_((Property)BlockStateProperties.f_61376_);
            String suffix = face.m_7912_() + "_" + candles;
            String litSuffix = lit != false ? "_lit" : "";
            String namespace = this.key(block).m_135827_();
            ResourceLocation parent = new ResourceLocation(namespace, "block/candle_holders/" + suffix);
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(namespace + ":block/candle_holders/" + String.valueOf(color) + "_" + suffix + litSuffix, parent)).texture("all", String.valueOf(this.blockTexture(DDBlocks.CANDLES.getOrNull(color))) + litSuffix);
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY((int)facing.m_122435_() + 180).build();
        }, new Property[]{BlockStateProperties.f_61362_});
    }

    private void flag(Holder<? extends Block> block) {
        this.simpleBlock((Block)block.m_203334_(), (ModelFile)this.models().getExistingFile(new ResourceLocation("supplementaries", "block/flag")));
    }

    private void present(DyeColor color, Holder<? extends Block> block) {
        String type = this.name(block).replace("_" + String.valueOf(color), "");
        this.getVariantBuilder((Block)block.m_203334_()).forAllStatesExcept(state -> {
            Boolean packed = (Boolean)state.m_61143_((Property)PresentBlock.PACKED);
            String suffix = packed != false ? "_closed" : "_opened";
            ResourceLocation parent = new ResourceLocation("supplementaries", "block/present" + suffix + "_template");
            ResourceLocation sideTexture = new ResourceLocation("supplementaries", "block/" + type + "s/side_" + String.valueOf(color));
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("supplementaries:block/" + type + "s/" + String.valueOf(color) + suffix, parent)).texture("bottom", new ResourceLocation("supplementaries", "block/presents/bottom_" + String.valueOf(color)))).texture("top", new ResourceLocation("supplementaries", "block/presents/top_" + String.valueOf(color)))).texture("side", sideTexture)).texture("particle", sideTexture);
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        }, new Property[]{BlockStateProperties.f_61362_});
    }

    private ResourceLocation vanillaResource(String name) {
        return new ResourceLocation("block/" + name);
    }

    private ResourceLocation key(Holder<? extends Block> block) {
        return ((ResourceKey)block.m_203543_().orElseThrow()).m_135782_();
    }

    private String name(Holder<? extends Block> block) {
        return this.key(block).m_135815_();
    }

    private ResourceLocation blockTexture(Holder<? extends Block> block) {
        return ((ResourceKey)block.m_203543_().orElseThrow()).m_135782_().m_246208_("block/");
    }
}

