/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.dye_depot.data.server;

import com.ninni.dye_depot.data.ModCompat;
import com.ninni.dye_depot.registry.DDBlocks;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;

public class DDBlockLoot
extends BlockLootSubProvider {
    private final CompletableFuture<HolderLookup.Provider> lookup;
    private final Collection<Block> knownBlocks = new HashSet<Block>();

    public DDBlockLoot(CompletableFuture<HolderLookup.Provider> lookup) {
        super(Set.of(), FeatureFlags.f_244280_.m_247355_());
        this.lookup = lookup;
    }

    public void m_245660_() {
        HolderLookup.Provider lookup = this.lookup.join();
        HolderLookup.RegistryLookup blockLookup = lookup.m_255025_(Registries.f_256747_);
        DDBlocks.BANNERS.values().forEach(this::dropBanner);
        DDBlocks.BEDS.values().forEach(this::dropBed);
        DDBlocks.CANDLES.values().forEach(this::dropCandle);
        DDBlocks.CANDLE_CAKES.values().forEach(this::dropCandleCake);
        DDBlocks.CARPETS.values().forEach(x$0 -> this.m_245724_((Block)x$0));
        DDBlocks.CONCRETE.values().forEach(x$0 -> this.m_245724_((Block)x$0));
        DDBlocks.CONCRETE_POWDER.values().forEach(x$0 -> this.m_245724_((Block)x$0));
        DDBlocks.DYE_BASKETS.values().forEach(x$0 -> this.m_245724_((Block)x$0));
        DDBlocks.GLAZED_TERRACOTTA.values().forEach(x$0 -> this.m_245724_((Block)x$0));
        DDBlocks.SHULKER_BOXES.values().forEach(this::dropShulkerBox);
        DDBlocks.STAINED_GLASS.values().forEach(x$0 -> this.m_245644_((Block)x$0));
        DDBlocks.STAINED_GLASS_PANES.values().forEach(x$0 -> this.m_245644_((Block)x$0));
        DDBlocks.TERRACOTTA.values().forEach(x$0 -> this.m_245724_((Block)x$0));
        DDBlocks.WOOL.values().forEach(x$0 -> this.m_245724_((Block)x$0));
        DDBlockLoot supplementariesLoot = this;
        ModCompat.supplementariesHolders(blockLookup, "flag").values().forEach(it -> supplementariesLoot.m_247577_((Block)it, this.createFlagDrops((Block)it)));
        ModCompat.supplementariesHolders(blockLookup, "candle_holder").values().forEach(it -> supplementariesLoot.m_247577_((Block)it, this.m_245895_((Block)it)));
        ModCompat.supplementariesSquaredHolders(blockLookup, "gold_candle_holder").values().forEach(it -> supplementariesLoot.m_247577_((Block)it, this.m_245895_((Block)it)));
    }

    private void dropBanner(Block block) {
        this.m_247577_(block, this.m_247458_(block));
    }

    private void dropBed(Block block) {
        this.m_247577_(block, this.m_245178_(block, (Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD));
    }

    private void dropCandle(Block block) {
        this.m_247577_(block, this.m_245895_(block));
    }

    private void dropCandleCake(Block block) {
        this.m_247577_(block, DDBlockLoot.m_246838_((Block)block));
    }

    private void dropShulkerBox(Block block) {
        this.m_247577_(block, this.m_247334_(block));
    }

    private LootTable.Builder createTable(Block block, LootPoolEntryContainer.Builder<?> entry) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)LootPool.m_79043_().m_79076_(entry)));
    }

    private LootTable.Builder createFlagDrops(Block block) {
        LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("Patterns", "BlockEntityTag.Patterns"));
        return this.createTable(block, (LootPoolEntryContainer.Builder<?>)entry);
    }

    protected void m_247577_(Block block, LootTable.Builder builder) {
        super.m_247577_(block, builder);
        this.knownBlocks.add(block);
    }

    protected Iterable<Block> getKnownBlocks() {
        return this.knownBlocks;
    }
}

