/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.dye_depot.data.server;

import com.ninni.dye_depot.DyeDepot;
import com.ninni.dye_depot.data.ModCompat;
import com.ninni.dye_depot.data.server.ConditionalRecipe;
import com.ninni.dye_depot.registry.DDBlocks;
import com.ninni.dye_depot.registry.DDDyes;
import com.ninni.dye_depot.registry.DDItems;
import com.ninni.dye_depot.registry.DDTags;
import com.ninni.dye_depot.registry.DyedHolders;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.conditions.FalseCondition;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class DDRecipes
extends RecipeProvider {
    private final DyedHolders<Item, Item> dyes;
    private final HolderLookup.RegistryLookup<Block> blockLookup;
    private final HolderLookup.RegistryLookup<Item> itemLookup;

    public DDRecipes(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupFuture) {
        super(output);
        HolderLookup.Provider lookup = lookupFuture.join();
        this.dyes = DDItems.DYES.mergeVanilla((HolderLookup.RegistryLookup<Item>)lookup.m_255025_(Registries.f_256913_));
        this.blockLookup = lookup.m_255025_(Registries.f_256747_);
        this.itemLookup = lookup.m_255025_(Registries.f_256913_);
    }

    public void m_245200_(Consumer<FinishedRecipe> output) {
        String namespace = "dye_depot:";
        DDBlocks.BANNERS.forEach((dye, block) -> DDRecipes.m_126081_((Consumer)output, (ItemLike)((ItemLike)block.m_203334_()), (ItemLike)((ItemLike)DDBlocks.WOOL.getOrThrow((DyeColor)dye))));
        this.dyeing(output, RecipeCategory.DECORATIONS, DDBlocks.BEDS.mergeVanilla(this.blockLookup), (TagKey<Item>)ItemTags.f_13146_);
        DDBlocks.BEDS.forEach((dye, block) -> DDRecipes.m_126073_((Consumer)output, (ItemLike)((ItemLike)block.m_203334_()), (ItemLike)((ItemLike)DDBlocks.WOOL.getOrThrow((DyeColor)dye))));
        DDBlocks.CANDLES.forEach((dye, block) -> DDRecipes.m_176542_((Consumer)output, (ItemLike)((ItemLike)block.m_203334_()), (ItemLike)((ItemLike)this.dyes.getOrThrow((DyeColor)dye))));
        this.dyeing(output, RecipeCategory.DECORATIONS, DDBlocks.CARPETS.mergeVanilla(this.blockLookup), (TagKey<Item>)ItemTags.f_215867_);
        DDBlocks.CARPETS.forEach((dye, block) -> DDRecipes.m_176716_((Consumer)output, (ItemLike)((ItemLike)block.m_203334_()), (ItemLike)((ItemLike)DDBlocks.WOOL.getOrThrow((DyeColor)dye))));
        DDBlocks.CONCRETE_POWDER.forEach((dye, block) -> DDRecipes.m_126101_((Consumer)output, (ItemLike)((ItemLike)block.m_203334_()), (ItemLike)((ItemLike)this.dyes.getOrThrow((DyeColor)dye))));
        DDBlocks.GLAZED_TERRACOTTA.forEach((dye, block) -> DDRecipes.m_176739_((Consumer)output, (ItemLike)((ItemLike)block.m_203334_()), (ItemLike)((ItemLike)DDBlocks.TERRACOTTA.getOrThrow((DyeColor)dye))));
        DDBlocks.STAINED_GLASS.forEach((dye, block) -> DDRecipes.m_126085_((Consumer)output, (ItemLike)((ItemLike)block.m_203334_()), (ItemLike)((ItemLike)this.dyes.getOrThrow((DyeColor)dye))));
        DDBlocks.STAINED_GLASS_PANES.forEach((dye, block) -> {
            Item dyeItem = this.dyes.getOrThrow((DyeColor)dye);
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)block.m_203334_()), (int)8).m_126127_(Character.valueOf('#'), (ItemLike)Blocks.f_50185_).m_126127_(Character.valueOf('$'), (ItemLike)dyeItem).m_126130_("###").m_126130_("#$#").m_126130_("###").m_126145_("stained_glass_pane").m_126132_("has_glass_pane", (CriterionTriggerInstance)DDRecipes.m_125977_((ItemLike)Blocks.f_50185_)).m_126132_(DDRecipes.m_176602_((ItemLike)dyeItem), (CriterionTriggerInstance)DDRecipes.m_125977_((ItemLike)dyeItem)).m_176500_(output, namespace + DDRecipes.m_176517_((ItemLike)((ItemLike)block.m_203334_()), (ItemLike)Blocks.f_50185_));
            DDRecipes.m_126089_((Consumer)output, (ItemLike)((ItemLike)block.m_203334_()), (ItemLike)((ItemLike)DDBlocks.STAINED_GLASS.getOrThrow((DyeColor)dye)));
        });
        DDBlocks.TERRACOTTA.forEach((dye, block) -> DDRecipes.m_126097_((Consumer)output, (ItemLike)((ItemLike)block.m_203334_()), (ItemLike)((ItemLike)this.dyes.getOrThrow((DyeColor)dye))));
        DDBlocks.DYE_BASKETS.forEach((dye, block) -> DDRecipes.m_247368_((Consumer)output, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)this.dyes.getOrThrow((DyeColor)dye)), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)block.m_203334_()), (String)(namespace + DDRecipes.m_176632_((ItemLike)((ItemLike)block.m_203334_()))), null, (String)(namespace + String.valueOf(dye) + "_dye_from_basket"), (String)(String.valueOf(dye) + "_dye")));
        this.dyeing(output, RecipeCategory.MISC, DDBlocks.WOOL, (TagKey<Item>)ItemTags.f_13167_);
        this.dyeConversion(output, DDDyes.AMBER.get(), (ItemLike)Items.f_151079_, 1);
        this.dyeConversion(output, DDDyes.AMBER.get(), (ItemLike)Items.f_42784_, 2);
        this.dyeConversion(output, DDDyes.AQUA.get(), (ItemLike)Items.f_151056_, 1);
        this.dyeConversion(output, DDDyes.BEIGE.get(), (ItemLike)Items.f_41948_, 1);
        this.dyeConversion(output, DDDyes.CORAL.get(), (ItemLike)Items.f_42715_, 2);
        this.dyeSmelting(output, DDDyes.CORAL.get(), DDTags.SMELTS_INTO_CORAL_DYE);
        this.dyeConversion(output, DDDyes.FOREST.get(), (ItemLike)Items.f_41911_, 1);
        this.dyeSmelting(output, DDDyes.GINGER.get(), (ItemLike)Items.f_42046_);
        this.dyeConversion(output, DDDyes.MAROON.get(), (ItemLike)Items.f_42591_, 1);
        this.dyeConversion(output, DDDyes.OLIVE.get(), (ItemLike)Items.f_42675_, 1);
        this.dyeConversion(output, DDDyes.TAN.get(), (ItemLike)Items.f_42525_, 1);
        this.dyeConversion(output, DDDyes.VERDANT.get(), (ItemLike)Items.f_42576_, 1);
        this.dyeSmelting(output, DDDyes.VERDANT.get(), (ItemLike)Items.f_42029_);
        this.dyeConversion(output, DDDyes.ROSE.get(), (ItemLike)Items.f_42208_, 2);
        this.dyeSmelting(output, DDDyes.TEAL.get(), (ItemLike)Items.f_42695_);
        this.dyeMixing(output, DyeColor.BLACK, DyeColor.GRAY, DyeColor.BLACK);
        this.dyeMixing(output, DyeColor.BLACK, DyeColor.LIGHT_GRAY, DyeColor.BLACK, DyeColor.BLACK);
        this.dyeMixing(output, DyeColor.BLACK, DyeColor.WHITE, DyeColor.BLACK, DyeColor.BLACK, DyeColor.BLACK);
        this.dyeMixing(output, DyeColor.GRAY, DyeColor.LIGHT_GRAY, DyeColor.BLACK);
        this.dyeMixing(output, DyeColor.GRAY, DyeColor.WHITE, DyeColor.BLACK, DyeColor.BLACK);
        this.dyeMixing(output, DyeColor.WHITE, DyeColor.BLACK, DyeColor.WHITE, DyeColor.WHITE, DyeColor.WHITE);
        this.dyeMixing(output, DyeColor.WHITE, DyeColor.GRAY, DyeColor.WHITE, DyeColor.WHITE);
        this.dyeMixing(output, DyeColor.WHITE, DyeColor.LIGHT_GRAY, DyeColor.WHITE);
        this.dyeColorSpectrum(output, DDDyes.CORAL.get(), DyeColor.RED, DyeColor.PURPLE, DDDyes.ROSE.get(), DDDyes.MAROON.get());
        this.dyeColorSpectrum(output, DDDyes.AQUA.get(), DyeColor.CYAN, DyeColor.GREEN, DDDyes.MINT.get(), DDDyes.TEAL.get());
        this.dyeColorSpectrum(output, DyeColor.LIME, DyeColor.GREEN, DyeColor.YELLOW, DDDyes.FOREST.get(), DDDyes.VERDANT.get());
        this.dyeColorSpectrum(output, DyeColor.PINK, DyeColor.MAGENTA, DyeColor.BLUE, DyeColor.PURPLE, DDDyes.INDIGO.get());
        this.dyeColorSpectrum(output, DyeColor.LIGHT_BLUE, DyeColor.BLUE, DyeColor.CYAN, DDDyes.SLATE.get(), DDDyes.NAVY.get());
        this.dyeColorSpectrum(output, DDDyes.TAN.get(), DyeColor.ORANGE, DyeColor.RED, DDDyes.GINGER.get(), DyeColor.BROWN);
        this.dyeColorSpectrum(output, DDDyes.BEIGE.get(), DyeColor.YELLOW, DyeColor.ORANGE, DDDyes.AMBER.get(), DDDyes.OLIVE.get());
        this.dyeMixing(output, DyeColor.GREEN, DyeColor.BLUE, DyeColor.YELLOW);
        this.dyeMixing(output, DyeColor.MAGENTA, DDDyes.INDIGO.get(), DyeColor.LIGHT_BLUE);
        this.disable(output, new ResourceLocation("gray_dye"));
        this.disable(output, new ResourceLocation("light_gray_dye_from_oxeye_daisy"));
        this.disable(output, new ResourceLocation("magenta_dye_from_blue_red_pink"));
        this.disable(output, new ResourceLocation("magenta_dye_from_blue_red_white_dye"));
        this.disable(output, new ResourceLocation("magenta_dye_from_purple_and_pink"));
        this.disable(output, new ResourceLocation("pink_dye_from_red_white_dye"));
        this.disable(output, new ResourceLocation("purple_dye"));
        this.disable(output, new ResourceLocation("red_dye_from_rose_bush"));
        ModCompat.supplementariesHolders(this.itemLookup, "candle_holder").forEach((dye, block) -> {
            Block candle = DDBlocks.CANDLES.getOrThrow((DyeColor)dye);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)block.m_203334_())).m_126130_("NCN").m_126130_(" N ").m_126127_(Character.valueOf('C'), (ItemLike)candle).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42416_).m_126145_("candle_holder").m_126132_("has_candle", (CriterionTriggerInstance)DDRecipes.m_125977_((ItemLike)candle)).m_176498_(DDRecipes.withConditions(output, ModCompat.supplementariesFlag("candle_holder")));
        });
        ModCompat.supplementariesSquaredHolders(this.itemLookup, "gold_candle_holder").forEach((dye, block) -> {
            Block candle = DDBlocks.CANDLES.getOrThrow((DyeColor)dye);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)block.m_203334_())).m_126130_("C").m_126130_("N").m_126127_(Character.valueOf('C'), (ItemLike)candle).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42417_).m_126145_("gold_candle_holder").m_126132_("has_candle", (CriterionTriggerInstance)DDRecipes.m_125977_((ItemLike)candle)).m_176498_(DDRecipes.withConditions(output, ModCompat.supplementariesFlag("candle_holder")));
        });
        ModCompat.supplementariesHolders(this.itemLookup, "flag").forEach((dye, block) -> {
            Block wool = DDBlocks.WOOL.getOrThrow((DyeColor)dye);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)block.m_203334_())).m_126130_("###").m_126130_("###").m_126130_("|  ").m_126127_(Character.valueOf('#'), (ItemLike)wool).m_126127_(Character.valueOf('|'), (ItemLike)Items.f_42398_).m_126145_("flag").m_126132_("has_wool", (CriterionTriggerInstance)DDRecipes.m_125977_((ItemLike)wool)).m_176498_(DDRecipes.withConditions(output, ModCompat.supplementariesFlag("flag")));
        });
    }

    private void dyeConversion(Consumer<FinishedRecipe> output, DyeColor dye, ItemLike from, int amount) {
        Item to = this.dyes.getOrThrow(dye);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)to, (int)amount).m_126209_(from).m_126145_(String.valueOf(dye) + "_dye").m_126132_(DDRecipes.m_176602_((ItemLike)from), (CriterionTriggerInstance)DDRecipes.m_125977_((ItemLike)from)).m_126140_(output, DyeDepot.modLoc(DDRecipes.m_176517_((ItemLike)to, (ItemLike)from)));
    }

    private void dyeSmelting(Consumer<FinishedRecipe> output, DyeColor dye, TagKey<Item> ingredient) {
        this.dyeSmelting(output, dye, Ingredient.m_204132_(ingredient), it -> it.m_126132_(DDRecipes.getHasName(ingredient), (CriterionTriggerInstance)DDRecipes.m_206406_((TagKey)ingredient)));
    }

    private void dyeSmelting(Consumer<FinishedRecipe> output, DyeColor dye, ItemLike ingredient) {
        this.dyeSmelting(output, dye, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}), it -> it.m_126132_(DDRecipes.m_176602_((ItemLike)ingredient), (CriterionTriggerInstance)DDRecipes.m_125977_((ItemLike)ingredient)));
    }

    private void dyeSmelting(Consumer<FinishedRecipe> output, DyeColor dye, Ingredient ingredient, UnaryOperator<SimpleCookingRecipeBuilder> factory) {
        ((SimpleCookingRecipeBuilder)factory.apply(SimpleCookingRecipeBuilder.m_246179_((Ingredient)ingredient, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)this.dyes.getOrThrow(dye)), (float)0.1f, (int)200))).m_126145_(String.valueOf(dye) + "_dye").m_126140_(output, DyeDepot.modLoc(String.valueOf(dye) + "_dye_from_smelting"));
    }

    private void disable(Consumer<FinishedRecipe> output, ResourceLocation id) {
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42751_).m_126209_((ItemLike)Items.f_42751_).m_126132_("never", (CriterionTriggerInstance)DDRecipes.m_125977_((ItemLike)Items.f_42751_)).m_126140_(DDRecipes.withConditions(output, new ICondition[]{FalseCondition.INSTANCE}), id);
    }

    private void dyeing(Consumer<FinishedRecipe> output, RecipeCategory category, DyedHolders<?, ? extends ItemLike> dyed) {
        this.dyeing(output, category, dyed, Ingredient.m_43921_(dyed.values().map(ItemStack::new)), builder -> builder.m_126132_("has_base", (CriterionTriggerInstance)DDRecipes.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_((ItemLike[])dyed.values().toArray(ItemLike[]::new)).m_45077_()})));
    }

    private void dyeing(Consumer<FinishedRecipe> output, RecipeCategory category, DyedHolders<?, ? extends ItemLike> dyed, TagKey<Item> from) {
        this.dyeing(output, category, dyed, Ingredient.m_204132_(from), builder -> builder.m_126132_(DDRecipes.getHasName(from), (CriterionTriggerInstance)DDRecipes.m_206406_((TagKey)from)));
    }

    private void dyeing(Consumer<FinishedRecipe> output, RecipeCategory category, DyedHolders<?, ? extends ItemLike> dyed, Ingredient from, UnaryOperator<ShapelessRecipeBuilder> factory) {
        String group = dyed.detectBaseName();
        dyed.forEach((color, item) -> {
            ResourceLocation id = ((ResourceKey)item.m_203543_().orElseThrow()).m_135782_();
            Item dye = this.dyes.getOrThrow((DyeColor)color);
            ((ShapelessRecipeBuilder)factory.apply(ShapelessRecipeBuilder.m_245498_((RecipeCategory)category, (ItemLike)((ItemLike)item.m_203334_())))).m_126184_(from).m_126209_((ItemLike)dye).m_126145_(group).m_126132_(DDRecipes.m_176602_((ItemLike)dye), (CriterionTriggerInstance)DDRecipes.m_125977_((ItemLike)dye)).m_126140_(output, id.m_246208_("dye_"));
        });
    }

    private void dyeColorSpectrum(Consumer<FinishedRecipe> output, DyeColor light, DyeColor base, DyeColor aspect, DyeColor tinted, DyeColor dark) {
        this.lightBaseDark(output, light, base, dark);
        this.dyeHue(output, base, aspect, tinted);
        this.dyeMixing(output, light, tinted, DyeColor.WHITE);
        this.dyeMixing(output, dark, tinted, DyeColor.BLACK);
    }

    private void lightBaseDark(Consumer<FinishedRecipe> output, DyeColor light, DyeColor base, DyeColor dark) {
        this.lightenAndDarken(output, light, base);
        this.lightenAndDarken(output, base, dark);
        this.dyeMixing(output, light, dark, DyeColor.WHITE, DyeColor.WHITE);
        this.dyeMixing(output, dark, light, DyeColor.BLACK, DyeColor.BLACK);
        this.dyeMixing(output, base, dark, light);
    }

    private void lightenAndDarken(Consumer<FinishedRecipe> output, DyeColor light, DyeColor dark) {
        this.dyeMixing(output, light, dark, DyeColor.WHITE);
        this.dyeMixing(output, dark, light, DyeColor.BLACK);
    }

    private void dyeHue(Consumer<FinishedRecipe> output, DyeColor base, DyeColor aspect, DyeColor result) {
        this.dyeMixing(output, result, base, aspect);
        this.dyeMixing(output, base, result, DyeColor.GRAY);
        this.dyeMixing(output, base, result, DyeColor.LIGHT_GRAY);
    }

    private void dyeMixing(Consumer<FinishedRecipe> output, DyeColor to, DyeColor ... from) {
        Item result = this.dyes.getOrThrow(to);
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)from.length).m_126145_(String.valueOf(to) + "_dye");
        HashSet<DyeColor> unique = new HashSet<DyeColor>();
        for (DyeColor color : from) {
            Item item = this.dyes.getOrThrow(color);
            builder.m_126209_((ItemLike)item);
            if (!unique.add(color)) continue;
            builder.m_126132_(DDRecipes.m_176602_((ItemLike)item), (CriterionTriggerInstance)DDRecipes.m_125977_((ItemLike)item));
        }
        String name = DDRecipes.m_176632_((ItemLike)result) + "_from_" + unique.stream().sorted(Comparator.comparing(DyeColor::m_41060_)).map(DyeColor::m_7912_).collect(Collectors.joining("_and_"));
        builder.m_126140_(output, DyeDepot.modLoc(name));
    }

    public static String getHasName(TagKey<?> tag) {
        return "has_" + tag.f_203868_().m_135815_();
    }

    public static Consumer<FinishedRecipe> withConditions(Consumer<FinishedRecipe> output, ICondition ... conditions) {
        return it -> output.accept(new ConditionalRecipe((FinishedRecipe)it, (Collection<ICondition>)Arrays.asList(conditions)));
    }
}

