/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.dye_depot.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;

public class ReplaceDropsModifier
extends LootModifier {
    public static Codec<ReplaceDropsModifier> CODEC = RecordCodecBuilder.create(builder -> ReplaceDropsModifier.codecStart((RecordCodecBuilder.Instance)builder).and((App)SimpleWeightedRandomList.m_146264_((Codec)ItemStack.f_41582_).fieldOf("items").forGetter(it -> it.items)).apply((Applicative)builder, ReplaceDropsModifier::new));
    private final SimpleWeightedRandomList<ItemStack> items;

    protected ReplaceDropsModifier(LootItemCondition[] conditions, SimpleWeightedRandomList<ItemStack> items) {
        super(conditions);
        this.items = items;
    }

    public static ReplaceDropsModifier forTable(ResourceLocation id, float chance, SimpleWeightedRandomList<ItemStack> items) {
        return new ReplaceDropsModifier(new LootItemCondition[]{LootItemRandomChanceCondition.m_81927_((float)chance).m_6409_(), LootTableIdCondition.builder((ResourceLocation)id).m_6409_()}, items);
    }

    public ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> stacks, LootContext context) {
        Optional item = this.items.m_216820_(context.m_230907_());
        return item.map(it -> {
            ObjectArrayList list = new ObjectArrayList(1);
            list.add(it);
            return list;
        }).orElse(stacks);
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

