/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.dye_depot.registry;

import com.google.common.collect.ImmutableMap;
import com.ninni.dye_depot.block.DyeBasketBlock;
import com.ninni.dye_depot.registry.DDDyes;
import com.ninni.dye_depot.registry.DDItems;
import com.ninni.dye_depot.registry.DeferredHolder;
import com.ninni.dye_depot.registry.DyedHolders;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.GlazedTerracottaBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;

public class DDBlocks {
    private static final DeferredRegister<Block> REGISTRY = DeferredRegister.create((ResourceKey)Registries.f_256747_, (String)"dye_depot");
    public static final DyedHolders<Block, Block> WOOL = DyedHolders.createModded(dye -> DDBlocks.registerWithItem(String.valueOf(dye) + "_wool", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_).m_284268_(dye))));
    public static final DyedHolders<Block, Block> CARPETS = DyedHolders.createModded(dye -> DDBlocks.registerWithItem(String.valueOf(dye) + "_carpet", () -> new WoolCarpetBlock(dye, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50336_).m_284268_(dye))));
    public static final DyedHolders<Block, Block> TERRACOTTA = DyedHolders.createModded(dye -> DDBlocks.registerWithItem(String.valueOf(dye) + "_terracotta", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50287_).m_284268_(dye))));
    private static final Map<DyeColor, MapColor> CONCRETE_COLORS = new ImmutableMap.Builder().put((Object)DDDyes.MAROON.get(), (Object)MapColor.f_283883_).put((Object)DDDyes.ROSE.get(), (Object)MapColor.f_283913_).put((Object)DDDyes.CORAL.get(), (Object)MapColor.f_283819_).put((Object)DDDyes.INDIGO.get(), (Object)MapColor.f_283807_).put((Object)DDDyes.NAVY.get(), (Object)MapColor.f_283771_).put((Object)DDDyes.SLATE.get(), (Object)MapColor.f_283818_).put((Object)DDDyes.OLIVE.get(), (Object)MapColor.f_283748_).put((Object)DDDyes.AMBER.get(), (Object)MapColor.f_283825_).put((Object)DDDyes.BEIGE.get(), (Object)MapColor.f_283919_).put((Object)DDDyes.TEAL.get(), (Object)MapColor.f_283818_).put((Object)DDDyes.MINT.get(), (Object)MapColor.f_283875_).put((Object)DDDyes.AQUA.get(), (Object)MapColor.f_283898_).put((Object)DDDyes.VERDANT.get(), (Object)MapColor.f_283771_).put((Object)DDDyes.FOREST.get(), (Object)MapColor.f_283784_).put((Object)DDDyes.GINGER.get(), (Object)MapColor.f_283820_).put((Object)DDDyes.TAN.get(), (Object)MapColor.f_283762_).build();
    public static final DyedHolders<Block, Block> CONCRETE = DyedHolders.createModded(dye -> DDBlocks.registerWithItem(String.valueOf(dye) + "_concrete", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50542_).m_284180_(CONCRETE_COLORS.get(dye)))));
    public static final DyedHolders<Block, Block> CONCRETE_POWDER = DyedHolders.createModded(dye -> DDBlocks.registerWithItem(String.valueOf(dye) + "_concrete_powder", () -> new ConcretePowderBlock(CONCRETE.getOrThrow((DyeColor)dye), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50506_).m_284268_(dye))));
    public static final DyedHolders<Block, Block> GLAZED_TERRACOTTA = DyedHolders.createModded(dye -> DDBlocks.registerWithItem(String.valueOf(dye) + "_glazed_terracotta", () -> new GlazedTerracottaBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50526_).m_284268_(dye))));
    public static final DyedHolders<Block, Block> STAINED_GLASS = DyedHolders.createModded(dye -> DDBlocks.registerWithItem(String.valueOf(dye) + "_stained_glass", () -> new StainedGlassBlock(dye, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50147_))));
    public static final DyedHolders<StainedGlassPaneBlock, Block> STAINED_GLASS_PANES = DyedHolders.createModded(dye -> DDBlocks.registerWithItem(String.valueOf(dye) + "_stained_glass_pane", () -> new StainedGlassPaneBlock(dye, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50303_))));
    public static final DyedHolders<Block, Block> SHULKER_BOXES = DyedHolders.createModded(dye -> DDBlocks.register(String.valueOf(dye) + "_shulker_box", () -> DDBlocks.shulkerBox(dye, BlockBehaviour.Properties.m_284310_().m_284268_(dye))));
    public static final DyedHolders<Block, Block> CANDLES = DyedHolders.createModded(dye -> DDBlocks.registerWithItem(String.valueOf(dye) + "_candle", () -> new CandleBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152483_).m_284268_(dye))));
    public static final DyedHolders<Block, Block> CANDLE_CAKES = DyedHolders.createModded(dye -> DDBlocks.register(String.valueOf(dye) + "_candle_cake", () -> new CandleCakeBlock(CANDLES.getOrThrow((DyeColor)dye), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152526_))));
    public static final DyedHolders<Block, Block> BANNERS = DyedHolders.createModded(dye -> DDBlocks.register(String.valueOf(dye) + "_banner", () -> DDBlocks.banner(dye)));
    public static final DyedHolders<Block, Block> WALL_BANNERS = DyedHolders.createModded(dye -> DDBlocks.register(String.valueOf(dye) + "_wall_banner", () -> DDBlocks.wallBanner(dye)));
    public static final DyedHolders<Block, Block> BEDS = DyedHolders.createModded(dye -> DDBlocks.register(String.valueOf(dye) + "_bed", () -> DDBlocks.bed(dye)));
    public static final DyedHolders<Block, Block> DYE_BASKETS = DyedHolders.createWithVanilla(dye -> DDBlocks.registerWithItem(String.valueOf(dye) + "_dye_basket", () -> new DyeBasketBlock((DyeColor)dye, BlockBehaviour.Properties.m_284310_().m_60978_(0.8f).m_60918_(SoundType.f_56745_).m_278183_().m_284268_(dye))));

    private static BannerBlock banner(DyeColor dye) {
        return new BannerBlock(dye, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50414_));
    }

    private static WallBannerBlock wallBanner(DyeColor dye) {
        return new WallBannerBlock(dye, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50430_).m_60916_(BANNERS.getOrThrow(dye)));
    }

    private static BedBlock bed(DyeColor color) {
        return new BedBlock(color, BlockBehaviour.Properties.m_284310_().m_284495_(state -> state.m_61143_((Property)BedBlock.f_49440_) == BedPart.FOOT ? color.m_284406_() : MapColor.f_283930_).m_60918_(SoundType.f_56736_).m_60978_(0.2f).m_60955_().m_278183_().m_278166_(PushReaction.DESTROY));
    }

    private static ShulkerBoxBlock shulkerBox(DyeColor color, BlockBehaviour.Properties properties) {
        BlockBehaviour.StatePredicate statePredicate = (blockState, blockGetter, blockPos) -> {
            BlockEntity blockEntity = blockGetter.m_7702_(blockPos);
            if (blockEntity instanceof ShulkerBoxBlockEntity) {
                ShulkerBoxBlockEntity shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)blockEntity;
                return shulkerBoxBlockEntity.m_59702_();
            }
            return true;
        };
        return new ShulkerBoxBlock(color, properties.m_280606_().m_60978_(2.0f).m_60988_().m_60955_().m_60960_(statePredicate).m_60971_(statePredicate).m_278166_(PushReaction.DESTROY).m_60924_(Blocks::m_50774_));
    }

    private static <T extends Block> Holder<T> register(String id, Supplier<T> block) {
        return DeferredHolder.from(REGISTRY.register(id, block));
    }

    private static <T extends Block> Holder<T> registerWithItem(String id, Supplier<T> block) {
        Holder supplier = DDBlocks.register(id, block);
        DDItems.REGISTRY.register(id, () -> new BlockItem((Block)supplier.m_203334_(), new Item.Properties()));
        return supplier;
    }

    public static void register(IEventBus modBus) {
        REGISTRY.register(modBus);
    }
}

