/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen.inventory.detector;

import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.gui.screen.inventory.RailcraftMenuScreen;
import mods.railcraft.network.to_server.SetItemDetectorMessage;
import mods.railcraft.world.inventory.detector.ItemDetectorMenu;
import mods.railcraft.world.level.block.entity.detector.ItemDetectorBlockEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.network.PacketDistributor;

public class ItemDetectorScreen
extends RailcraftMenuScreen<ItemDetectorMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = RailcraftConstants.rl("textures/gui/container/item_detector.png");
    private final ItemDetectorBlockEntity itemDetector;
    private Button filterLeft;
    private Button filterRight;

    public ItemDetectorScreen(ItemDetectorMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.itemDetector = menu.getItemDetector();
    }

    @Override
    public ResourceLocation getWidgetsTexture() {
        return BACKGROUND_TEXTURE;
    }

    protected void init() {
        super.init();
        int centreX = (this.width - this.getXSize()) / 2;
        int centreY = (this.height - this.getYSize()) / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<"), __ -> {
            ItemDetectorBlockEntity.PrimaryMode value = this.itemDetector.getPrimaryMode().previous();
            this.itemDetector.setPrimaryMode(value);
            this.sendAttributes();
        }).bounds(centreX + 10, centreY + 16, 20, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)">"), __ -> {
            ItemDetectorBlockEntity.PrimaryMode value = this.itemDetector.getPrimaryMode().next();
            this.itemDetector.setPrimaryMode(value);
            this.sendAttributes();
        }).bounds(centreX + 146, centreY + 16, 20, 20).build());
        this.filterLeft = Button.builder((Component)Component.literal((String)"<"), __ -> {
            ItemDetectorBlockEntity.FilterMode value = this.itemDetector.getFilterMode().previous();
            this.itemDetector.setFilterMode(value);
            this.sendAttributes();
        }).bounds(centreX + 10, centreY + 38, 20, 20).build();
        this.addRenderableWidget((GuiEventListener)this.filterLeft);
        this.filterRight = Button.builder((Component)Component.literal((String)">"), __ -> {
            ItemDetectorBlockEntity.FilterMode value = this.itemDetector.getFilterMode().next();
            this.itemDetector.setFilterMode(value);
            this.sendAttributes();
        }).bounds(centreX + 146, centreY + 38, 20, 20).build();
        this.addRenderableWidget((GuiEventListener)this.filterRight);
    }

    private void sendAttributes() {
        PacketDistributor.sendToServer((CustomPacketPayload)new SetItemDetectorMessage(this.itemDetector.getBlockPos(), this.itemDetector.getPrimaryMode(), this.itemDetector.getFilterMode()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        boolean visible;
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.filterLeft.visible = visible = this.itemDetector.getPrimaryMode() == ItemDetectorBlockEntity.PrimaryMode.FILTERED;
        this.filterRight.visible = visible;
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, -12566464, false);
        Component primaryModeName = this.itemDetector.getPrimaryMode().getName();
        guiGraphics.drawString(this.font, primaryModeName, this.imageWidth / 2 - this.font.width((FormattedText)primaryModeName) / 2, 21, -12566464, false);
        if (this.itemDetector.getPrimaryMode() == ItemDetectorBlockEntity.PrimaryMode.FILTERED) {
            Component filterModeName = this.itemDetector.getFilterMode().getName();
            guiGraphics.drawString(this.font, filterModeName, this.imageWidth / 2 - this.font.width((FormattedText)filterModeName) / 2, 43, -12566464, false);
            return;
        }
        int color = FastColor.ARGB32.color((int)80, (int)0, (int)0, (int)0);
        for (int slotNum = 0; slotNum < 9; ++slotNum) {
            Slot slot = (Slot)((ItemDetectorMenu)this.menu).slots.get(slotNum);
            int displayX = slot.x;
            int displayY = slot.y;
            guiGraphics.fill(RenderType.guiOverlay(), displayX, displayY, displayX + 16, displayY + 16, color);
        }
    }
}

