/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mods.railcraft.client.renderer.RailcraftRenderTypes;
import mods.railcraft.world.level.block.SteamTurbineBlock;
import mods.railcraft.world.level.block.entity.SteamTurbineBlockEntity;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockBlockEntity;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import org.joml.Matrix4f;

public class SteamTurbineRenderer
implements BlockEntityRenderer<SteamTurbineBlockEntity> {
    public void render(SteamTurbineBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        MultiblockBlockEntity.UnresolvedMembership membership = blockEntity.getUnresolvedMembership().orElse(null);
        if (membership == null || membership.patternElement().marker() != 'W') {
            return;
        }
        float xx = 0.0f;
        float zz = 0.0f;
        float halfWidth = 0.03125f;
        float len = 0.26f;
        float zOffset = 0.00390625f;
        float value = blockEntity.getAndSmoothGaugeValue();
        float angle = (90.0f * value + 45.0f) * ((float)Math.PI / 180);
        int fx = 0;
        int fz = 0;
        int rx = 0;
        int rz = 0;
        BlockPos patternPos = membership.patternElement().relativePos();
        if (((Boolean)blockEntity.getBlockState().getValue(SteamTurbineBlock.ROTATED)).booleanValue()) {
            if (patternPos.getX() == 0) {
                fx = -1;
                rz = 1;
            } else if (patternPos.getX() == 1) {
                xx += 1.0f;
                zz += 1.0f;
                fx = 1;
                rz = -1;
            }
        } else if (patternPos.getZ() == 0) {
            xx += 1.0f;
            fz = -1;
            rx = -1;
        } else if (patternPos.getZ() == 1) {
            zz += 1.0f;
            fz = 1;
            rx = 1;
        }
        if (fx == 0 && fz == 0 || rx == 0 && rz == 0) {
            throw new IllegalStateException("can't detect gauge orientation");
        }
        packedLight = LevelRenderer.getLightColor((BlockAndTintGetter)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos().offset(fx, 0, fz));
        VertexConsumer vertexBuffer = bufferSource.getBuffer(RailcraftRenderTypes.POSITION_COLOR_LIGHTMAP);
        poseStack.pushPose();
        poseStack.translate((double)xx + (double)rx * 0.5 + (double)((float)fx * zOffset), 0.5, (double)zz + (double)rz * 0.5 + (double)((float)fz * zOffset));
        Matrix4f matrix = poseStack.last().pose();
        float cosA = Mth.cos((float)angle);
        float sinA = Mth.sin((float)angle);
        float glx = cosA * len;
        float gly = sinA * len;
        float gwx = sinA * halfWidth;
        float gwy = cosA * halfWidth;
        float baseOffset = 1.0f / Mth.sin((float)angle) * halfWidth;
        int red = 100;
        int green = 0;
        int blue = 0;
        int alphaOne = 255;
        vertexBuffer.addVertex(matrix, (float)(-rx) * baseOffset, 0.0f, (float)(-rz) * baseOffset).setColor(red, green, blue, alphaOne).setLight(packedLight);
        vertexBuffer.addVertex(matrix, (float)rx * baseOffset, 0.0f, (float)rz * baseOffset).setColor(red, green, blue, alphaOne).setLight(packedLight);
        vertexBuffer.addVertex(matrix, (float)(-rx) * glx + (float)rx * gwx, gly + gwy, (float)(-rz) * glx + (float)rz * gwx).setColor(red, green, blue, alphaOne).setLight(packedLight);
        vertexBuffer.addVertex(matrix, (float)(-rx) * glx - (float)rx * gwx, gly - gwy, (float)(-rz) * glx - (float)rz * gwx).setColor(red, green, blue, alphaOne).setLight(packedLight);
        poseStack.popPose();
    }
}

