/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.worldgen.placements;

import java.util.List;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.data.worldgen.features.RailcraftOreFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class RailcraftOrePlacements {
    private static final int LEAD_VEIN_PER_CHUNK = 8;
    private static final int TIN_SMALL_VEIN_PER_CHUNK = 14;
    private static final int TIN_LARGE_VEIN_PER_CHUNK = 12;
    private static final int SULFUR_VEIN_PER_CHUNK = 20;
    private static final int SULFUR_BURIED_VEIN_PER_CHUNK = 12;
    private static final int ZINC_VEIN_PER_CHUNK = 7;
    private static final int NICKEL_UPPER_VEIN_PER_CHUNK = 70;
    private static final int NICKEL_MIDDLE_VEIN_PER_CHUNK = 10;
    private static final int NICKEL_SMALL_VEIN_PER_CHUNK = 10;
    private static final int SILVER_VEIN_PER_CHUNK = 6;
    public static final ResourceKey<PlacedFeature> LEAD_ORE = RailcraftOrePlacements.createKey("lead_ore");
    public static final ResourceKey<PlacedFeature> TIN_ORE_SMALL = RailcraftOrePlacements.createKey("tin_ore_small");
    public static final ResourceKey<PlacedFeature> TIN_ORE_LARGE = RailcraftOrePlacements.createKey("tin_ore_large");
    public static final ResourceKey<PlacedFeature> SULFUR_ORE_UPPER = RailcraftOrePlacements.createKey("sulfur_ore_upper");
    public static final ResourceKey<PlacedFeature> SULFUR_ORE_LOWER = RailcraftOrePlacements.createKey("sulfur_ore_lower");
    public static final ResourceKey<PlacedFeature> ZINC_ORE = RailcraftOrePlacements.createKey("zinc_ore");
    public static final ResourceKey<PlacedFeature> NICKEL_ORE_UPPER = RailcraftOrePlacements.createKey("nickel_ore_upper");
    public static final ResourceKey<PlacedFeature> NICKEL_ORE_MIDDLE = RailcraftOrePlacements.createKey("nickel_ore_middle");
    public static final ResourceKey<PlacedFeature> NICKEL_ORE_SMALL = RailcraftOrePlacements.createKey("nickel_ore_small");
    public static final ResourceKey<PlacedFeature> SILVER_ORE = RailcraftOrePlacements.createKey("silver_ore");
    public static final ResourceKey<PlacedFeature> SILVER_ORE_LOWER = RailcraftOrePlacements.createKey("silver_ore_lower");
    public static final ResourceKey<PlacedFeature> QUARRIED_STONE = RailcraftOrePlacements.createKey("quarried_stone");
    public static final ResourceKey<PlacedFeature> SALTPETER = RailcraftOrePlacements.createKey("saltpeter");
    public static final ResourceKey<PlacedFeature> FIRESTONE = RailcraftOrePlacements.createKey("firestone");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        context.register(LEAD_ORE, (Object)new PlacedFeature(RailcraftOrePlacements.getConfiguredFeature(context, RailcraftOreFeatures.LEAD_ORE), OrePlacements.commonOrePlacement((int)8, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-24), (VerticalAnchor)VerticalAnchor.absolute((int)64)))));
        context.register(TIN_ORE_SMALL, (Object)new PlacedFeature(RailcraftOrePlacements.getConfiguredFeature(context, RailcraftOreFeatures.TIN_ORE_SMALL), OrePlacements.commonOrePlacement((int)14, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-20), (VerticalAnchor)VerticalAnchor.absolute((int)94)))));
        context.register(TIN_ORE_LARGE, (Object)new PlacedFeature(RailcraftOrePlacements.getConfiguredFeature(context, RailcraftOreFeatures.TIN_ORE_LARGE), OrePlacements.commonOrePlacement((int)12, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-32), (VerticalAnchor)VerticalAnchor.absolute((int)72)))));
        context.register(SULFUR_ORE_UPPER, (Object)new PlacedFeature(RailcraftOrePlacements.getConfiguredFeature(context, RailcraftOreFeatures.SULFUR_ORE), OrePlacements.commonOrePlacement((int)20, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)136), (VerticalAnchor)VerticalAnchor.top()))));
        context.register(SULFUR_ORE_LOWER, (Object)new PlacedFeature(RailcraftOrePlacements.getConfiguredFeature(context, RailcraftOreFeatures.SULFUR_ORE_BURIED), OrePlacements.commonOrePlacement((int)12, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-10), (VerticalAnchor)VerticalAnchor.absolute((int)182)))));
        context.register(ZINC_ORE, (Object)new PlacedFeature(RailcraftOrePlacements.getConfiguredFeature(context, RailcraftOreFeatures.ZINC_ORE), OrePlacements.commonOrePlacement((int)7, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-24), (VerticalAnchor)VerticalAnchor.absolute((int)64)))));
        context.register(NICKEL_ORE_UPPER, (Object)new PlacedFeature(RailcraftOrePlacements.getConfiguredFeature(context, RailcraftOreFeatures.NICKEL_ORE), OrePlacements.commonOrePlacement((int)70, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)80), (VerticalAnchor)VerticalAnchor.absolute((int)384)))));
        context.register(NICKEL_ORE_MIDDLE, (Object)new PlacedFeature(RailcraftOrePlacements.getConfiguredFeature(context, RailcraftOreFeatures.NICKEL_ORE), OrePlacements.commonOrePlacement((int)10, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-24), (VerticalAnchor)VerticalAnchor.absolute((int)56)))));
        context.register(NICKEL_ORE_SMALL, (Object)new PlacedFeature(RailcraftOrePlacements.getConfiguredFeature(context, RailcraftOreFeatures.NICKEL_ORE_SMALL), OrePlacements.commonOrePlacement((int)10, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)72)))));
        context.register(SILVER_ORE, (Object)new PlacedFeature(RailcraftOrePlacements.getConfiguredFeature(context, RailcraftOreFeatures.SILVER_ORE_BURIED), OrePlacements.commonOrePlacement((int)6, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)32)))));
        context.register(SILVER_ORE_LOWER, (Object)new PlacedFeature(RailcraftOrePlacements.getConfiguredFeature(context, RailcraftOreFeatures.SILVER_ORE), OrePlacements.orePlacement((PlacementModifier)CountPlacement.of((IntProvider)UniformInt.of((int)0, (int)1)), (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)-48)))));
        context.register(QUARRIED_STONE, (Object)new PlacedFeature(RailcraftOrePlacements.getConfiguredFeature(context, RailcraftOreFeatures.QUARRIED_STONE), List.of(RarityFilter.onAverageOnceEvery((int)40), InSquarePlacement.spread(), BiomeFilter.biome())));
        context.register(SALTPETER, (Object)new PlacedFeature(RailcraftOrePlacements.getConfiguredFeature(context, RailcraftOreFeatures.SALTPETER), List.of(InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.WATER})), BiomeFilter.biome())));
        context.register(FIRESTONE, (Object)new PlacedFeature(RailcraftOrePlacements.getConfiguredFeature(context, RailcraftOreFeatures.FIRESTONE), List.of(CountPlacement.of((int)2), PlacementUtils.FULL_RANGE, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.LAVA})), BiomeFilter.biome())));
    }

    @NotNull
    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)RailcraftConstants.rl(name));
    }

    @NotNull
    private static Holder.Reference<ConfiguredFeature<?, ?>> getConfiguredFeature(@NotNull BootstrapContext<PlacedFeature> context, ResourceKey<ConfiguredFeature<?, ?>> resourceKey) {
        return context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(resourceKey);
    }
}

