/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.network.to_server;

import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.world.inventory.slot.RailcraftSlot;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SetFilterSlotMessage(int slotIndex, ItemStack stack) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetFilterSlotMessage> TYPE = new CustomPacketPayload.Type(RailcraftConstants.rl("set_filter_slot"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SetFilterSlotMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SetFilterSlotMessage::slotIndex, (StreamCodec)ItemStack.STREAM_CODEC, SetFilterSlotMessage::stack, SetFilterSlotMessage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SetFilterSlotMessage message, IPayloadContext context) {
        RailcraftSlot slot;
        Slot slot2;
        AbstractContainerMenu container;
        Player player = context.player();
        if (!message.stack.isEmpty() && message.stack.getCount() <= message.stack.getMaxStackSize() && (container = player.containerMenu) != null && message.slotIndex >= 0 && message.slotIndex < container.slots.size() && (slot2 = container.getSlot(message.slotIndex)) instanceof RailcraftSlot && (slot = (RailcraftSlot)slot2).isPhantom() && slot.mayPlace(message.stack)) {
            slot.set(message.stack);
        }
    }
}

