/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util.container;

import java.util.List;
import java.util.stream.Stream;
import mods.railcraft.api.container.manipulator.ContainerManipulator;
import mods.railcraft.api.container.manipulator.ContainerSlotAccessor;
import mods.railcraft.api.container.manipulator.ModifiableSlotAccessor;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.module.ModuleProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AdvancedContainer
extends SimpleContainer
implements ContainerManipulator<ModifiableSlotAccessor> {
    private final List<ModifiableSlotAccessor> slots;
    @Nullable
    private Listener listener;
    private int maxStackSize = 64;

    public AdvancedContainer(int size) {
        super(size);
        this.slots = ContainerSlotAccessor.createSlots((Container)this, 0, size).toList();
    }

    @Override
    public Stream<ModifiableSlotAccessor> stream() {
        return this.slots.stream();
    }

    public AdvancedContainer listener(Container container) {
        return this.listener(new ContainerCallback(container));
    }

    public AdvancedContainer listener(ModuleProvider moduleProvider) {
        return this.listener(new ModuleProviderCallback(moduleProvider));
    }

    public AdvancedContainer listener(RailcraftBlockEntity blockEntity) {
        return this.listener(new BlockEntityCallback(blockEntity));
    }

    public AdvancedContainer listener(Listener callback) {
        this.listener = callback;
        this.addListener(callback);
        return this;
    }

    public AdvancedContainer phantom() {
        this.maxStackSize = 127;
        return this;
    }

    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public boolean stillValid(Player player) {
        return this.listener == null || this.listener.stillValid(player);
    }

    public void startOpen(Player player) {
        if (this.listener != null) {
            this.listener.startOpen(player);
        }
    }

    public void stopOpen(Player player) {
        if (this.listener != null) {
            this.listener.stopOpen(player);
        }
    }

    public void fromTag(ListTag tag, HolderLookup.Provider provider) {
        for (int i = 0; i < tag.size(); ++i) {
            CompoundTag slotTag = tag.getCompound(i);
            ItemStack.parse((HolderLookup.Provider)provider, (Tag)slotTag).ifPresent(itemStack -> {
                int slot = slotTag.getInt("index");
                this.setItem(slot, (ItemStack)itemStack);
            });
        }
    }

    public ListTag createTag(HolderLookup.Provider provider) {
        ListTag tag = new ListTag();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack item = this.getItem(i);
            if (item.isEmpty()) continue;
            CompoundTag slotTag = new CompoundTag();
            slotTag.putInt("index", i);
            tag.add((Object)item.save(provider, (Tag)slotTag));
        }
        return tag;
    }

    public static AdvancedContainer copyOf(Container original) {
        AdvancedContainer copy = new AdvancedContainer(original.getContainerSize());
        for (int i = 0; i < original.getContainerSize(); ++i) {
            ItemStack itemStack = original.getItem(i);
            if (itemStack.isEmpty()) continue;
            copy.setItem(i, itemStack.copy());
        }
        return copy;
    }

    public static class ContainerCallback
    implements Listener {
        private final Container container;

        public ContainerCallback(Container container) {
            this.container = container;
        }

        @Override
        public boolean stillValid(Player player) {
            return this.container.stillValid(player);
        }

        @Override
        public void startOpen(Player player) {
            this.container.startOpen(player);
        }

        @Override
        public void stopOpen(Player player) {
            this.container.stopOpen(player);
        }

        public void containerChanged(Container container) {
            this.container.setChanged();
        }
    }

    public static interface Listener
    extends ContainerListener {
        default public boolean stillValid(Player player) {
            return true;
        }

        default public void startOpen(Player player) {
        }

        default public void stopOpen(Player player) {
        }
    }

    public static class ModuleProviderCallback
    implements Listener {
        private final ModuleProvider moduleProvider;

        public ModuleProviderCallback(ModuleProvider moduleProvider) {
            this.moduleProvider = moduleProvider;
        }

        @Override
        public boolean stillValid(Player player) {
            return this.moduleProvider.isStillValid(player);
        }

        public void containerChanged(Container container) {
            this.moduleProvider.save();
        }
    }

    public static class BlockEntityCallback
    implements Listener {
        private final RailcraftBlockEntity blockEntity;

        public BlockEntityCallback(RailcraftBlockEntity blockEntity) {
            this.blockEntity = blockEntity;
        }

        @Override
        public boolean stillValid(Player player) {
            return this.blockEntity.isStillValid(player);
        }

        public void containerChanged(Container container) {
            this.blockEntity.setChanged();
        }
    }
}

