/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mods.railcraft.world.item.crafting.RailcraftRecipeSerializers;
import mods.railcraft.world.item.crafting.RailcraftRecipeTypes;
import mods.railcraft.world.level.block.RailcraftBlocks;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RollingRecipe
implements Recipe<CraftingInput> {
    private final ShapedRecipePattern pattern;
    private final ItemStack result;
    private final int processTime;

    public RollingRecipe(ShapedRecipePattern pattern, ItemStack result, int processTime) {
        this.pattern = pattern;
        this.result = result;
        this.processTime = processTime;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public int getWidth() {
        return this.pattern.width();
    }

    public int getHeight() {
        return this.pattern.height();
    }

    public boolean matches(CraftingInput inventory, Level level) {
        return this.pattern.matches(inventory);
    }

    public ItemStack assemble(CraftingInput inventory, HolderLookup.Provider provider) {
        return this.getResultItem(provider).copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= this.pattern.width() && height >= this.pattern.height();
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.pattern.ingredients();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RailcraftRecipeSerializers.ROLLING.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)RailcraftRecipeTypes.ROLLING.get();
    }

    public boolean isSpecial() {
        return true;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)RailcraftBlocks.MANUAL_ROLLING_MACHINE.get());
    }

    public static class Serializer
    implements RecipeSerializer<RollingRecipe> {
        private static final MapCodec<RollingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ShapedRecipePattern.MAP_CODEC.forGetter(recipe -> recipe.pattern), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("processTime", (Object)100).forGetter(recipe -> recipe.processTime)).apply((Applicative)instance, RollingRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, RollingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<RollingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RollingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static RollingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            ShapedRecipePattern pattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)buffer);
            int processTime = buffer.readVarInt();
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new RollingRecipe(pattern, result, processTime);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, RollingRecipe recipe) {
            ShapedRecipePattern.STREAM_CODEC.encode((Object)buffer, (Object)recipe.pattern);
            buffer.writeVarInt(recipe.processTime);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
        }
    }
}

