/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.detector;

import java.util.List;
import mods.railcraft.api.container.manipulator.SlotAccessor;
import mods.railcraft.util.container.StackFilter;
import mods.railcraft.world.inventory.detector.AdvancedDetectorMenu;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.detector.FilterDetectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class AdvancedDetectorBlockEntity
extends FilterDetectorBlockEntity {
    public AdvancedDetectorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.ADVANCED_DETECTOR.get(), blockPos, blockState, 9);
    }

    @Override
    protected int testCarts(List<AbstractMinecart> minecarts) {
        for (AbstractMinecart cart : minecarts) {
            if (!this.stream().map(SlotAccessor::item).anyMatch(StackFilter.isCart(cart))) continue;
            return 15;
        }
        return 0;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new AdvancedDetectorMenu(id, inventory, this);
    }
}

