/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.signal;

import java.util.HashSet;
import java.util.Set;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.RedstoneUtil;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.signal.AbstractSignalBoxBlockEntity;
import mods.railcraft.world.level.block.entity.signal.SignalCapacitorBoxBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SignalSequencerBoxBlockEntity
extends AbstractSignalBoxBlockEntity {
    private static final int MAX_ITERATIONS = 64;
    private Direction outputDirection = Direction.NORTH;
    private boolean powered;
    private boolean neighborSignal;

    public SignalSequencerBoxBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.SIGNAL_SEQUENCER_BOX.get(), blockPos, blockState);
    }

    @Override
    public void neighborChanged() {
        if (this.level.isClientSide()) {
            return;
        }
        boolean powered = RedstoneUtil.hasRepeaterSignal(this.level, this.getBlockPos());
        if (!this.powered && powered) {
            this.powered = true;
            this.incrementSequencer(true, new HashSet<BlockEntity>(), 0);
        } else {
            this.powered = powered;
        }
    }

    @Override
    public void neighborSignalBoxChanged(AbstractSignalBoxBlockEntity neighborSignalBox, Direction neighborDirection, boolean removed) {
        boolean signal;
        if (this.level.isClientSide() || neighborSignalBox instanceof SignalSequencerBoxBlockEntity || neighborSignalBox instanceof SignalCapacitorBoxBlockEntity) {
            return;
        }
        boolean bl = signal = neighborSignalBox.getRedstoneSignal(neighborDirection) > 0;
        if (!this.neighborSignal && signal) {
            this.neighborSignal = true;
            this.incrementSequencer(true, new HashSet<BlockEntity>(), 0);
        } else {
            this.neighborSignal = signal;
        }
    }

    private void incrementSequencer(boolean firstPass, Set<BlockEntity> visitedFirstPass, int numberOfIterations) {
        if (firstPass) {
            visitedFirstPass.add(this);
            BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(this.outputDirection));
            if (blockEntity instanceof SignalSequencerBoxBlockEntity) {
                SignalSequencerBoxBlockEntity signalBox = (SignalSequencerBoxBlockEntity)blockEntity;
                if (!visitedFirstPass.contains(blockEntity)) {
                    signalBox.incrementSequencer(true, visitedFirstPass, numberOfIterations);
                    return;
                }
            }
        }
        Direction lastOutputDirection = this.outputDirection;
        do {
            this.outputDirection = this.outputDirection.getClockWise();
        } while (!this.canOutputToDirection(this.outputDirection) && lastOutputDirection != this.outputDirection);
        this.setChanged();
        if (numberOfIterations >= 64) {
            return;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(this.outputDirection));
        if (blockEntity instanceof SignalSequencerBoxBlockEntity) {
            SignalSequencerBoxBlockEntity signalBox = (SignalSequencerBoxBlockEntity)blockEntity;
            signalBox.incrementSequencer(false, visitedFirstPass, numberOfIterations + 1);
        }
    }

    private boolean canOutputToDirection(Direction direction) {
        BlockState blockState = this.level.getBlockState(this.getBlockPos().relative(direction));
        if (blockState.is(this.getBlockState().getBlock()) || blockState.is(RailcraftTags.Blocks.ASPECT_RECEIVER)) {
            return true;
        }
        Block block = blockState.getBlock();
        if (block == Blocks.REDSTONE_WIRE) {
            return true;
        }
        if (block == Blocks.REPEATER) {
            Direction facing = (Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING);
            return direction.getOpposite() == facing;
        }
        return false;
    }

    @Override
    public void setChanged() {
        super.setChanged();
        this.syncToClient();
    }

    @Override
    public int getRedstoneSignal(Direction direction) {
        return this.level.getBlockEntity(this.getBlockPos().relative(direction)) instanceof AbstractSignalBoxBlockEntity ? 0 : (this.outputDirection.getOpposite() == direction ? 15 : 0);
    }

    @Override
    public SignalAspect getSignalAspect(Direction direction) {
        return this.outputDirection == direction ? SignalAspect.GREEN : SignalAspect.RED;
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putString("outputDirection", this.outputDirection.getName());
        tag.putBoolean("powered", this.powered);
        tag.putBoolean("neighborSignal", this.neighborSignal);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.outputDirection = Direction.byName((String)tag.getString("outputDirection"));
        this.powered = tag.getBoolean("powered");
        this.neighborSignal = tag.getBoolean("neighborSignal");
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf data) {
        super.writeToBuf(data);
        data.writeVarInt(this.outputDirection.get3DDataValue());
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf data) {
        super.readFromBuf(data);
        this.outputDirection = Direction.from3DDataValue((int)data.readVarInt());
    }
}

