/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.outfitted;

import java.util.List;
import java.util.function.Supplier;
import mods.railcraft.Translations;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.track.CouplerTrackBlockEntity;
import mods.railcraft.world.level.block.track.outfitted.PoweredOutfittedTrackBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class CouplerTrackBlock
extends PoweredOutfittedTrackBlock
implements EntityBlock {
    public static final EnumProperty<CouplerTrackBlockEntity.Mode> MODE = EnumProperty.create((String)"mode", CouplerTrackBlockEntity.Mode.class);

    public CouplerTrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(trackType, properties);
    }

    @Override
    protected BlockState buildDefaultState(BlockState blockState) {
        return (BlockState)super.buildDefaultState(blockState).setValue(MODE, (Comparable)((Object)CouplerTrackBlockEntity.Mode.COUPLER));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{MODE});
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new CouplerTrackBlockEntity(blockPos, blockState);
    }

    @Override
    protected boolean crowbarWhack(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, ItemStack itemStack) {
        CouplerTrackBlockEntity.Mode mode = CouplerTrackBlock.getMode(blockState);
        CouplerTrackBlockEntity.Mode newMode = player.isCrouching() ? mode.previous() : mode.next();
        boolean res = level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue(MODE, (Comparable)((Object)newMode)));
        MutableComponent currentMode = Component.translatable((String)Translations.Tips.CURRENT_MODE);
        MutableComponent modeDisplay = newMode.getDisplayName().copy().withStyle(ChatFormatting.DARK_PURPLE);
        player.displayClientMessage((Component)currentMode.append(CommonComponents.SPACE).append((Component)modeDisplay), true);
        return res;
    }

    @Override
    public void onMinecartPass(BlockState blockState, Level level, BlockPos pos, AbstractMinecart cart) {
        super.onMinecartPass(blockState, level, pos, cart);
        level.getBlockEntity(pos, (BlockEntityType)RailcraftBlockEntityTypes.COUPLER_TRACK.get()).ifPresent(couplerTrack -> CouplerTrackBlock.getMode(blockState).minecartPassed((CouplerTrackBlockEntity)((Object)couplerTrack), cart));
    }

    @Override
    public int getPowerPropagation(BlockState blockState, Level level, BlockPos pos) {
        return CouplerTrackBlock.getMode(blockState).getPowerPropagation();
    }

    public static CouplerTrackBlockEntity.Mode getMode(BlockState blockState) {
        return (CouplerTrackBlockEntity.Mode)((Object)blockState.getValue(MODE));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag flag) {
        lines.add((Component)Component.translatable((String)Translations.Tips.COUPLER_TRACK).withStyle(ChatFormatting.GRAY));
        lines.add((Component)Component.translatable((String)Translations.Tips.HIT_CROWBAR_TO_CHANGE_MODE).withStyle(ChatFormatting.BLUE));
        lines.add((Component)Component.translatable((String)Translations.Tips.APPLY_REDSTONE_TO_ENABLE).withStyle(ChatFormatting.RED));
    }
}

