/*
 * Decompiled with CFR 0.152.
 */
package org.primal.client.model.entity;

import net.minecraft.resources.ResourceLocation;
import org.primal.client.animation.entity.BearAnimations;
import org.primal.entity.animal.BearEntity;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;

public class BearModel
extends DefaultedEntityGeoModel<BearEntity> {
    public BearModel() {
        super(ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"bear"), true);
    }

    public ResourceLocation getTextureResource(BearEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"primal", (String)("textures/entity/bear/main_" + animatable.getVariant().getSerializedName() + ".png"));
    }

    public void setCustomAnimations(BearEntity bear, long instanceId, AnimationState<BearEntity> animationState) {
        AnimationController controller = (AnimationController)bear.getAnimatableInstanceCache().getManagerForId((long)bear.getId()).getAnimationControllers().get("base_controller");
        if (bear.isBaby() && this.getBone("head").isPresent()) {
            ((GeoBone)this.getBone("head").get()).setPosY(5.0f);
        }
        if (controller.isPlayingTriggeredAnimation() || controller.getCurrentRawAnimation() == BearAnimations.BEG) {
            return;
        }
        if (bear.isBearSleeping() && this.getBone("head").isPresent()) {
            ((GeoBone)this.getBone("head").get()).setRotY(0.30543262f);
            return;
        }
        super.setCustomAnimations((GeoAnimatable)bear, instanceId, animationState);
    }
}

