/*
 * Decompiled with CFR 0.152.
 */
package org.primal.client.model.entity;

import net.minecraft.resources.ResourceLocation;
import org.primal.client.animation.entity.CrocodileAnimations;
import org.primal.entity.animal.CrocodileEntity;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;

public class CrocodileModel
extends DefaultedEntityGeoModel<CrocodileEntity> {
    public CrocodileModel() {
        super(ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"crocodile"), true);
    }

    public ResourceLocation getTextureResource(CrocodileEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"primal", (String)("textures/entity/crocodile/" + animatable.getVariant().getSerializedName() + ".png"));
    }

    public void setCustomAnimations(CrocodileEntity crocodile, long instanceId, AnimationState<CrocodileEntity> animationState) {
        AnimationController controller = (AnimationController)crocodile.getAnimatableInstanceCache().getManagerForId((long)crocodile.getId()).getAnimationControllers().get("base_controller");
        if (controller.isPlayingTriggeredAnimation() || controller.getCurrentRawAnimation() == CrocodileAnimations.SWIM_IDLE || controller.getCurrentRawAnimation() == CrocodileAnimations.TRASH || controller.getCurrentRawAnimation() == CrocodileAnimations.TRASH_UNDERWATER || controller.getCurrentRawAnimation() == CrocodileAnimations.BASKING) {
            return;
        }
        if (!crocodile.isUnderWater()) {
            super.setCustomAnimations((GeoAnimatable)crocodile, instanceId, animationState);
        }
    }
}

