/*
 * Decompiled with CFR 0.152.
 */
package org.primal.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.primal.client.model.entity.SharkModel;
import org.primal.entity.animal.SharkEntity;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class SharkRenderer
extends GeoEntityRenderer<SharkEntity> {
    public SharkRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new SharkModel());
        this.shadowRadius = 0.9f;
    }

    public void scaleModelForRender(float widthScale, float heightScale, PoseStack poseStack, SharkEntity animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay) {
        super.scaleModelForRender(widthScale, heightScale, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
    }

    protected void applyRotations(SharkEntity animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float nativeScale) {
        if ((animatable.isInWater() || !animatable.isInWater() && !animatable.onGround()) && !animatable.hasControllingPassenger()) {
            float yaw = Mth.lerp((float)partialTick, (float)animatable.yRotO, (float)animatable.getYRot());
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - yaw));
            float pitch = Mth.lerp((float)partialTick, (float)animatable.xRotO, (float)animatable.getXRot());
            poseStack.mulPose(Axis.XP.rotationDegrees(-pitch));
        } else {
            super.applyRotations((Entity)animatable, poseStack, ageInTicks, rotationYaw, partialTick, nativeScale);
        }
    }
}

