/*
 * Decompiled with CFR 0.152.
 */
package org.primal.client.renderer.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.primal.entity.animal.BearEntity;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.Color;

public class BearHoneyLayer
extends GeoRenderLayer<BearEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"textures/entity/bear/honey.png");

    public BearHoneyLayer(GeoRenderer<BearEntity> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(PoseStack poseStack, BearEntity animatable, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        if (animatable.getHoneyCounter() <= 0) {
            return;
        }
        RenderType honeyRenderType = RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE);
        this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)animatable, honeyRenderType, bufferSource.getBuffer(honeyRenderType), partialTick, packedLight, OverlayTexture.NO_OVERLAY, Color.WHITE.argbInt());
    }
}

