/*
 * Decompiled with CFR 0.152.
 */
package org.primal.datagen.providers;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.primal.registry.Primal_Blocks;

public class Primal_BlockModelGenerator
extends BlockModelProvider {
    @VisibleForTesting
    public final Map<ResourceLocation, BlockModelBuilder> falseAmbientOcclusionGeneratedModels = new HashMap<ResourceLocation, BlockModelBuilder>();

    public Primal_BlockModelGenerator(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "primal", existingFileHelper);
    }

    protected void registerModels() {
        this.withExistingParentFalseAmbientOcclusion("shark_tooth_base", ResourceLocation.withDefaultNamespace((String)"block/pointed_dripstone")).texture("cross", ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"block/shark_tooth_base"));
        this.withExistingParentFalseAmbientOcclusion("shark_tooth_tip", ResourceLocation.withDefaultNamespace((String)"block/pointed_dripstone")).texture("cross", ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"block/shark_tooth_tip"));
        ((BlockModelBuilder)this.withExistingParent("shark_tooth_tip_down", ResourceLocation.withDefaultNamespace((String)"block/pointed_dripstone"))).texture("cross", ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"block/shark_tooth_tip_down"));
        this.createCubeAll(Primal_Blocks.CROCODILE_SCUTE_BLOCK);
        this.createCubeAll(Primal_Blocks.CROCODILE_SCUTE_SHINGLE);
        this.createCubeAll(Primal_Blocks.CHISELED_CROCODILE_SCUTE);
        this.simpleStairs(Primal_Blocks.CROCODILE_SCUTE_STAIRS, Primal_Blocks.CROCODILE_SCUTE_BLOCK);
        this.simpleSlab(Primal_Blocks.CROCODILE_SCUTE_SLAB, Primal_Blocks.CROCODILE_SCUTE_BLOCK);
        this.createCubeAll(Primal_Blocks.ARID_CROCODILE_SCUTE_BLOCK);
        this.createCubeAll(Primal_Blocks.ARID_CROCODILE_SCUTE_SHINGLE);
        this.createCubeAll(Primal_Blocks.ARID_CHISELED_CROCODILE_SCUTE);
        this.simpleStairs(Primal_Blocks.ARID_CROCODILE_SCUTE_STAIRS, Primal_Blocks.ARID_CROCODILE_SCUTE_BLOCK);
        this.simpleSlab(Primal_Blocks.ARID_CROCODILE_SCUTE_SLAB, Primal_Blocks.ARID_CROCODILE_SCUTE_BLOCK);
        this.createCubeAll(Primal_Blocks.HUMID_CROCODILE_SCUTE_BLOCK);
        this.createCubeAll(Primal_Blocks.HUMID_CROCODILE_SCUTE_SHINGLE);
        this.createCubeAll(Primal_Blocks.HUMID_CHISELED_CROCODILE_SCUTE);
        this.simpleStairs(Primal_Blocks.HUMID_CROCODILE_SCUTE_STAIRS, Primal_Blocks.HUMID_CROCODILE_SCUTE_BLOCK);
        this.simpleSlab(Primal_Blocks.HUMID_CROCODILE_SCUTE_SLAB, Primal_Blocks.HUMID_CROCODILE_SCUTE_BLOCK);
        this.tintedOverlayCross("river_reeds_top_0", ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"block/river_reeds_top_0"), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"block/river_reeds_top_0_overlay"));
        this.tintedOverlayCross("river_reeds_top_1", ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"block/river_reeds_top_1"), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"block/river_reeds_top_1_overlay"));
        this.tintedCross("river_reeds_middle", ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"block/river_reeds_middle"));
        this.tintedCross("river_reeds_bottom", ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"block/river_reeds_bottom"));
        this.tintedCross(Primal_Blocks.SHORT_RIVER_REEDS.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"block/short_river_reeds"));
        this.createEggModel("eagle_egg_one", "template_one_eagle_egg");
        this.createEggModel("eagle_egg_one_chipped", "template_one_eagle_egg");
        this.createEggModel("eagle_egg_one_cracked", "template_one_eagle_egg");
        this.createEggModel("eagle_egg_two", "template_two_eagle_eggs");
        this.createEggModel("eagle_egg_two_chipped", "template_two_eagle_eggs");
        this.createEggModel("eagle_egg_two_cracked", "template_two_eagle_eggs");
        this.createEggModel("crocodile_egg_one", "template_one_crocodile_egg");
        this.createEggModel("crocodile_egg_one_chipped", "template_one_crocodile_egg");
        this.createEggModel("crocodile_egg_one_cracked", "template_one_crocodile_egg");
        this.createEggModel("crocodile_egg_two", "template_two_crocodile_eggs");
        this.createEggModel("crocodile_egg_two_chipped", "template_two_crocodile_eggs");
        this.createEggModel("crocodile_egg_two_cracked", "template_two_crocodile_eggs");
        this.createEggModel("crocodile_egg_three", "template_three_crocodile_eggs");
        this.createEggModel("crocodile_egg_three_chipped", "template_three_crocodile_eggs");
        this.createEggModel("crocodile_egg_three_cracked", "template_three_crocodile_eggs");
        this.columBlock(Primal_Blocks.STRAW_BALE, "block/straw_bale_side", "block/straw_bale_top");
    }

    private void columBlock(DeferredHolder<Block, Block> block, String side, String top) {
        this.cubeColumn(block.getRegisteredName(), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)side), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)top));
        this.cubeColumnHorizontal(block.getRegisteredName() + "_horizontal", ResourceLocation.fromNamespaceAndPath((String)"primal", (String)side), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)top));
    }

    private void tintedCross(String name, ResourceLocation cross) {
        this.singleTexture(name, "block/tinted_cross", "cross", cross);
    }

    private void tintedOverlayCross(String name, ResourceLocation cross, ResourceLocation overlay) {
        ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(name, ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"tinted_cross_overlay"))).texture("cross", cross)).texture("overlay", overlay);
    }

    private void createCubeAll(DeferredHolder<Block, Block> block) {
        this.cubeAll(block.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)("block/" + block.getId().getPath())));
    }

    private void simpleStairs(DeferredHolder<Block, Block> stairs, DeferredHolder<Block, Block> baseBlock) {
        this.stairs(stairs.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)("block/" + baseBlock.getId().getPath())), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)("block/" + baseBlock.getId().getPath())), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)("block/" + baseBlock.getId().getPath())));
    }

    private void simpleSlab(DeferredHolder<Block, Block> slab, DeferredHolder<Block, Block> baseBlock) {
        this.slab(slab.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)("block/" + baseBlock.getId().getPath())), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)("block/" + baseBlock.getId().getPath())), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)("block/" + baseBlock.getId().getPath())));
    }

    private void singleTexture(String name, String parent, String textureKey, ResourceLocation texture) {
        this.singleTexture(name, this.mcLoc(parent), textureKey, texture);
    }

    private void createEggModel(String name, String type) {
        this.createEggModel(name, type, name);
    }

    private void createEggModel(String name, String parent, String texture) {
        ((BlockModelBuilder)this.withExistingParent(name, ResourceLocation.fromNamespaceAndPath((String)"primal", (String)parent))).texture("egg", ResourceLocation.fromNamespaceAndPath((String)"primal", (String)("block/" + texture)));
    }

    public BlockModelBuilder withExistingParentFalseAmbientOcclusion(String name, ResourceLocation parent) {
        return (BlockModelBuilder)this.getBuilderE(name).parent((ModelFile)this.getExistingFile(parent));
    }

    public BlockModelBuilder getBuilderE(String path) {
        Preconditions.checkNotNull((Object)path, (Object)"Path must not be null");
        ResourceLocation outputLoc = this.extendWithFolder(path.contains(":") ? ResourceLocation.parse((String)path) : ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path));
        this.existingFileHelper.trackGenerated(outputLoc, (ExistingFileHelper.IResourceType)MODEL);
        return this.falseAmbientOcclusionGeneratedModels.computeIfAbsent(outputLoc, this.factory);
    }

    private ResourceLocation extendWithFolder(ResourceLocation rl) {
        if (rl.getPath().contains("/")) {
            return rl;
        }
        return ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)(this.folder + "/" + rl.getPath()));
    }

    @NotNull
    protected CompletableFuture<?> generateAll(@NotNull CachedOutput cache) {
        Path target;
        CompletableFuture[] futures = new CompletableFuture[this.generatedModels.size() + this.falseAmbientOcclusionGeneratedModels.size()];
        int i = 0;
        for (BlockModelBuilder model : this.generatedModels.values()) {
            target = this.getPath((ModelBuilder)model);
            futures[i++] = DataProvider.saveStable((CachedOutput)cache, (JsonElement)model.toJson(), (Path)target);
        }
        for (BlockModelBuilder model : this.falseAmbientOcclusionGeneratedModels.values()) {
            target = this.getPath((ModelBuilder)model);
            JsonObject finalJson = model.toJson();
            finalJson.addProperty("ambientocclusion", Boolean.valueOf(false));
            futures[i++] = DataProvider.saveStable((CachedOutput)cache, (JsonElement)finalJson, (Path)target);
        }
        return CompletableFuture.allOf(futures);
    }
}

