/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomLookAround;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.TryFindLand;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.primal.entity.ai.behavior.eagle.EagleDetectHostile;
import org.primal.entity.ai.behavior.eagle.EagleRemoveHome;
import org.primal.entity.ai.behavior.eagle.EagleSearchHome;
import org.primal.entity.ai.behavior.eagle.EagleSnatch;
import org.primal.entity.ai.behavior.eagle.EagleStartAttack;
import org.primal.entity.ai.behavior.generic.AnimalGoesToNest;
import org.primal.entity.ai.behavior.generic.AnimalSitting;
import org.primal.entity.ai.behavior.generic.AnimalWanderFromScared;
import org.primal.entity.ai.behavior.generic.BirdAvoidWhileAscending;
import org.primal.entity.ai.behavior.generic.BirdReturnHome;
import org.primal.entity.ai.behavior.generic.ConditionalSwim;
import org.primal.entity.ai.behavior.generic.FollowOwner;
import org.primal.entity.ai.behavior.generic.TryLayEggOnLandOrNest;
import org.primal.entity.animal.EagleEntity;
import org.primal.injection.IsEagleTarget;
import org.primal.registry.Primal_Activities;
import org.primal.registry.Primal_Blocks;
import org.primal.registry.Primal_Entities;
import org.primal.registry.Primal_MemoryModuleTypes;
import org.primal.registry.Primal_Sensors;
import org.primal.util.MiscUtil;

public class EagleAi {
    private static final ImmutableList<SensorType<? extends Sensor<? super EagleEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, (Object)((SensorType)Primal_Sensors.NEAREST_BABY.get()), (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.NEAREST_ADULT, (Object)((SensorType)Primal_Sensors.EAGLE_ATTACK_SENSOR.get()), (Object)((SensorType)Primal_Sensors.EAGLE_TEMPTATIONS_SENSOR.get()), (Object)((SensorType)Primal_Sensors.EAGLE_SCARE_SENSOR.get()), (Object)((SensorType)Primal_Sensors.EAGLE_HOSTILE_SENSOR.get()), (Object)((SensorType)Primal_Sensors.NEAREST_NEST.get()));
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryModuleType.NEAREST_ATTACKABLE, (Object)MemoryModuleType.ROAR_TARGET, (Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object[])new MemoryModuleType[]{MemoryModuleType.BREED_TARGET, MemoryModuleType.IS_PANICKING, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.IS_TEMPTED, MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.AVOID_TARGET, MemoryModuleType.HAS_HUNTING_COOLDOWN, MemoryModuleType.NEAREST_REPELLENT, MemoryModuleType.IS_PREGNANT, MemoryModuleType.PACIFIED, MemoryModuleType.ADMIRING_ITEM, MemoryModuleType.NEAREST_HOSTILE, (MemoryModuleType)Primal_MemoryModuleTypes.CHIRP_COOLDOWN.get(), (MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_VISIBLE_BABY.get(), (MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_IMPORTANT_BLOCK.get(), (MemoryModuleType)Primal_MemoryModuleTypes.IS_STUNNED.get(), (MemoryModuleType)Primal_MemoryModuleTypes.IS_SNATCHING.get(), (MemoryModuleType)Primal_MemoryModuleTypes.AMOUNT_ATTACKED.get(), (MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_SCARED.get(), MemoryModuleType.HOME, MemoryModuleType.RAM_COOLDOWN_TICKS, (MemoryModuleType)Primal_MemoryModuleTypes.ATTACKED_LIST.get(), (MemoryModuleType)Primal_MemoryModuleTypes.LAST_ATTACK_TARGET.get()});
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.of((int)5, (int)16);
    private static final UniformInt RETREAT_DURATION = TimeUtil.rangeOfSeconds((int)5, (int)20);

    public static Predicate<ItemStack> getTemptations() {
        return EagleEntity::isMatingFood;
    }

    public static void initMemories(EagleEntity eagle, RandomSource random) {
    }

    public static Brain.Provider<EagleEntity> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static Brain<?> makeBrain(Brain<EagleEntity> brain) {
        EagleAi.initCoreActivity(brain);
        EagleAi.initIdleActivity(brain);
        EagleAi.initFightActivity(brain);
        EagleAi.initSnatchActivity(brain);
        EagleAi.initLayEggActivity(brain);
        EagleAi.initRetreatActivity(brain);
        EagleAi.initNestedActivity(brain);
        EagleAi.initFollowActivity(brain);
        EagleAi.initSitActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<EagleEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)((Object)new ConditionalSwim(0.8f, eagle -> eagle.isBaby() || eagle.getBrain().isActive((Activity)Primal_Activities.SIT.get()))), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    private static void initIdleActivity(Brain<EagleEntity> brain) {
        brain.addActivity(Activity.IDLE, 10, ImmutableList.of((Object)StartAttacking.create(EagleAi::findNearestValidAttackTarget), (Object)((Object)new EagleRemoveHome()), (Object)((Object)new EagleSearchHome()), (Object)((Object)new BirdReturnHome(1600, 25, true)), (Object)new AnimalMakeLove((EntityType)Primal_Entities.EAGLE.get()), (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60)), (Object)new FollowTemptation(livingEntity -> Float.valueOf(1.0f), livingEntity -> livingEntity.isBaby() ? 2.5 : 3.5), (Object)((Object)new AnimalWanderFromScared(5, 8, 5, 10)), EagleAi.createIdleMovementBehaviors()));
    }

    private static void initFightActivity(Brain<EagleEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, ImmutableList.of((Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.0f), (Object)SetEntityLookTarget.create((float)50.0f), (Object)((Object)new EagleStartAttack(10)), (Object)StopAttackingIfTargetInvalid.create(), (Object)EraseMemoryIf.create(eagle -> {
            Optional lastEntity;
            Entity patt0$temp;
            Optional attackedList = eagle.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.ATTACKED_LIST.get());
            Optional<UUID> lastUuid = attackedList.map(List::getLast);
            if (lastUuid.isPresent() && !eagle.level().isClientSide && (patt0$temp = ((ServerLevel)eagle.level()).getEntity(lastUuid.get())) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)patt0$temp;
                v0 = Optional.of(living);
            } else {
                v0 = lastEntity = Optional.empty();
            }
            if (lastEntity.isPresent() && !eagle.getBrain().isMemoryValue(MemoryModuleType.ATTACK_TARGET, (Object)((LivingEntity)lastEntity.get()))) {
                return true;
            }
            return eagle.isInLove() || !eagle.getPassengers().isEmpty();
        }, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET)), MemoryModuleType.ATTACK_TARGET);
    }

    private static void initSnatchActivity(Brain<EagleEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped((Activity)Primal_Activities.SNATCH.get(), 10, ImmutableList.of((Object)((Object)new EagleSnatch(60))), (MemoryModuleType)Primal_MemoryModuleTypes.IS_SNATCHING.get());
    }

    private static void initFollowActivity(Brain<EagleEntity> brain) {
        brain.addActivity((Activity)Primal_Activities.FOLLOW.get(), 10, ImmutableList.of((Object)StartAttacking.create(EagleAi::findNearestValidAttackTarget), (Object)((Object)new EagleRemoveHome()), (Object)((Object)new EagleSearchHome()), (Object)((Object)new EagleDetectHostile()), (Object)new AnimalMakeLove((EntityType)Primal_Entities.EAGLE.get()), (Object)((Object)new FollowOwner()), (Object)new FollowTemptation(livingEntity -> Float.valueOf(1.0f), livingEntity -> livingEntity.isBaby() ? 2.5 : 3.5), (Object)new RandomLookAround((IntProvider)UniformInt.of((int)150, (int)250), 30.0f, 0.0f, 0.0f), EagleAi.createIdleMovementBehaviors()));
    }

    private static void initSitActivity(Brain<EagleEntity> brain) {
        brain.addActivity((Activity)Primal_Activities.SIT.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new AnimalSitting()))));
    }

    private static void initRetreatActivity(Brain<EagleEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, ImmutableList.of((Object)((Object)new BirdAvoidWhileAscending()), (Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.AVOID_TARGET, (float)1.0f, (int)20, (boolean)false)), MemoryModuleType.AVOID_TARGET);
    }

    private static void initNestedActivity(Brain<EagleEntity> brain) {
        brain.addActivity((Activity)Primal_Activities.NESTED.get(), 10, ImmutableList.of((Object)StartAttacking.create(EagleAi::findNearestValidAttackTarget), (Object)((Object)new EagleRemoveHome()), (Object)((Object)new EagleSearchHome()), (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)3.0f, (UniformInt)UniformInt.of((int)30, (int)60)), (Object)SetEntityLookTargetSometimes.create((EntityType)((EntityType)Primal_Entities.EAGLE.get()), (float)16.0f, (UniformInt)UniformInt.of((int)30, (int)60)), (Object)new RandomLookAround((IntProvider)UniformInt.of((int)150, (int)250), 30.0f, 0.0f, 0.0f), (Object)((Object)new BirdReturnHome(1, 1, false)), EagleAi.createIdleMovementBehaviors()));
    }

    public static void wasHurtBy(EagleEntity eagle, LivingEntity target) {
        Brain<EagleEntity> brain = eagle.getBrain();
        brain.eraseMemory(MemoryModuleType.PACIFIED);
        brain.eraseMemory(MemoryModuleType.BREED_TARGET);
        if (eagle.isBaby()) {
            EagleAi.retreatFromNearestTarget(eagle, target);
            for (EagleEntity nearEagle : EagleAi.getNearestAdultEagles(eagle)) {
                nearEagle.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, (Object)target);
            }
        } else {
            eagle.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, (Object)target);
        }
    }

    private static List<EagleEntity> getNearestAdultEagles(EagleEntity eagle) {
        return eagle.level().getEntitiesOfClass(EagleEntity.class, eagle.getBoundingBox().inflate(30.0, 5.0, 30.0)).stream().filter(crocodile1 -> !crocodile1.isBaby()).toList();
    }

    private static void retreatFromNearestTarget(EagleEntity eagle, LivingEntity target) {
        Brain<EagleEntity> brain = eagle.getBrain();
        LivingEntity avoidTarget = BehaviorUtils.getNearestTarget((LivingEntity)eagle, (Optional)brain.getMemory(MemoryModuleType.AVOID_TARGET), (LivingEntity)target);
        avoidTarget = BehaviorUtils.getNearestTarget((LivingEntity)eagle, (Optional)brain.getMemory(MemoryModuleType.ATTACK_TARGET), (LivingEntity)avoidTarget);
        EagleAi.setAvoidTarget(eagle, avoidTarget);
    }

    private static void setAvoidTarget(EagleEntity eagle, LivingEntity target) {
        eagle.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        eagle.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        eagle.getBrain().setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, (Object)target, (long)RETREAT_DURATION.sample(eagle.level().random));
    }

    private static void initLayEggActivity(Brain<EagleEntity> brain) {
        brain.addActivityWithConditions(Activity.LAY_SPAWN, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new AnimalGoesToNest())), (Object)Pair.of((Object)1, TryLayEggOnLandOrNest.create((Block)Primal_Blocks.EAGLE_EGG.get(), MiscUtil.EGGS_2, 2, 1)), (Object)Pair.of((Object)2, (Object)TryFindLand.create((int)16, (float)1.0f)), (Object)Pair.of((Object)3, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)1.0f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)BehaviorBuilder.triggerIf(Entity::onGround), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.IS_PREGNANT, (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static RunOne<EagleEntity> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)BehaviorBuilder.triggerIf(Predicate.not(eagle -> eagle.isAggressive() || eagle.isBaby() && eagle.getBrain().hasMemoryValue(MemoryModuleType.HOME)), (OneShot)RandomStroll.stroll((float)1.0f)), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static void updateActivity(EagleEntity eagle) {
        Brain<EagleEntity> brain = eagle.getBrain();
        if (eagle.isSitting()) {
            eagle.getBrain().setActiveActivityIfPossible((Activity)Primal_Activities.SIT.get());
        } else if (eagle.isFollowing()) {
            eagle.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.AVOID, (Object)((Activity)Primal_Activities.SNATCH.get()), (Object)Activity.FIGHT, (Object)Activity.LAY_SPAWN, (Object)((Activity)Primal_Activities.FOLLOW.get())));
        } else if (eagle.isBaby()) {
            brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.AVOID, (Object)Activity.FIGHT, (Object)((Activity)Primal_Activities.NESTED.get())));
        } else {
            brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.AVOID, (Object)((Activity)Primal_Activities.SNATCH.get()), (Object)Activity.FIGHT, (Object)Activity.LAY_SPAWN, (Object)Activity.IDLE));
        }
        eagle.setAggressive(brain.hasMemoryValue(MemoryModuleType.ATTACK_TARGET) || brain.hasMemoryValue((MemoryModuleType)Primal_MemoryModuleTypes.IS_SNATCHING.get()));
        EagleAi.handleEagleQueue(brain, eagle);
        if (brain.getMemory(MemoryModuleType.ATTACK_TARGET).isPresent()) {
            ((IsEagleTarget)brain.getMemory(MemoryModuleType.ATTACK_TARGET).get()).primal$setEagleAttacking(eagle.getUUID());
            brain.setMemoryWithExpiry((MemoryModuleType)Primal_MemoryModuleTypes.LAST_ATTACK_TARGET.get(), (Object)((LivingEntity)brain.getMemory(MemoryModuleType.ATTACK_TARGET).get()), 80L);
        }
        if (brain.getMemory((MemoryModuleType)Primal_MemoryModuleTypes.LAST_ATTACK_TARGET.get()).isPresent() && brain.getMemory(MemoryModuleType.ATTACK_TARGET).isPresent() && !brain.isMemoryValue((MemoryModuleType)Primal_MemoryModuleTypes.LAST_ATTACK_TARGET.get(), (Object)((LivingEntity)brain.getMemory(MemoryModuleType.ATTACK_TARGET).get())) && MiscUtil.isSameEagleAttacking((LivingEntity)brain.getMemory((MemoryModuleType)Primal_MemoryModuleTypes.LAST_ATTACK_TARGET.get()).get(), (LivingEntity)eagle)) {
            ((IsEagleTarget)brain.getMemory((MemoryModuleType)Primal_MemoryModuleTypes.LAST_ATTACK_TARGET.get()).get()).primal$setEagleAttacking(null);
        }
    }

    private static void handleEagleQueue(Brain<EagleEntity> brain, EagleEntity eagle) {
        ArrayList<UUID> attackedList;
        if (eagle.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_ATTACKABLE)) {
            List<UUID> list = attackedList = brain.hasMemoryValue((MemoryModuleType)Primal_MemoryModuleTypes.ATTACKED_LIST.get()) ? (List)brain.getMemory((MemoryModuleType)Primal_MemoryModuleTypes.ATTACKED_LIST.get()).get() : Lists.newArrayList();
            if (!attackedList.contains(((LivingEntity)brain.getMemory(MemoryModuleType.NEAREST_ATTACKABLE).get()).getUUID())) {
                attackedList.addFirst(((LivingEntity)brain.getMemory(MemoryModuleType.NEAREST_ATTACKABLE).get()).getUUID());
            }
            if (attackedList.size() > 2) {
                attackedList.removeLast();
            }
            brain.setMemory((MemoryModuleType)Primal_MemoryModuleTypes.ATTACKED_LIST.get(), attackedList);
        }
        if (brain.hasMemoryValue((MemoryModuleType)Primal_MemoryModuleTypes.ATTACKED_LIST.get())) {
            attackedList = new ArrayList<UUID>((Collection)brain.getMemory((MemoryModuleType)Primal_MemoryModuleTypes.ATTACKED_LIST.get()).get());
            attackedList.removeIf(uuid -> {
                LivingEntity target;
                Entity patt0$temp = ((ServerLevel)eagle.level()).getEntity(uuid);
                return patt0$temp instanceof LivingEntity && (target = (LivingEntity)patt0$temp).isDeadOrDying() || ((ServerLevel)eagle.level()).getEntity(uuid) == null;
            });
            if (attackedList.isEmpty()) {
                brain.eraseMemory((MemoryModuleType)Primal_MemoryModuleTypes.ATTACKED_LIST.get());
            } else {
                brain.setMemory((MemoryModuleType)Primal_MemoryModuleTypes.ATTACKED_LIST.get(), attackedList);
            }
        }
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(EagleEntity eagle) {
        if (BehaviorUtils.isBreeding((LivingEntity)eagle) || eagle.level().isClientSide) {
            return Optional.empty();
        }
        if (eagle.getBrain().hasMemoryValue((MemoryModuleType)Primal_MemoryModuleTypes.ATTACKED_LIST.get())) {
            List attackedList = (List)eagle.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.ATTACKED_LIST.get()).get();
            Entity entity = ((ServerLevel)eagle.level()).getEntity((UUID)attackedList.getLast());
            if (entity instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity;
                return Optional.of(target);
            }
        }
        return Optional.empty();
    }
}

