/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.bear;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.BearEntity;
import org.primal.registry.Primal_MemoryModuleTypes;

public class BearRaidSweetBerryBush
extends Behavior<BearEntity> {
    public BearRaidSweetBerryBush() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.ROAR_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_BEEHIVE.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_SWEET_BERRY_BUSH.get()), (Object)MemoryStatus.VALUE_PRESENT));
    }

    protected boolean canStillUse(@NotNull ServerLevel level, BearEntity entity, long gameTime) {
        return entity.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_SWEET_BERRY_BUSH.get()).isPresent();
    }

    protected void start(@NotNull ServerLevel level, BearEntity entity, long gameTime) {
        entity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((BlockPos)entity.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_SWEET_BERRY_BUSH.get()).get(), 1.0f, 2));
    }

    protected void tick(@NotNull ServerLevel level, BearEntity bear, long gameTime) {
        BlockPos nearestBush = bear.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_SWEET_BERRY_BUSH.get()).orElse(null);
        if (nearestBush != null && (float)bear.blockPosition().distManhattan((Vec3i)nearestBush) <= 3.0f) {
            BlockState originalState = level.getBlockState(nearestBush);
            if (!originalState.is(Blocks.SWEET_BERRY_BUSH) || !originalState.hasProperty((Property)SweetBerryBushBlock.AGE)) {
                return;
            }
            level.destroyBlock(nearestBush, false, (Entity)bear);
            bear.triggerAnim("attack", "attack");
            bear.playSound(SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, 1.0f, 1.0f);
        }
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, BearEntity owner) {
        if (owner.isBaby() || owner.getHoneyCounter() > 0) {
            return false;
        }
        BlockPos nearestBushPos = owner.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_SWEET_BERRY_BUSH.get()).orElse(null);
        return level.getBlockState(nearestBushPos).is(Blocks.SWEET_BERRY_BUSH) && level.getBlockState(nearestBushPos).hasProperty((Property)SweetBerryBushBlock.AGE) && (Integer)level.getBlockState(nearestBushPos).getValue((Property)SweetBerryBushBlock.AGE) >= 2;
    }
}

