/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.crocodile;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.CrocodileEntity;
import org.primal.registry.Primal_MemoryModuleTypes;

public class CrocodileThrash
extends Behavior<CrocodileEntity> {
    public CrocodileThrash(int maxDuration) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)Primal_MemoryModuleTypes.IS_THRASHING.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)Primal_MemoryModuleTypes.IS_STUNNED.get()), (Object)MemoryStatus.VALUE_ABSENT), maxDuration);
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, CrocodileEntity crocodile) {
        return !crocodile.getPassengers().isEmpty();
    }

    protected void start(@NotNull ServerLevel level, @NotNull CrocodileEntity crocodile, long gameTime) {
        crocodile.setThrashing(true);
        crocodile.setPose(Pose.SPIN_ATTACK);
        if (!crocodile.isSilent()) {
            crocodile.level().broadcastEntityEvent((Entity)crocodile, (byte)99);
        }
        crocodile.stopMoving();
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull CrocodileEntity crocodile, long gameTime) {
        return this.checkExtraStartConditions(level, crocodile) && this.hasRequiredMemories((LivingEntity)crocodile);
    }

    protected void tick(@NotNull ServerLevel level, @NotNull CrocodileEntity crocodile, long gameTime) {
        LivingEntity living;
        Object e;
        LivingEntity target = !crocodile.getPassengers().isEmpty() && (e = crocodile.getPassengers().getFirst()) instanceof LivingEntity ? (living = (LivingEntity)e) : null;
        crocodile.stopMoving();
        if (target == null) {
            this.stop(level, crocodile, gameTime);
            return;
        }
        if (crocodile.isInWater() && !crocodile.isUnderWater()) {
            crocodile.level().broadcastEntityEvent((Entity)crocodile, (byte)80);
        }
        if (gameTime % 2L == 0L) {
            target.hurt(crocodile.level().damageSources().mobAttack((LivingEntity)crocodile), 2.0f);
        }
    }

    protected void stop(@NotNull ServerLevel level, @NotNull CrocodileEntity crocodile, long gameTime) {
        if (!crocodile.getPassengers().isEmpty()) {
            crocodile.ejectPassengers();
        }
        crocodile.setPose(Pose.STANDING);
        crocodile.getBrain().eraseMemory((MemoryModuleType)Primal_MemoryModuleTypes.IS_THRASHING.get());
        crocodile.setThrashing(false);
    }
}

