/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.eagle;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ProjectileWeaponItem;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.EagleEntity;
import org.primal.registry.Primal_MemoryModuleTypes;
import org.primal.util.MiscUtil;

public class EagleStartAttack
extends Behavior<EagleEntity> {
    private final int cooldownBetweenAttacks;

    public EagleStartAttack(int cooldownBetweenAttacks) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.AVOID_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)Primal_MemoryModuleTypes.AMOUNT_ATTACKED.get()), (Object)MemoryStatus.REGISTERED));
        this.cooldownBetweenAttacks = cooldownBetweenAttacks;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull EagleEntity eagle) {
        LivingEntity target = (LivingEntity)eagle.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
        NearestVisibleLivingEntities nearestVisibleLivingEntities = (NearestVisibleLivingEntities)eagle.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).get();
        return !EagleStartAttack.isHoldingUsableProjectileWeapon((Mob)eagle) && eagle.isWithinMeleeAttackRange(target) && nearestVisibleLivingEntities.contains(target) && eagle.getPassengers().isEmpty();
    }

    protected void start(@NotNull ServerLevel level, @NotNull EagleEntity eagle, long gameTime) {
        LivingEntity target = (LivingEntity)eagle.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
        eagle.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)target, true));
        eagle.swing(InteractionHand.MAIN_HAND);
        double speed = eagle.getDeltaMovement().length();
        if (speed > 0.5) {
            target.hurt(level.damageSources().mobAttack((LivingEntity)eagle), 1.0f);
        }
        if (eagle.canPickUpEntity((Entity)target)) {
            target.startRiding((Entity)eagle);
            eagle.setHealthWhenStartRiding(eagle.getHealth());
            eagle.getBrain().setMemory((MemoryModuleType)Primal_MemoryModuleTypes.IS_SNATCHING.get(), (Object)true);
            this.stop(level, eagle, gameTime);
        } else {
            eagle.doHurtTarget((Entity)target);
            if (!eagle.isBaby()) {
                MiscUtil.addToAttackCount((LivingEntity)eagle);
                if (eagle.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.AMOUNT_ATTACKED.get()).isPresent() && (Integer)eagle.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.AMOUNT_ATTACKED.get()).get() > 3) {
                    eagle.getBrain().setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, (Object)target, (long)level.getRandom().nextIntBetweenInclusive(60, 100));
                    eagle.getBrain().setMemory((MemoryModuleType)Primal_MemoryModuleTypes.AMOUNT_ATTACKED.get(), (Object)0);
                }
            }
            this.stop(level, eagle, gameTime);
        }
    }

    protected void tick(@NotNull ServerLevel level, @NotNull EagleEntity eagle, long gameTime) {
    }

    protected void stop(@NotNull ServerLevel level, EagleEntity eagle, long gameTime) {
        if (!eagle.isBaby()) {
            eagle.getBrain().setMemoryWithExpiry(MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (long)this.cooldownBetweenAttacks);
        }
    }

    private static boolean isHoldingUsableProjectileWeapon(Mob mob) {
        return mob.isHolding(stack -> {
            Item item = stack.getItem();
            return item instanceof ProjectileWeaponItem && mob.canFireProjectileWeapon((ProjectileWeaponItem)item);
        });
    }
}

