/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.generic;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.schedule.Activity;
import org.jetbrains.annotations.NotNull;
import org.primal.registry.Primal_Activities;

public class FollowOwner
extends Behavior<TamableAnimal> {
    private final Predicate<TamableAnimal> canFollowPredicate;
    private final int distanceToGet;
    private final int distanceStartFollowing;

    public FollowOwner(Predicate<TamableAnimal> canFollow) {
        this(canFollow, 3, 10);
    }

    public FollowOwner() {
        this(pet -> true, 3, 10);
    }

    public FollowOwner(Predicate<TamableAnimal> canFollow, int distanceToGet) {
        this(canFollow, distanceToGet, 20);
    }

    public FollowOwner(Predicate<TamableAnimal> canFollow, int distanceToGet, int distanceStartFollowing) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), Integer.MAX_VALUE);
        this.canFollowPredicate = canFollow;
        this.distanceToGet = distanceToGet;
        this.distanceStartFollowing = distanceStartFollowing;
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull TamableAnimal pet, long gameTime) {
        return pet.getOwner() != null && pet.getBrain().isActive((Activity)Primal_Activities.FOLLOW.get()) && this.canFollowPredicate.test(pet) && !pet.unableToMoveToOwner() && pet.distanceToSqr((Entity)pet.getOwner()) >= (double)(this.distanceStartFollowing * this.distanceStartFollowing);
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull TamableAnimal pet) {
        return pet.getOwner() != null && this.canFollowPredicate.test(pet) && !pet.unableToMoveToOwner() && pet.distanceToSqr((Entity)pet.getOwner()) >= (double)(this.distanceStartFollowing * this.distanceStartFollowing);
    }

    protected void tick(@NotNull ServerLevel level, @NotNull TamableAnimal pet, long gameTime) {
        this.start(level, pet, gameTime);
    }

    protected void start(@NotNull ServerLevel level, @NotNull TamableAnimal pet, long gameTime) {
        if (!this.canFollowPredicate.test(pet)) {
            this.stop(level, (LivingEntity)pet, gameTime);
            return;
        }
        Optional<LivingEntity> owner = Optional.ofNullable(pet.getOwner());
        if (owner.isEmpty()) {
            this.stop(level, (LivingEntity)pet, gameTime);
            return;
        }
        if (pet.shouldTryTeleportToOwner()) {
            pet.tryToTeleportToOwner();
        } else {
            BehaviorUtils.lookAtEntity((LivingEntity)pet, (LivingEntity)owner.get());
            pet.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((Entity)owner.get(), 1.0f, this.distanceToGet));
        }
    }
}

