/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.generic;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;
import org.primal.block.NestBlock;
import org.primal.registry.Primal_Blocks;
import org.primal.registry.Primal_MemoryModuleTypes;
import org.primal.registry.Primal_Sounds;

public class TryLayEggOnLandOrNest {
    public static BehaviorControl<LivingEntity> create(Block spawnBlock) {
        return TryLayEggOnLandOrNest.create(spawnBlock, null, 0, 0);
    }

    public static BehaviorControl<LivingEntity> create(Block spawnBlock, @Nullable IntegerProperty eggAmountProperty, int maxEggs, int minEggs) {
        return BehaviorBuilder.create((T instance) -> instance.group((App)instance.absent(MemoryModuleType.ATTACK_TARGET), (App)instance.present(MemoryModuleType.WALK_TARGET), (App)instance.present(MemoryModuleType.IS_PREGNANT)).apply((Applicative)instance, (livingEntityMemoryAccessor, walkTargetMemoryAccessor, pregnantMemoryAccessor) -> (level, entity, l) -> {
            boolean needANest;
            boolean bl = needANest = entity.getBrain().hasMemoryValue((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_IMPORTANT_BLOCK.get()) && level.getBlockState((BlockPos)entity.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_IMPORTANT_BLOCK.get()).get()).is(Primal_Blocks.NEST_BLOCK) && (Boolean)level.getBlockState((BlockPos)entity.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_IMPORTANT_BLOCK.get()).get()).getValue((Property)NestBlock.HAS_EGG) == false;
            if (!entity.isInWater() && entity.onGround()) {
                BlockPos blockPosBelow = entity.blockPosition().below();
                boolean foundANest = false;
                Optional<Object> blockPosAboveAroundOptional = Optional.empty();
                if (level.getBlockState(blockPosBelow).is(Primal_Blocks.NEST_BLOCK) && !((Boolean)level.getBlockState(blockPosBelow).getValue((Property)NestBlock.HAS_EGG)).booleanValue()) {
                    foundANest = true;
                    blockPosAboveAroundOptional = Optional.of(blockPosBelow);
                } else {
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        BlockPos blockPosAround = blockPosBelow.relative(direction);
                        if (level.getBlockState(blockPosAround).isAir() || !level.getFluidState(blockPosAround).isEmpty()) continue;
                        BlockPos blockPosAboveAround = blockPosAround.above();
                        if (level.getBlockState(blockPosAboveAround).is(Primal_Blocks.NEST_BLOCK) && !((Boolean)level.getBlockState(blockPosAboveAround).getValue((Property)NestBlock.HAS_EGG)).booleanValue()) {
                            foundANest = true;
                            blockPosAboveAroundOptional = Optional.of(blockPosAboveAround);
                            break;
                        }
                        if (!level.getBlockState(blockPosAboveAround).isAir() || needANest) continue;
                        blockPosAboveAroundOptional = Optional.of(blockPosAboveAround);
                    }
                }
                if (blockPosAboveAroundOptional.isPresent()) {
                    if (foundANest) {
                        ItemStack eggStack = new ItemStack((ItemLike)spawnBlock.asItem(), level.getRandom().nextIntBetweenInclusive(minEggs, maxEggs));
                        NestBlock.getBlockEntity((Level)level, (BlockPos)blockPosAboveAroundOptional.get()).setEgg(eggStack, null);
                        BlockState blockstate = (BlockState)level.getBlockState((BlockPos)blockPosAboveAroundOptional.get()).setValue((Property)NestBlock.HAS_EGG, (Comparable)Boolean.valueOf(true));
                        level.setBlock((BlockPos)blockPosAboveAroundOptional.get(), blockstate, 3);
                        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, (BlockPos)blockPosAboveAroundOptional.get(), GameEvent.Context.of((Entity)entity, (BlockState)blockstate));
                    } else {
                        BlockState blockstate = spawnBlock.defaultBlockState();
                        if (eggAmountProperty != null) {
                            blockstate = (BlockState)blockstate.setValue((Property)eggAmountProperty, (Comparable)Integer.valueOf(level.getRandom().nextIntBetweenInclusive(minEggs, maxEggs)));
                        }
                        level.setBlock((BlockPos)blockPosAboveAroundOptional.get(), blockstate, 3);
                        level.gameEvent((Holder)GameEvent.BLOCK_PLACE, (BlockPos)blockPosAboveAroundOptional.get(), GameEvent.Context.of((Entity)entity, (BlockState)blockstate));
                    }
                    level.playSound(null, (Entity)entity, (SoundEvent)Primal_Sounds.LAYS_EGG.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    pregnantMemoryAccessor.erase();
                    return true;
                }
            }
            return false;
        }));
    }
}

