/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.sensors.bear;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import org.jetbrains.annotations.NotNull;
import org.primal.registry.Primal_Tags;

public class BearRepellentSensor
extends Sensor<LivingEntity> {
    @NotNull
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of((Object)MemoryModuleType.NEAREST_REPELLENT);
    }

    protected void doTick(@NotNull ServerLevel level, LivingEntity entity) {
        entity.getBrain().setMemory(MemoryModuleType.NEAREST_REPELLENT, BearRepellentSensor.findNearestRepellent(level, entity));
    }

    public static Optional<BlockPos> findNearestRepellent(ServerLevel level, LivingEntity bear) {
        return BlockPos.findClosestMatch((BlockPos)bear.blockPosition(), (int)8, (int)4, pos -> level.getBlockState(pos).is(Primal_Tags.Block.BEAR_REPELLENTS));
    }
}

