/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.sensors.crocodile;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.NearestLivingEntitySensor;
import net.minecraft.world.entity.ai.sensing.Sensor;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.CrocodileEntity;

public final class CrocodileAttackEntitySensor
extends NearestLivingEntitySensor<CrocodileEntity> {
    @NotNull
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)super.requires(), List.of(MemoryModuleType.NEAREST_ATTACKABLE)));
    }

    protected void doTick(@NotNull ServerLevel level, @NotNull CrocodileEntity crocodile) {
        super.doTick(level, (LivingEntity)crocodile);
        crocodile.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).stream().flatMap(Collection::stream).filter(target -> Sensor.isEntityAttackable((LivingEntity)crocodile, (LivingEntity)target) && crocodile.canAttack((LivingEntity)target)).findFirst().ifPresentOrElse(ent -> crocodile.getBrain().setMemory(MemoryModuleType.NEAREST_ATTACKABLE, ent), () -> crocodile.getBrain().eraseMemory(MemoryModuleType.NEAREST_ATTACKABLE));
    }
}

