/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.sensors.generic;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.NearestLivingEntitySensor;
import org.jetbrains.annotations.NotNull;
import org.primal.registry.Primal_MemoryModuleTypes;

public final class ScaredSensor<T extends LivingEntity>
extends NearestLivingEntitySensor<T> {
    private final Predicate<LivingEntity> canScare;
    private final Predicate<T> isScared;

    public ScaredSensor(Predicate<LivingEntity> canScare, Predicate<T> isScared) {
        this.canScare = canScare;
        this.isScared = isScared;
    }

    public ScaredSensor(Predicate<LivingEntity> canScare) {
        this(canScare, entity -> true);
    }

    @NotNull
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)super.requires(), List.of((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_SCARED.get())));
    }

    protected void doTick(@NotNull ServerLevel level, @NotNull T animal) {
        super.doTick(level, animal);
        Class<?> entityClass = animal.getClass();
        animal.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).stream().flatMap(Collection::stream).filter(target -> !target.isShiftKeyDown() && !target.isSpectator() && this.canScare.test((LivingEntity)target) && !entityClass.isInstance(target) && this.isScared.test((LivingEntity)animal)).findFirst().ifPresentOrElse(ent -> animal.getBrain().setMemory((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_SCARED.get(), ent), () -> animal.getBrain().eraseMemory((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_SCARED.get()));
    }
}

