/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.animal;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.Unit;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.primal.advancements.criterion.Primal_CustomCriterion;
import org.primal.client.animation.entity.CrocodileAnimations;
import org.primal.entity.ai.CrocodileAi;
import org.primal.entity.ai.controls.CrocodilePathNavigation;
import org.primal.entity.ai.controls.WaterOrLandLookControl;
import org.primal.entity.ai.controls.WaterOrLandMoveControl;
import org.primal.registry.Primal_Advancements;
import org.primal.registry.Primal_Blocks;
import org.primal.registry.Primal_Entities;
import org.primal.registry.Primal_Items;
import org.primal.registry.Primal_MemoryModuleTypes;
import org.primal.registry.Primal_Sounds;
import org.primal.registry.Primal_Tags;
import org.primal.util.HostileMount;
import org.primal.util.MiscUtil;
import org.primal.util.VariantHolderPrimal;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CrocodileEntity
extends Animal
implements VariantHolder<Variant>,
GeoEntity,
ContainerListener,
NeutralMob,
HostileMount,
VariantHolderPrimal<Variant, CrocodileEntity> {
    protected SimpleContainer inventory = new SimpleContainer(54);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.defineId(CrocodileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> HEALTH_WHEN_START_RIDING = SynchedEntityData.defineId(CrocodileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Boolean> THRASHING = SynchedEntityData.defineId(CrocodileEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final float healthLossToBeReleased = 2.0f;
    public static final byte CROCODILE_THRASHING = 99;

    public void containerChanged(@NotNull Container container) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ATTACK_KNOCKBACK, (double)1.2f).add(Attributes.KNOCKBACK_RESISTANCE, (double)0.4f).add(Attributes.STEP_HEIGHT, 1.5);
    }

    public CrocodileEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.setHealth(this.getMaxHealth());
        this.setPathfindingMalus(PathType.WATER, 1.0f);
        this.moveControl = new WaterOrLandMoveControl((Mob)this, 85, 10, 0.18f, 0.01f, false);
        this.lookControl = new WaterOrLandLookControl((Mob)this, 10);
    }

    @NotNull
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (level.getRandom().nextIntBetweenInclusive(0, 100) == 1) {
            this.setVariant(Variant.ALBINO);
        } else {
            this.setVariantFromBiome(this, (Holder<Biome>)level.getBiome(this.blockPosition()));
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    @Override
    public void setVariantFromBiome(CrocodileEntity crocodile, Holder<Biome> holder) {
        if (holder.is(Primal_Tags.Biome.SPAWNS_BLACK_CROCODILE)) {
            crocodile.setVariant(Variant.BLACK);
        } else if (holder.is(Primal_Tags.Biome.SPAWNS_BROWN_CROCODILE)) {
            crocodile.setVariant(Variant.BROWN);
        } else {
            crocodile.setVariant(Variant.GREEN);
        }
    }

    @Override
    public Variant getRareVariant(CrocodileEntity crocodile) {
        return Variant.ALBINO;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{CrocodileAnimations.mainController(this).receiveTriggeredAnimations().triggerableAnim("vomits", CrocodileAnimations.VOMITS).triggerableAnim("basking_start", CrocodileAnimations.BASKING_START).triggerableAnim("basking_end", CrocodileAnimations.BASKING_END), new AnimationController((GeoAnimatable)this, "attack", state -> PlayState.STOP).triggerableAnim("attack", CrocodileAnimations.ATTACK).triggerableAnim("attack_water", CrocodileAnimations.ATTACK_UNDERWATER)});
    }

    public int getMaxHeadXRot() {
        return 25;
    }

    public int getMaxHeadYRot() {
        return 10;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void swing(@NotNull InteractionHand hand) {
        this.triggerAnim("attack", this.isInWater() ? "attack_water" : "attack");
        super.swing(hand);
    }

    public boolean doHurtTarget(@NotNull Entity entity) {
        return super.doHurtTarget(entity);
    }

    public void tick() {
        super.tick();
        if (this.hasClock() && this.tickCount % 20 == 0) {
            float pitch = this.tickCount / 20 % 2 == 0 ? 0.6f : 0.5f;
            this.playSound((SoundEvent)Primal_Sounds.CROCODILE_CLOCK.get(), 1.0f, pitch);
        }
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HEALTH_WHEN_START_RIDING, (Object)Float.valueOf(0.0f));
        builder.define(DATA_VARIANT_ID, (Object)Variant.GREEN.id);
        builder.define(THRASHING, (Object)false);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Variant", this.getVariant().id);
        ListTag listtag = new ListTag();
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack itemstack = this.inventory.getItem(i);
            if (itemstack.isEmpty()) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.putByte("Slot", (byte)i);
            listtag.add((Object)itemstack.save((HolderLookup.Provider)this.registryAccess(), (Tag)compoundtag));
        }
        compound.put("Items", (Tag)listtag);
        compound.putFloat("HealthWhenStarted", this.getHealthWhenStartRiding());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setVariant(Variant.byId(compound.getInt("Variant")));
        ListTag listtag = compound.getList("Items", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.getCompound(i);
            int j = compoundtag.getByte("Slot") & 0xFF;
            if (j >= this.inventory.getContainerSize()) continue;
            this.inventory.setItem(j, ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compoundtag).orElse(ItemStack.EMPTY));
        }
        this.setHealthWhenStartRiding(compound.getFloat("HealthWhenStarted"));
    }

    public float getHealthWhenStartRiding() {
        return ((Float)this.entityData.get(HEALTH_WHEN_START_RIDING)).floatValue();
    }

    public void setHealthWhenStartRiding(float healthWhenStartRiding) {
        this.entityData.set(HEALTH_WHEN_START_RIDING, (Object)Float.valueOf(healthWhenStartRiding));
    }

    public void setVariant(@NotNull Variant variant) {
        this.entityData.set(DATA_VARIANT_ID, (Object)variant.id);
    }

    @NotNull
    public Variant getVariant() {
        return Variant.byId((Integer)this.entityData.get(DATA_VARIANT_ID));
    }

    public boolean isThrashing() {
        return (Boolean)this.entityData.get(THRASHING);
    }

    public void setThrashing(boolean thrashing) {
        this.entityData.set(THRASHING, (Object)thrashing);
    }

    public void spawnChildFromBreeding(@NotNull ServerLevel level, @NotNull Animal mate) {
        this.finalizeSpawnChildFromBreeding(level, mate, null);
        this.getBrain().setMemory(MemoryModuleType.IS_PREGNANT, (Object)Unit.INSTANCE);
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob otherParent) {
        CrocodileEntity crocodile = (CrocodileEntity)((EntityType)Primal_Entities.CROCODILE.get()).create((Level)level);
        if (crocodile != null) {
            CrocodileAi.initMemories(crocodile, level.getRandom());
        }
        return crocodile;
    }

    protected void ageBoundaryReached() {
        super.ageBoundaryReached();
        if (!this.isBaby() && this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            this.spawnAtLocation(new ItemStack((ItemLike)Primal_Items.CROCODILE_SCUTE.get(), this.getRandom().nextIntBetweenInclusive(3, 5)), 1.0f);
        }
    }

    public boolean brushOffScute() {
        if (this.isBaby()) {
            return false;
        }
        this.spawnAtLocation(new ItemStack((ItemLike)Primal_Items.CROCODILE_SCUTE.get()), 1.0f);
        this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
        this.playSound(SoundEvents.ARMADILLO_BRUSH);
        return true;
    }

    public boolean isFood(@NotNull ItemStack stack) {
        return CrocodileEntity.isMatingFood(stack);
    }

    public static boolean isMatingFood(@NotNull ItemStack stack) {
        return stack.is(Items.CHICKEN);
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level level) {
        return new CrocodilePathNavigation((Mob)this, level);
    }

    public boolean onClimbable() {
        return false;
    }

    protected void customServerAiStep() {
        Optional thrashing;
        super.customServerAiStep();
        Brain<CrocodileEntity> brain = this.getBrain();
        brain.tick((ServerLevel)this.level(), (LivingEntity)this);
        CrocodileAi.updateActivity(this);
        if (!this.isInWater()) {
            this.setSprinting(brain.getMemory(MemoryModuleType.ATTACK_TARGET).isPresent());
        }
        if (this.isSprinting() && this.isInWater()) {
            this.setSprinting(false);
        }
        if ((thrashing = this.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.IS_THRASHING.get())).isPresent() && ((Boolean)thrashing.get()).booleanValue() && this.getPassengers().isEmpty()) {
            this.getBrain().eraseMemory((MemoryModuleType)Primal_MemoryModuleTypes.IS_THRASHING.get());
            this.setPose(Pose.STANDING);
            if (this.isThrashing()) {
                this.setThrashing(false);
            }
        }
        if (thrashing.isEmpty() && !this.getPassengers().isEmpty()) {
            this.ejectPassengers();
        }
        if (!this.getPassengers().isEmpty()) {
            this.stopMoving();
        }
        if (this.hasTNT()) {
            this.getBrain().setMemory((MemoryModuleType)Primal_MemoryModuleTypes.IS_EXPLODING.get(), (Object)true);
        } else if (this.getBrain().hasMemoryValue((MemoryModuleType)Primal_MemoryModuleTypes.IS_EXPLODING.get())) {
            this.getBrain().eraseMemory((MemoryModuleType)Primal_MemoryModuleTypes.IS_EXPLODING.get());
        }
    }

    @NotNull
    protected Vec3 collide(@NotNull Vec3 vec) {
        boolean flag3;
        AABB aabb = this.getBoundingBox();
        List list = this.level().getEntityCollisions((Entity)this, aabb.expandTowards(vec));
        Vec3 vec3 = vec.lengthSqr() == 0.0 ? vec : CrocodileEntity.collideBoundingBox((Entity)this, (Vec3)vec, (AABB)aabb, (Level)this.level(), (List)list);
        boolean flag = vec.x != vec3.x;
        boolean flag1 = vec.y != vec3.y;
        boolean flag2 = vec.z != vec3.z;
        boolean bl = flag3 = flag1 && vec.y < 0.0;
        if (this.maxUpStep() > 0.0f && (flag3 || this.onGround() || this.isInWater()) && (flag || flag2)) {
            float[] afloat;
            AABB aabb1 = flag3 ? aabb.move(0.0, vec3.y, 0.0) : aabb;
            AABB aabb2 = aabb1.expandTowards(vec.x, (double)this.maxUpStep(), vec.z);
            if (!flag3) {
                aabb2 = aabb2.expandTowards(0.0, (double)-1.0E-5f, 0.0);
            }
            List list1 = CrocodileEntity.collectColliders((Entity)this, (Level)this.level(), (List)list, (AABB)aabb2);
            float f = (float)vec3.y;
            for (float f1 : afloat = CrocodileEntity.collectCandidateStepUpHeights((AABB)aabb1, (List)list1, (float)this.maxUpStep(), (float)f)) {
                Vec3 vec31 = CrocodileEntity.collideWithShapes((Vec3)new Vec3(vec.x, (double)f1, vec.z), (AABB)aabb1, (List)list1);
                if (!(vec31.horizontalDistanceSqr() > vec3.horizontalDistanceSqr())) continue;
                double d0 = aabb.minY - aabb1.minY;
                return vec31.add(0.0, -d0, 0.0);
            }
        }
        return vec3;
    }

    public void travel(@NotNull Vec3 travelVector) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.isUnderWater()) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, 5.0E-4, 0.0));
            }
        } else {
            super.travel(travelVector);
        }
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        boolean hurt = super.hurt(source, amount);
        if (hurt) {
            Player player;
            LivingEntity target;
            Entity entity;
            ServerPlayer player2;
            Entity entity2;
            if (this.isVehicle() && this.getHealth() < this.getHealthWhenStartRiding() - 2.0f) {
                this.ejectPassengers();
                this.getBrain().setMemoryWithExpiry((MemoryModuleType)Primal_MemoryModuleTypes.IS_STUNNED.get(), (Object)true, 60L);
            }
            if (source.getEntity() != null && (entity2 = source.getEntity()) instanceof ServerPlayer && (player2 = (ServerPlayer)entity2).getMainHandItem().isEmpty()) {
                ((Primal_CustomCriterion)((Object)Primal_Advancements.PUNCH_CROCODILE.get())).trigger(player2);
            }
            if (!(!((entity = source.getEntity()) instanceof LivingEntity) || (target = (LivingEntity)entity) instanceof Player && (player = (Player)target).isCreative())) {
                CrocodileAi.wasHurtBy(this, target);
            }
        }
        return hurt;
    }

    @NotNull
    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        return new Vec3(passenger.getX(), passenger.getY() + 0.1, passenger.getZ());
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean canRiderInteract() {
        return true;
    }

    @org.jetbrains.annotations.Nullable
    public LivingEntity getControllingPassenger() {
        return null;
    }

    protected void positionRider(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (this.hasPassenger(passenger)) {
            double y = this.getY();
            float bodyYawRad = this.yBodyRot * ((float)Math.PI / 180);
            double forwardOffset = -1.2;
            double sideOffset = -0.0;
            double x = this.getX() + (double)Mth.sin((float)bodyYawRad) * forwardOffset + (double)Mth.cos((float)bodyYawRad) * sideOffset;
            double z = this.getZ() - (double)Mth.cos((float)bodyYawRad) * forwardOffset + (double)Mth.sin((float)bodyYawRad) * sideOffset;
            callback.accept(passenger, x, y, z);
        }
    }

    public static boolean canPickUpEntity(@NotNull Entity target, @NotNull CrocodileEntity crocodile) {
        return target.getBoundingBox().getSize() < crocodile.getBoundingBox().getSize() && !crocodile.getBrain().hasMemoryValue((MemoryModuleType)Primal_MemoryModuleTypes.IS_STUNNED.get());
    }

    public void stopMoving() {
        this.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        this.getNavigation().stop();
        this.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
    }

    @NotNull
    public Vec3 getFluidFallingAdjustedMovement(double gravity, boolean isFalling, @NotNull Vec3 deltaMovement) {
        if (gravity != 0.0 && !this.isSprinting()) {
            double d0 = isFalling && Math.abs(deltaMovement.y - 0.005) >= 0.003 && Math.abs(deltaMovement.y - gravity / 16.0) < 0.003 ? -1.0E-4 : deltaMovement.y - gravity / 16.0;
            return new Vec3(deltaMovement.x, d0, deltaMovement.z);
        }
        return deltaMovement;
    }

    public float getSpeed() {
        return this.isSprinting() ? super.getSpeed() * 1.375f : super.getSpeed();
    }

    protected void registerGoals() {
    }

    @NotNull
    protected Brain.Provider<CrocodileEntity> brainProvider() {
        return CrocodileAi.brainProvider();
    }

    @NotNull
    protected Brain<?> makeBrain(@NotNull Dynamic<?> dynamic) {
        return CrocodileAi.makeBrain((Brain<CrocodileEntity>)this.brainProvider().makeBrain(dynamic));
    }

    @NotNull
    public Brain<CrocodileEntity> getBrain() {
        return super.getBrain();
    }

    @org.jetbrains.annotations.Nullable
    public LivingEntity getTarget() {
        return this.getTargetFromBrain();
    }

    public boolean canAttack(@NotNull LivingEntity target) {
        if (this.getBrain().isMemoryValue(MemoryModuleType.ATTACK_TARGET, (Object)target) && super.canAttack(target)) {
            return true;
        }
        return super.canAttack(target) && (target.getType().is(Primal_Tags.Entity.CROCODILE_HUNTABLE) && !this.getBrain().hasMemoryValue(MemoryModuleType.HAS_HUNTING_COOLDOWN) || this.getBrain().hasMemoryValue((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_VISIBLE_BABY.get()) && !(target instanceof CrocodileEntity) && !target.isShiftKeyDown() || this.getLastHurtByMob() == target || this.getBrain().hasMemoryValue((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_IMPORTANT_BLOCK.get()) && this.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_IMPORTANT_BLOCK.get()).isPresent() && this.level().getBlockState((BlockPos)this.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_IMPORTANT_BLOCK.get()).get()).is((Block)Primal_Blocks.CROCODILE_EGG.get()) && !(target instanceof CrocodileEntity) && !target.isShiftKeyDown() || target.distanceTo((Entity)this) < 8.0f && !(target instanceof CrocodileEntity) && !target.isShiftKeyDown()) && !this.isPacified() && MiscUtil.isNotNeverAttack(target) && !target.getType().is(Primal_Tags.Entity.CROCODILE_NEVER_ATTACK);
    }

    public boolean killedEntity(@NotNull ServerLevel level, @NotNull LivingEntity killed) {
        if (killed.getType().is(Primal_Tags.Entity.CROCODILE_HUNTABLE)) {
            this.getBrain().setMemoryWithExpiry(MemoryModuleType.HAS_HUNTING_COOLDOWN, (Object)true, 600L);
        }
        return super.killedEntity(level, killed);
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (hand == InteractionHand.MAIN_HAND && !this.isAggressive() && !this.isBaby()) {
            if (itemstack.canPerformAction(ItemAbilities.BRUSH_BRUSH) && this.brushOffScute()) {
                itemstack.hurtAndBreak(16, (LivingEntity)player, CrocodileEntity.getSlotForHand((InteractionHand)hand));
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (itemstack.is(Tags.Items.FEATHERS) && !this.inventory.isEmpty()) {
                double y = this.getY();
                float bodyYawRad = this.yBodyRot * ((float)Math.PI / 180);
                double forwardOffset = -1.3;
                double sideOffset = -0.0;
                double x = this.getX() + (double)Mth.sin((float)bodyYawRad) * forwardOffset + (double)Mth.cos((float)bodyYawRad) * sideOffset;
                double z = this.getZ() - (double)Mth.cos((float)bodyYawRad) * forwardOffset + (double)Mth.sin((float)bodyYawRad) * sideOffset;
                NonNullList items = this.inventory.getItems();
                int maxIndex = 0;
                for (ItemStack stack : items) {
                    if (stack.isEmpty()) continue;
                    ++maxIndex;
                }
                if (maxIndex != 0) {
                    --maxIndex;
                }
                ItemStack stackToDrop = (ItemStack)items.get(maxIndex);
                this.inventory.setItem(maxIndex, ItemStack.EMPTY);
                ItemEntity itementity = new ItemEntity(this.level(), x, y, z, stackToDrop);
                itementity.setDefaultPickUpDelay();
                this.level().addFreshEntity((Entity)itementity);
                if (!this.level().isClientSide) {
                    this.triggerAnim("base_controller", "vomits");
                }
                if (this.getVomitSound() != null) {
                    this.playSound(this.getVomitSound(), 1.0f, 1.0f);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ((Primal_CustomCriterion)((Object)Primal_Advancements.TICKLE_CROC.get())).trigger(serverPlayer);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (!this.isFood(itemstack) && this.canEatItem(itemstack)) {
                if (itemstack.is(Primal_Tags.Item.MAKES_CROCODILE_TICK_TOCK) && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ((Primal_CustomCriterion)((Object)Primal_Advancements.CLOCK_CROC.get())).trigger(serverPlayer);
                }
                List<ItemStack> stack = List.of(itemstack);
                this.addItemsToInventory(stack);
                itemstack.shrink(itemstack.getCount());
                if (!this.level().isClientSide) {
                    this.triggerAnim("base_controller", "vomits");
                }
                if (this.getEatSound() != null) {
                    this.playSound(this.getEatSound(), 1.0f, 1.0f);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
        }
        if (this.isFood(itemstack) && !this.isAggressive()) {
            int i = this.getAge();
            if (!this.level().isClientSide && i == 0) {
                this.usePlayerItem(player, hand, itemstack);
                if (this.canFallInLove()) {
                    this.setInLove(player);
                }
                this.getBrain().setMemoryWithExpiry(MemoryModuleType.PACIFIED, (Object)true, 1200L);
                this.level().broadcastEntityEvent((Entity)this, (byte)38);
                return InteractionResult.SUCCESS;
            }
            if (this.isBaby()) {
                this.usePlayerItem(player, hand, itemstack);
                this.ageUp(CrocodileEntity.getSpeedUpSecondsWhenFeeding((int)(-i)), true);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (this.level().isClientSide) {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public void handleEntityEvent(byte id) {
        if (id == 38) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
        } else if (id == 80) {
            this.addSplashes();
        } else {
            super.handleEntityEvent(id);
        }
    }

    private void addSplashes() {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.random.nextGaussian() * 0.01;
            double d1 = this.random.nextGaussian() * 0.01;
            double d2 = this.random.nextGaussian() * 0.01;
            this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(1.0), d0, d1, d2);
        }
    }

    private void addParticlesAroundSelf(ParticleOptions particleOption) {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.random.nextGaussian() * 0.01;
            double d1 = this.random.nextGaussian() * 0.01;
            double d2 = this.random.nextGaussian() * 0.01;
            this.level().addParticle(particleOption, this.getRandomX(1.0), this.getRandomY() + 0.2, this.getRandomZ(1.0), d0, d1, d2);
        }
    }

    public boolean isPacified() {
        return this.getBrain().hasMemoryValue(MemoryModuleType.PACIFIED);
    }

    public boolean canEatItem(ItemStack drop) {
        return this.inventory.canAddItem(drop) && !drop.is(Primal_Tags.Item.CROCODILE_CANT_EAT) && !drop.isEmpty();
    }

    public void addItemsToInventory(Collection<ItemStack> drops) {
        for (ItemStack stack : drops) {
            if (!this.inventory.canAddItem(stack)) continue;
            this.inventory.addItem(stack);
        }
    }

    public Optional<GlobalPos> getCompassPos() {
        Optional compassPos = Optional.empty();
        for (ItemStack stack : this.inventory.getItems()) {
            if (!stack.has(DataComponents.LODESTONE_TRACKER) || stack.get(DataComponents.LODESTONE_TRACKER) == null) continue;
            compassPos = ((LodestoneTracker)stack.get(DataComponents.LODESTONE_TRACKER)).target();
        }
        return compassPos;
    }

    public boolean hasClock() {
        return this.inventory.hasAnyMatching(stack -> stack.is(Primal_Tags.Item.MAKES_CROCODILE_TICK_TOCK));
    }

    public boolean hasTNT() {
        return this.inventory.hasAnyMatching(stack -> stack.is(Primal_Tags.Item.MAKES_CROCODILE_EXPLODE));
    }

    public void explode() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            float f = this.isBaby() ? 0.5f : 2.0f;
            this.dead = true;
            int explosionRadius = this.isBaby() ? 1 : 3;
            Explosion explosion = this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), (float)explosionRadius * f, Level.ExplosionInteraction.MOB);
            for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                if (!this.inventory.getItem(i).is(Primal_Tags.Item.MAKES_CROCODILE_EXPLODE)) continue;
                this.inventory.getItem(0).shrink(1);
                break;
            }
            this.dropCustomDeathLoot(serverLevel, this.damageSources().explosion(explosion), true);
            this.discard();
        }
    }

    protected void dropCustomDeathLoot(@NotNull ServerLevel level, @NotNull DamageSource damageSource, boolean recentlyHit) {
        if (!this.inventory.isEmpty()) {
            for (ItemStack stack : this.inventory.getItems()) {
                this.spawnAtLocation(stack);
            }
        }
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent getAmbientSound() {
        if (!this.isThrashing()) {
            return (SoundEvent)Primal_Sounds.CROCODILE_IDLE.get();
        }
        return null;
    }

    public int getAmbientSoundInterval() {
        return 200;
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return (SoundEvent)Primal_Sounds.CROCODILE_HURT.get();
    }

    protected void playAttackSound() {
        this.playSound((SoundEvent)Primal_Sounds.CROCODILE_ATTACK.get(), 1.0f, 1.0f);
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)Primal_Sounds.CROCODILE_DEATH.get();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent getVomitSound() {
        return (SoundEvent)Primal_Sounds.CROCODILE_VOMIT.get();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent getEatSound() {
        return (SoundEvent)Primal_Sounds.CROCODILE_EAT.get();
    }

    public int getMaxAirSupply() {
        return 4800;
    }

    public boolean isPushedByFluid(@NotNull FluidType type) {
        return false;
    }

    public float getAgeScale() {
        return this.isBaby() ? 0.3f : 1.0f;
    }

    public boolean checkSpawnObstruction(LevelReader level) {
        return level.isUnobstructed((Entity)this);
    }

    public static boolean checkCrocodileSpawnRules(EntityType<? extends Animal> animal, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return pos.getY() >= level.getSeaLevel() - 10 && CrocodileEntity.isNearWater(level, pos, 5, 2);
    }

    protected static boolean isNearWater(LevelAccessor level, BlockPos pos, int lateralDistance, int verticalDistance) {
        BlockPos.MutableBlockPos check = new BlockPos.MutableBlockPos();
        for (int dx = -lateralDistance; dx <= lateralDistance; ++dx) {
            for (int dz = -lateralDistance; dz <= lateralDistance; ++dz) {
                for (int dy = -verticalDistance; dy <= verticalDistance; ++dy) {
                    check.set(pos.getX() + dx, pos.getY() + dy, pos.getZ() + dz);
                    if (!level.isAreaLoaded((BlockPos)check, 1) || !level.getFluidState((BlockPos)check).is(FluidTags.WATER)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public int getRemainingPersistentAngerTime() {
        return 0;
    }

    public void setRemainingPersistentAngerTime(int remainingPersistentAngerTime) {
    }

    @org.jetbrains.annotations.Nullable
    public UUID getPersistentAngerTarget() {
        return null;
    }

    public void setPersistentAngerTarget(@org.jetbrains.annotations.Nullable UUID persistentAngerTarget) {
    }

    public void startPersistentAngerTimer() {
    }

    public static enum Variant implements StringRepresentable
    {
        GREEN(0, "green"),
        BROWN(1, "brown"),
        BLACK(2, "black"),
        ALBINO(3, "albino");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Variant::values);
            BY_ID = ByIdMap.continuous(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

