/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.animal;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.Unit;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import org.jetbrains.annotations.NotNull;
import org.primal.client.animation.entity.EagleAnimations;
import org.primal.entity.ai.EagleAi;
import org.primal.entity.ai.controls.EagleMoveControl;
import org.primal.registry.Primal_Activities;
import org.primal.registry.Primal_Entities;
import org.primal.registry.Primal_MemoryModuleTypes;
import org.primal.registry.Primal_Sounds;
import org.primal.registry.Primal_Tags;
import org.primal.util.HostileMount;
import org.primal.util.MiscUtil;
import org.primal.util.VariantHolderPrimal;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EagleEntity
extends TamableAnimal
implements VariantHolder<Variant>,
GeoEntity,
NeutralMob,
VariantHolderPrimal<Variant, EagleEntity>,
HostileMount,
FlyingAnimal {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.defineId(EagleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> HEALTH_WHEN_START_RIDING = SynchedEntityData.defineId(EagleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.defineId(EagleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> FOLLOWER_STATE = SynchedEntityData.defineId(EagleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final float healthLossToBeReleased = 2.0f;

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, (double)0.24f).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.FLYING_SPEED, (double)0.4f).add(Attributes.FOLLOW_RANGE, 48.0).add(Attributes.STEP_HEIGHT, 2.0);
    }

    public EagleEntity(EntityType<EagleEntity> entityType, Level level) {
        super(entityType, level);
        this.setHealth(this.getMaxHealth());
        this.moveControl = new EagleMoveControl((Mob)this, 10, false);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
    }

    @NotNull
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setVariantFromBiome(this, (Holder<Biome>)level.getBiome(this.blockPosition()));
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    @Override
    public void setVariantFromBiome(EagleEntity eagle, Holder<Biome> holder) {
        if (holder.is(Primal_Tags.Biome.SPAWNS_GOLDEN_EAGLE)) {
            eagle.setVariant(Variant.GOLDEN);
        } else if (holder.is(Primal_Tags.Biome.SPAWNS_HARPY_EAGLE)) {
            eagle.setVariant(Variant.HARPY);
        } else if (holder.is(Primal_Tags.Biome.SPAWNS_PHILIPPINE_EAGLE)) {
            eagle.setVariant(Variant.PHILIPPINE);
        } else {
            eagle.setVariant(Variant.BALD);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(EagleAnimations.mainController(this).receiveTriggeredAnimations());
    }

    public int getMaxHeadXRot() {
        return this.onGround() ? 40 : 90;
    }

    public int getMaxHeadYRot() {
        return this.onGround() ? 15 : 1;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void swing(@NotNull InteractionHand hand) {
        super.swing(hand);
    }

    public boolean doHurtTarget(@NotNull Entity entity) {
        return super.doHurtTarget(entity);
    }

    public void tick() {
        super.tick();
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT_ID, (Object)Variant.BALD.id);
        builder.define(HEALTH_WHEN_START_RIDING, (Object)Float.valueOf(0.0f));
        builder.define(FOLLOWER_STATE, (Object)0);
        builder.define(DATA_COLLAR_COLOR, (Object)DyeColor.RED.getId());
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Variant", this.getVariant().id);
        compound.putFloat("HealthWhenStarted", this.getHealthWhenStartRiding());
        if (this.getOwnerUUID() != null) {
            compound.putInt("FollowerState", this.getFollowerState());
        }
        compound.putByte("CollarColor", (byte)this.getCollarColor().getId());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setVariant(Variant.byId(compound.getInt("Variant")));
        this.setHealthWhenStartRiding(compound.getFloat("HealthWhenStarted"));
        if (compound.hasUUID("Owner")) {
            this.setFollowerState(compound.getInt("FollowerState"));
        }
        if (compound.contains("CollarColor", 99)) {
            this.setCollarColor(DyeColor.byId((int)compound.getInt("CollarColor")));
        }
    }

    public float getHealthWhenStartRiding() {
        return ((Float)this.entityData.get(HEALTH_WHEN_START_RIDING)).floatValue();
    }

    public void setHealthWhenStartRiding(float healthWhenStartRiding) {
        this.entityData.set(HEALTH_WHEN_START_RIDING, (Object)Float.valueOf(healthWhenStartRiding));
    }

    public void setVariant(@NotNull Variant variant) {
        this.entityData.set(DATA_VARIANT_ID, (Object)variant.id);
    }

    @NotNull
    public Variant getVariant() {
        return Variant.byId((Integer)this.entityData.get(DATA_VARIANT_ID));
    }

    public DyeColor getCollarColor() {
        return DyeColor.byId((int)((Integer)this.entityData.get(DATA_COLLAR_COLOR)));
    }

    private void setCollarColor(DyeColor collarColor) {
        this.entityData.set(DATA_COLLAR_COLOR, (Object)collarColor.getId());
    }

    public int getFollowerState() {
        return (Integer)this.entityData.get(FOLLOWER_STATE);
    }

    public void setFollowerState(int state) {
        this.entityData.set(FOLLOWER_STATE, (Object)state);
    }

    public boolean isSitting() {
        return this.getFollowerState() == 2;
    }

    public boolean isFollowing() {
        return this.getFollowerState() == 1;
    }

    public boolean isWandering() {
        return this.getFollowerState() == 0;
    }

    public void spawnChildFromBreeding(@NotNull ServerLevel level, @NotNull Animal mate) {
        this.finalizeSpawnChildFromBreeding(level, mate, null);
        this.getBrain().setMemory(MemoryModuleType.IS_PREGNANT, (Object)Unit.INSTANCE);
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob otherParent) {
        EagleEntity eagle = (EagleEntity)((EntityType)Primal_Entities.EAGLE.get()).create((Level)level);
        if (eagle != null) {
            EagleAi.initMemories(eagle, level.getRandom());
        }
        return eagle;
    }

    public boolean isFood(@NotNull ItemStack stack) {
        return EagleEntity.isMatingFood(stack) || EagleEntity.isHealFood(stack) || EagleEntity.isTameFood(stack);
    }

    public static boolean isTameFood(@NotNull ItemStack stack) {
        return stack.is(Items.CHICKEN);
    }

    public static boolean isHealFood(@NotNull ItemStack stack) {
        return EagleEntity.isTameFood(stack) || EagleEntity.isMatingFood(stack);
    }

    public static boolean isMatingFood(@NotNull ItemStack stack) {
        return stack.is(Items.RABBIT_STEW);
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level);
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(true);
        flyingpathnavigation.setCanPassDoors(true);
        return flyingpathnavigation;
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    protected boolean canFlyToOwner() {
        return !this.isBaby();
    }

    public void stopMoving() {
        this.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        this.getNavigation().stop();
        this.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
    }

    protected boolean isAffectedByFluids() {
        return this.isBaby() || this.getBrain().isActive((Activity)Primal_Activities.SIT.get());
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        Brain<EagleEntity> brain = this.getBrain();
        brain.tick((ServerLevel)this.level(), (LivingEntity)this);
        Optional snatching = this.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.IS_SNATCHING.get());
        if (snatching.isPresent() && ((Boolean)snatching.get()).booleanValue() && this.getPassengers().isEmpty()) {
            this.getBrain().eraseMemory((MemoryModuleType)Primal_MemoryModuleTypes.IS_SNATCHING.get());
            this.setPose(Pose.STANDING);
        }
        if (snatching.isEmpty() && !this.getPassengers().isEmpty()) {
            this.ejectPassengers();
        }
        EagleAi.updateActivity(this);
    }

    public void aiStep() {
        super.aiStep();
        if (!this.isBaby()) {
            Vec3 vec3 = this.getDeltaMovement();
            if (!this.onGround() && vec3.y < 0.0) {
                this.setDeltaMovement(vec3.multiply(1.0, this.getXRot() > 50.0f ? 1.1 : 0.6, 1.0));
            }
        }
    }

    public void travel(@NotNull Vec3 travelVector) {
        if (this.isControlledByLocalInstance()) {
            boolean flag;
            double d0 = this.getGravity();
            boolean bl = flag = this.getDeltaMovement().y <= 0.0;
            if (flag && this.hasEffect(MobEffects.SLOW_FALLING)) {
                d0 = Math.min(d0, 0.01);
            }
            FluidState fluidstate = this.level().getFluidState(this.blockPosition());
            if ((this.isInWater() || this.isInFluidType(fluidstate) && fluidstate.getFluidType() != NeoForgeMod.LAVA_TYPE.value()) && this.isAffectedByFluids() && !this.canStandOnFluid(fluidstate)) {
                if (this.isInWater() || this.isInFluidType(fluidstate) && !this.moveInFluid(fluidstate, travelVector, d0)) {
                    double d9 = this.getY();
                    float f4 = this.isSprinting() ? 0.9f : this.getWaterSlowDown();
                    float f5 = 0.02f;
                    float f6 = (float)this.getAttributeValue(Attributes.WATER_MOVEMENT_EFFICIENCY);
                    if (!this.onGround()) {
                        f6 *= 0.5f;
                    }
                    if (f6 > 0.0f) {
                        f4 += (0.54600006f - f4) * f6;
                        f5 += (this.getSpeed() - f5) * f6;
                    }
                    if (this.hasEffect(MobEffects.DOLPHINS_GRACE)) {
                        f4 = 0.96f;
                    }
                    this.moveRelative(f5 *= (float)this.getAttributeValue(NeoForgeMod.SWIM_SPEED), travelVector);
                    this.move(MoverType.SELF, this.getDeltaMovement());
                    Vec3 vec36 = this.getDeltaMovement();
                    if (this.horizontalCollision && this.onClimbable()) {
                        vec36 = new Vec3(vec36.x, 0.2, vec36.z);
                    }
                    this.setDeltaMovement(vec36.multiply((double)f4, (double)0.8f, (double)f4));
                    Vec3 vec32 = this.getFluidFallingAdjustedMovement(d0, flag, this.getDeltaMovement());
                    this.setDeltaMovement(vec32);
                    if (this.horizontalCollision && this.isFree(vec32.x, vec32.y + (double)0.6f - this.getY() + d9, vec32.z)) {
                        this.setDeltaMovement(vec32.x, 0.3f, vec32.z);
                    }
                }
            } else if (this.isInLava() && this.isAffectedByFluids() && !this.canStandOnFluid(fluidstate)) {
                double d8 = this.getY();
                this.moveRelative(0.02f, travelVector);
                this.move(MoverType.SELF, this.getDeltaMovement());
                if (this.getFluidHeight(FluidTags.LAVA) <= this.getFluidJumpThreshold()) {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, (double)0.8f, 0.5));
                    Vec3 vec33 = this.getFluidFallingAdjustedMovement(d0, flag, this.getDeltaMovement());
                    this.setDeltaMovement(vec33);
                } else {
                    this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
                }
                if (d0 != 0.0) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, -d0 / 4.0, 0.0));
                }
                Vec3 vec34 = this.getDeltaMovement();
                if (this.horizontalCollision && this.isFree(vec34.x, vec34.y + (double)0.6f - this.getY() + d8, vec34.z)) {
                    this.setDeltaMovement(vec34.x, 0.3f, vec34.z);
                }
            } else if (this.isFallFlying()) {
                double d11;
                double d7;
                float f1;
                this.checkSlowFallDistance();
                Vec3 vec3 = this.getDeltaMovement();
                Vec3 vec31 = this.getLookAngle();
                float f = this.getXRot() * ((float)Math.PI / 180);
                double d1 = Math.sqrt(vec31.x * vec31.x + vec31.z * vec31.z);
                double d3 = vec3.horizontalDistance();
                double d4 = vec31.length();
                double d5 = Math.cos(f);
                d5 = d5 * d5 * Math.min(1.0, d4 / 0.4);
                vec3 = this.getDeltaMovement().add(0.0, d0 * (-1.0 + d5 * 0.75), 0.0);
                if (vec3.y < 0.0 && d1 > 0.0) {
                    double d6 = vec3.y * -0.1 * d5;
                    vec3 = vec3.add(vec31.x * d6 / d1, d6, vec31.z * d6 / d1);
                }
                if (f < 0.0f && d1 > 0.0) {
                    double d10 = d3 * (double)(-Mth.sin((float)f)) * 0.04;
                    vec3 = vec3.add(-vec31.x * d10 / d1, d10 * 3.2, -vec31.z * d10 / d1);
                }
                if (d1 > 0.0) {
                    vec3 = vec3.add((vec31.x / d1 * d3 - vec3.x) * 0.1, 0.0, (vec31.z / d1 * d3 - vec3.z) * 0.1);
                }
                this.setDeltaMovement(vec3.multiply((double)0.99f, (double)0.98f, (double)0.99f));
                this.move(MoverType.SELF, this.getDeltaMovement());
                if (this.horizontalCollision && !this.level().isClientSide && (f1 = (float)((d7 = d3 - (d11 = this.getDeltaMovement().horizontalDistance())) * 10.0 - 3.0)) > 0.0f) {
                    this.playSound(this.getFallDamageSound((int)f1), 1.0f, 1.0f);
                    this.hurt(this.damageSources().flyIntoWall(), f1);
                }
                if (this.onGround() && !this.level().isClientSide) {
                    this.setSharedFlag(7, false);
                }
            } else {
                BlockPos blockpos = this.getBlockPosBelowThatAffectsMyMovement();
                float f2 = this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getFriction((LevelReader)this.level(), this.getBlockPosBelowThatAffectsMyMovement(), (Entity)this);
                float f3 = this.onGround() ? f2 * 0.91f : 0.98f;
                Vec3 vec35 = this.handleRelativeFrictionAndCalculateMovement(travelVector, f2);
                double d2 = vec35.y;
                d2 = this.hasEffect(MobEffects.LEVITATION) ? (d2 += (0.05 * (double)(this.getEffect(MobEffects.LEVITATION).getAmplifier() + 1) - vec35.y) * 0.2) : (!this.level().isClientSide || this.level().hasChunkAt(blockpos) ? (d2 -= d0) : (this.getY() > (double)this.level().getMinBuildHeight() ? -0.1 : 0.0));
                if (this.shouldDiscardFriction()) {
                    this.setDeltaMovement(vec35.x, d2, vec35.z);
                } else {
                    this.setDeltaMovement(vec35.x * (double)f3, this instanceof FlyingAnimal ? d2 * (double)f3 : d2 * (double)0.98f, vec35.z * (double)f3);
                }
            }
        }
        this.calculateEntityAnimation(this instanceof FlyingAnimal);
    }

    private SoundEvent getFallDamageSound(int height) {
        return height > 4 ? this.getFallSounds().big() : this.getFallSounds().small();
    }

    public boolean shouldDiscardFriction() {
        return false;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
        this.setZza(speed);
    }

    protected void checkFallDamage(double y, boolean onGround, @NotNull BlockState state, @NotNull BlockPos pos) {
        if (this.isBaby()) {
            super.checkFallDamage(y, onGround, state, pos);
        }
    }

    protected void registerGoals() {
    }

    @NotNull
    protected Brain.Provider<EagleEntity> brainProvider() {
        return EagleAi.brainProvider();
    }

    @NotNull
    protected Brain<?> makeBrain(@NotNull Dynamic<?> dynamic) {
        return EagleAi.makeBrain((Brain<EagleEntity>)this.brainProvider().makeBrain(dynamic));
    }

    @NotNull
    public Brain<EagleEntity> getBrain() {
        return super.getBrain();
    }

    @org.jetbrains.annotations.Nullable
    public LivingEntity getTarget() {
        return this.getTargetFromBrain();
    }

    public boolean canAttack(@NotNull LivingEntity target) {
        Optional lastEntity;
        Entity entity;
        Optional attackedList = this.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.ATTACKED_LIST.get());
        Optional<UUID> lastUuid = attackedList.map(List::getLast);
        if (lastUuid.isPresent() && !this.level().isClientSide && (entity = ((ServerLevel)this.level()).getEntity(lastUuid.get())) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            v0 = Optional.of(living);
        } else {
            v0 = lastEntity = Optional.empty();
        }
        if (lastEntity.isPresent() && lastEntity.get() == target && super.canAttack(target) && MiscUtil.isSameEagleAttacking(target, (LivingEntity)this)) {
            return true;
        }
        if (this.isTame()) {
            return super.canAttack(target) && MiscUtil.isNotNeverAttack(target) && MiscUtil.isSameEagleAttacking(target, (LivingEntity)this);
        }
        return super.canAttack(target) && MiscUtil.isNotNeverAttack(target) && !(target instanceof EagleEntity) && this.getLastHurtByMob() != target && (target.getType().is(Primal_Tags.Entity.EAGLE_HUNTABLE) && !this.getBrain().hasMemoryValue(MemoryModuleType.HAS_HUNTING_COOLDOWN) || this.getLastHurtByMob() == target) && MiscUtil.isSameEagleAttacking(target, (LivingEntity)this);
    }

    public boolean canPickUpEntity(@NotNull Entity target) {
        LivingEntity livingTarget;
        return target.getBoundingBox().getSize() < this.getBoundingBox().getSize() * 1.049 && !this.getBrain().hasMemoryValue((MemoryModuleType)Primal_MemoryModuleTypes.IS_STUNNED.get()) && target instanceof LivingEntity && (livingTarget = (LivingEntity)target).getHealth() > 0.0f && !(target instanceof FlyingAnimal) && !(target instanceof FlyingMob) && !this.isBaby();
    }

    public boolean canBabyAttack(@NotNull Entity target) {
        return target.getBoundingBox().getSize() < this.getBoundingBox().getSize() * 1.049 && this.isBaby();
    }

    public boolean killedEntity(@NotNull ServerLevel level, @NotNull LivingEntity killed) {
        if (killed.getType().is(Primal_Tags.Entity.EAGLE_HUNTABLE) && !this.isBaby()) {
            this.getBrain().setMemoryWithExpiry(MemoryModuleType.HAS_HUNTING_COOLDOWN, (Object)true, 600L);
        }
        return super.killedEntity(level, killed);
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        boolean hurt = super.hurt(source, amount);
        if (hurt) {
            Entity entity;
            EagleEntity eagle2;
            Player player;
            LivingEntity target;
            Entity entity2;
            if (this.isVehicle() && this.getHealth() < this.getHealthWhenStartRiding() - 2.0f) {
                this.ejectPassengers();
                this.getBrain().setMemoryWithExpiry((MemoryModuleType)Primal_MemoryModuleTypes.IS_STUNNED.get(), (Object)true, 60L);
            }
            if (!(!((entity2 = source.getEntity()) instanceof LivingEntity) || (target = (LivingEntity)entity2) instanceof Player && (player = (Player)target).isCreative() || target == this.getOwner() || target instanceof EagleEntity && (eagle2 = (EagleEntity)target).getOwner() != null && eagle2.getOwner() == this.getOwner())) {
                EagleAi.wasHurtBy(this, target);
            }
            if (source.getEntity() != null && (entity = source.getEntity()) instanceof LivingEntity) {
                target = (LivingEntity)entity;
                this.getBrain().setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, (Object)target, (long)this.level().getRandom().nextIntBetweenInclusive(60, 100));
            }
        }
        return hurt;
    }

    @NotNull
    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        return new Vec3(passenger.getX(), passenger.getY() + 0.1, passenger.getZ());
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean canRiderInteract() {
        return true;
    }

    @org.jetbrains.annotations.Nullable
    public LivingEntity getControllingPassenger() {
        return null;
    }

    protected void positionRider(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (this.hasPassenger(passenger)) {
            boolean isAirBelow = this.level().getBlockState(this.blockPosition().below()).isAir();
            double y = isAirBelow ? this.getY() - passenger.getBoundingBox().getYsize() * 1.0 : this.getY();
            float bodyYawRad = this.yBodyRot * ((float)Math.PI / 180);
            double forwardOffset = isAirBelow ? 0.2 : -passenger.getBoundingBox().getXsize() * 0.7;
            double sideOffset = -0.0;
            double x = this.getX() + (double)Mth.sin((float)bodyYawRad) * forwardOffset + (double)Mth.cos((float)bodyYawRad) * sideOffset;
            double z = this.getZ() - (double)Mth.cos((float)bodyYawRad) * forwardOffset + (double)Mth.sin((float)bodyYawRad) * sideOffset;
            callback.accept(passenger, x, y, z);
        }
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        boolean wasFeed;
        ItemStack stackInHand = player.getItemInHand(hand);
        Item item = stackInHand.getItem();
        if (item instanceof DyeItem) {
            DyeColor dyecolor;
            DyeItem dyeitem = (DyeItem)item;
            if (this.isOwnedBy((LivingEntity)player) && (dyecolor = dyeitem.getDyeColor()) != this.getCollarColor()) {
                this.setCollarColor(dyecolor);
                stackInHand.consume(1, (LivingEntity)player);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
        }
        if (this.isFood(stackInHand) && (wasFeed = this.handleEating(player, stackInHand))) {
            stackInHand.consume(1, (LivingEntity)player);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (this.isTame() && this.isOwnedBy((LivingEntity)player)) {
            return this.changeFollowState(player, hand);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult changeFollowState(Player player, InteractionHand hand) {
        if (player != this.getOwner()) {
            if (this.level().isClientSide) {
                return InteractionResult.CONSUME;
            }
            return InteractionResult.PASS;
        }
        if (!this.level().isClientSide && hand.equals((Object)InteractionHand.MAIN_HAND)) {
            this.setFollowerState(this.isWandering() ? 1 : (this.isFollowing() ? 2 : 0));
            player.displayClientMessage((Component)Component.translatable((String)(this.isFollowing() ? "primal.gui.animal_following" : (this.isSitting() ? "primal.gui.animal_sitting" : "primal.gui.animal_wandering")), (Object[])new Object[]{this.getName()}), true);
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
    }

    protected boolean handleEating(@NotNull Player player, @NotNull ItemStack stack) {
        if (this.isFood(stack)) {
            if (EagleEntity.isMatingFood(stack) && !this.level().isClientSide && this.getAge() == 0 && this.canFallInLove()) {
                this.setInLove(player);
                return this.playEatingSound();
            }
            if (!this.isTame() && EagleEntity.isTameFood(stack) && this.isBaby() && !this.level().isClientSide) {
                if (this.random.nextIntBetweenInclusive(0, 5) == 0) {
                    this.tame(player);
                    this.navigation.stop();
                    this.setTarget(null);
                    this.level().broadcastEntityEvent((Entity)this, (byte)7);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                }
                return this.playEatingSound();
            }
            if (this.isTame() && !this.level().isClientSide && EagleEntity.isHealFood(stack) && this.getHealth() < this.getMaxHealth()) {
                this.heal(2.0f);
                return this.playEatingSound();
            }
            if (this.isBaby() && !EagleEntity.isTameFood(stack)) {
                int i = this.getAge();
                this.ageUp(EagleEntity.getSpeedUpSecondsWhenFeeding((int)(-i)), true);
                return this.playEatingSound();
            }
        }
        return false;
    }

    public void handleEntityEvent(byte id) {
        if (id == 13) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.ANGRY_VILLAGER);
        } else if (id == 14) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
        } else {
            super.handleEntityEvent(id);
        }
    }

    public boolean shouldTryTeleportToOwner() {
        LivingEntity livingentity = this.getOwner();
        return livingentity != null && this.distanceToSqr((Entity)this.getOwner()) >= 225.0;
    }

    protected void addParticlesAroundSelf(ParticleOptions particleOption) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle(particleOption, this.getRandomX(1.0), this.getRandomY() + 1.0, this.getRandomZ(1.0), d0, d1, d2);
        }
    }

    protected boolean playEatingSound() {
        SoundEvent soundEvent;
        if (!this.isSilent() && (soundEvent = this.getEatingSound()) != null) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), soundEvent, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        return true;
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)Primal_Sounds.EAGLE_IDLE.get();
    }

    protected boolean isFlapping() {
        double speed = this.getDeltaMovement().length();
        return !this.onGround() && !this.isInWater() && speed < 0.3 && (float)this.tickCount % 15.0f == 0.0f;
    }

    protected void onFlap() {
        this.playSound((SoundEvent)Primal_Sounds.EAGLE_FLAP.get(), 0.15f, 1.0f);
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return (SoundEvent)Primal_Sounds.EAGLE_HURT.get();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)Primal_Sounds.EAGLE_DEATH.get();
    }

    @org.jetbrains.annotations.Nullable
    public SoundEvent getEatingSound() {
        return (SoundEvent)Primal_Sounds.EAGLE_EAT.get();
    }

    @org.jetbrains.annotations.Nullable
    public SoundEvent getShriekSound() {
        if (this.getVariant() == Variant.BALD && this.random.nextIntBetweenInclusive(0, 500) == 0) {
            return (SoundEvent)Primal_Sounds.EAGLE_FREEDOM.get();
        }
        return (SoundEvent)Primal_Sounds.EAGLE_SHRIEK.get();
    }

    public int getRemainingPersistentAngerTime() {
        return 0;
    }

    public void setRemainingPersistentAngerTime(int remainingPersistentAngerTime) {
    }

    @org.jetbrains.annotations.Nullable
    public UUID getPersistentAngerTarget() {
        return null;
    }

    public void setPersistentAngerTarget(@org.jetbrains.annotations.Nullable UUID persistentAngerTarget) {
    }

    public void startPersistentAngerTimer() {
    }

    public static enum Variant implements StringRepresentable
    {
        BALD(0, "bald"),
        GOLDEN(1, "golden"),
        HARPY(2, "harpy"),
        PHILIPPINE(3, "philippine");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Variant::values);
            BY_ID = ByIdMap.continuous(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

