/*
 * Decompiled with CFR 0.152.
 */
package org.primal.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import org.primal.entity.ai.goals.ZombieAttackEggGoal;
import org.primal.entity.animal.BearEntity;
import org.primal.entity.animal.SharkEntity;
import org.primal.registry.Primal_Blocks;
import org.primal.registry.Primal_Entities;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Zombie.class})
public abstract class ZombieMixin
extends Monster {
    @Unique
    Zombie p$THIS = (Zombie)this;
    @Unique
    boolean primal$primalJockeySpawned = false;

    protected ZombieMixin(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"registerGoals"}, at={@At(value="HEAD")})
    private void primal$zombiesTryToDestroyEggs(CallbackInfo ci) {
        this.goalSelector.addGoal(4, (Goal)new ZombieAttackEggGoal((Block)Primal_Blocks.CROCODILE_EGG.get(), (PathfinderMob)this, 1.0, 3));
        this.goalSelector.addGoal(4, (Goal)new ZombieAttackEggGoal((Block)Primal_Blocks.EAGLE_EGG.get(), (PathfinderMob)this, 1.0, 3));
    }

    @Inject(method={"finalizeSpawn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/monster/Zombie;setBaby(Z)V")})
    private void primal$setJockeysSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, SpawnGroupData spawnGroupData, CallbackInfoReturnable<SpawnGroupData> cir) {
        RandomSource randomsource = level.getRandom();
        if (spawnGroupData instanceof Zombie.ZombieGroupData) {
            Zombie.ZombieGroupData zombie$zombiegroupdata = (Zombie.ZombieGroupData)spawnGroupData;
            if (zombie$zombiegroupdata.canSpawnJockey) {
                BearEntity bear;
                SharkEntity shark;
                if (this.p$THIS instanceof Drowned && (double)randomsource.nextFloat() < 0.03 && (shark = (SharkEntity)((EntityType)Primal_Entities.SHARK.get()).create(this.level())) != null) {
                    shark.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                    shark.finalizeSpawn(level, difficulty, MobSpawnType.JOCKEY, null);
                    shark.setSharkJockey(true);
                    this.startRiding((Entity)shark);
                    level.addFreshEntity((Entity)shark);
                    this.primal$primalJockeySpawned = true;
                }
                if ((double)randomsource.nextFloat() < 0.03 && !this.primal$primalJockeySpawned && (bear = (BearEntity)((EntityType)Primal_Entities.BEAR.get()).create(this.level())) != null) {
                    bear.setBaby(true);
                    bear.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                    bear.finalizeSpawn(level, difficulty, MobSpawnType.JOCKEY, null);
                    bear.setBearJockey(true);
                    this.startRiding((Entity)bear);
                    level.addFreshEntity((Entity)bear);
                    this.primal$primalJockeySpawned = true;
                }
            }
        }
    }

    @ModifyExpressionValue(method={"finalizeSpawn"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/monster/Zombie$ZombieGroupData;canSpawnJockey:Z")})
    private boolean primal$avoidOtherJockeySpawn(boolean canSpawnJockey) {
        return canSpawnJockey && !this.primal$primalJockeySpawned;
    }
}

