/*
 * Decompiled with CFR 0.152.
 */
package org.primal.util;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.primal.injection.IsEagleTarget;
import org.primal.registry.Primal_MemoryModuleTypes;
import org.primal.registry.Primal_Tags;
import org.primal.util.HostileMount;

public class MiscUtil {
    public static final IntegerProperty EGGS_2 = IntegerProperty.create((String)"eggs", (int)1, (int)2);
    public static final IntegerProperty EGGS_3 = IntegerProperty.create((String)"eggs", (int)1, (int)3);
    public static final IntegerProperty EGGS_4 = IntegerProperty.create((String)"eggs", (int)1, (int)4);

    public static boolean isMoving(LivingEntity entity, float motionThreshold) {
        float limbSwingAmount = 0.0f;
        if (entity.isAlive() && (limbSwingAmount = entity.walkAnimation.speed((float)entity.tickCount)) > 1.0f) {
            limbSwingAmount = 1.0f;
        }
        Vec3 velocity = entity.getDeltaMovement();
        float avgVelocity = (float)((Math.abs(velocity.x) + Math.abs(velocity.z)) / 2.0);
        return avgVelocity >= motionThreshold && limbSwingAmount != 0.0f;
    }

    public static boolean isSeeingTarget(Entity target, Entity watcher, float angle) {
        Vec3 vec3d = target.position();
        Vec3 vec3d2 = watcher.calculateViewVector(0.0f, watcher.getYHeadRot());
        Vec3 vec3d3 = vec3d.vectorTo(watcher.position());
        vec3d3 = new Vec3(vec3d3.x, 0.0, vec3d3.z).normalize();
        return vec3d3.dot(vec3d2) < (double)angle;
    }

    public static float smoothAngle(float current, float target, float maxChange) {
        float delta = Mth.wrapDegrees((float)(target - current));
        delta = Mth.clamp((float)delta, (float)(-maxChange), (float)maxChange);
        return current + delta;
    }

    public static boolean isRidingUnfriendly(LivingEntity entity) {
        return entity.isPassenger() && entity.getVehicle() instanceof HostileMount;
    }

    public static void extendLootPool(LootPool pool, List<LootPoolEntryContainer> newEntries) {
        ImmutableList.Builder entriesBuilder = ImmutableList.builder();
        entriesBuilder.addAll((Iterable)pool.entries);
        entriesBuilder.addAll(newEntries);
        pool.entries = entriesBuilder.build();
    }

    public static boolean isNotNeverAttack(LivingEntity entity) {
        return !entity.getType().is(Primal_Tags.Entity.NEVER_ATTACK);
    }

    public static void addToAttackCount(LivingEntity entity) {
        if (entity.getBrain().hasMemoryValue((MemoryModuleType)Primal_MemoryModuleTypes.AMOUNT_ATTACKED.get())) {
            entity.getBrain().setMemory((MemoryModuleType)Primal_MemoryModuleTypes.AMOUNT_ATTACKED.get(), (Object)((Integer)entity.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.AMOUNT_ATTACKED.get()).get() + 1));
        } else {
            entity.getBrain().setMemory((MemoryModuleType)Primal_MemoryModuleTypes.AMOUNT_ATTACKED.get(), (Object)1);
        }
    }

    public static boolean isSameEagleAttacking(LivingEntity target, LivingEntity eagle) {
        if (((IsEagleTarget)target).primal$eagleAttacking().isPresent()) {
            if (eagle.isBaby()) {
                return true;
            }
            return ((IsEagleTarget)target).primal$eagleAttacking().get() == eagle.getUUID();
        }
        return true;
    }

    public static void insertItemsAfter(BuildCreativeModeTabContentsEvent event, ItemStack after, ItemStack ... itemStacks) {
        for (int i = 0; i < itemStacks.length; ++i) {
            if (i == 0) {
                event.insertAfter(after, itemStacks[i], CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                continue;
            }
            event.insertAfter(itemStacks[i - 1], itemStacks[i], CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    public static void createBiomeModifier(Holder<Biome> biome, ModifiableBiomeInfo.BiomeInfo.Builder builder, TagKey<Biome> biomeTagSpawn, List<String> extraBiomes, boolean enabled, int spawnWeight, int minGroupSize, int maxGroupSize, EntityType<?> entityType) {
        if (enabled) {
            boolean matchesExtra = extraBiomes.stream().anyMatch(b -> {
                String[] stringArray;
                ResourceLocation loc = ResourceLocation.tryParse((String)b);
                if (b.contains("#") && (stringArray = b.split("#")).length >= 1) {
                    String biomeTag = stringArray[1];
                    ResourceLocation tagLoc = ResourceLocation.tryParse((String)biomeTag);
                    return tagLoc != null && biome.is(TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)tagLoc));
                }
                return loc != null && biome.unwrapKey().map(key -> key.location().equals((Object)loc)).orElse(false) != false;
            });
            if ((biome.is(biomeTagSpawn) || matchesExtra) && spawnWeight > 0 && minGroupSize > 0 && maxGroupSize > 0) {
                builder.getMobSpawnSettings().getSpawner(entityType.getCategory()).add(new MobSpawnSettings.SpawnerData(entityType, spawnWeight, minGroupSize, maxGroupSize));
            }
        }
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> void createBiomeModifier(Holder<Biome> biome, ModifiableBiomeInfo.BiomeInfo.Builder builder, TagKey<Biome> biomeTagSpawn, List<String> extraBiomes, GenerationStep.Decoration step, boolean enabled, F feature, FC config, PlacementModifier heightmap, int rarity) {
        if (enabled) {
            boolean matchesExtra = extraBiomes.stream().anyMatch(b -> {
                String[] stringArray;
                ResourceLocation loc = ResourceLocation.tryParse((String)b);
                if (b.contains("#") && (stringArray = b.split("#")).length >= 1) {
                    String biomeTag = stringArray[1];
                    ResourceLocation tagLoc = ResourceLocation.tryParse((String)biomeTag);
                    return tagLoc != null && biome.is(TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)tagLoc));
                }
                return loc != null && biome.unwrapKey().map(key -> key.location().equals((Object)loc)).orElse(false) != false;
            });
            if (biome.is(biomeTagSpawn) || matchesExtra) {
                ConfiguredFeature configured = new ConfiguredFeature(feature, config);
                List<BiomeFilter> modifiers = List.of(RarityFilter.onAverageOnceEvery((int)rarity), InSquarePlacement.spread(), heightmap, BiomeFilter.biome());
                Holder placedFeature = Holder.direct((Object)new PlacedFeature(Holder.direct((Object)configured), modifiers));
                builder.getGenerationSettings().addFeature(step, placedFeature);
            }
        }
    }

    public static DeferredHolder<MapCodec<? extends BiomeModifier>, MapCodec<? extends BiomeModifier>> createBiomeModifierSerializer(String name) {
        return DeferredHolder.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"primal", (String)name));
    }

    public static ResourceLocation nomanslandLoc(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"nomansland", (String)name);
    }
}

