/*
 * Decompiled with CFR 0.152.
 */
package org.primal.worldgen;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.primal.block.RiverReeds;
import org.primal.block.properties.TripleBlockHalf;
import org.primal.registry.Primal_Blocks;
import org.primal.worldgen.RandomPatchCustomConfig;

public class RiverReedsFeature
extends Feature<RandomPatchCustomConfig> {
    public RiverReedsFeature(Codec<RandomPatchCustomConfig> configCodec) {
        super(configCodec);
    }

    public boolean place(@NotNull FeaturePlaceContext<RandomPatchCustomConfig> context) {
        boolean isTooBelowSeaLevel;
        RandomPatchCustomConfig randomPatchConfiguration = (RandomPatchCustomConfig)context.config();
        RandomSource randomsource = context.random();
        BlockPos origin = context.origin();
        WorldGenLevel level = context.level();
        BlockPredicate isNearWater = BlockPredicate.anyOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.matchesFluids((Vec3i)new BlockPos(1, -1, 0), (Fluid[])new Fluid[]{Fluids.WATER, Fluids.FLOWING_WATER}), BlockPredicate.matchesFluids((Vec3i)new BlockPos(-1, -1, 0), (Fluid[])new Fluid[]{Fluids.WATER, Fluids.FLOWING_WATER}), BlockPredicate.matchesFluids((Vec3i)new BlockPos(0, -1, 1), (Fluid[])new Fluid[]{Fluids.WATER, Fluids.FLOWING_WATER}), BlockPredicate.matchesFluids((Vec3i)new BlockPos(0, -1, -1), (Fluid[])new Fluid[]{Fluids.WATER, Fluids.FLOWING_WATER})});
        boolean bl = isTooBelowSeaLevel = origin.getY() < level.getSeaLevel() - 3;
        if (!isNearWater.test((Object)level, (Object)origin) || isTooBelowSeaLevel) {
            return false;
        }
        int i = 0;
        BlockPos.MutableBlockPos desiredPosition = new BlockPos.MutableBlockPos();
        int lateralDistance = randomPatchConfiguration.xzSpread() + 1;
        int verticalDistance = randomPatchConfiguration.ySpread() + 1;
        BlockState defaultStateShortReeds = ((Block)Primal_Blocks.SHORT_RIVER_REEDS.get()).defaultBlockState();
        BlockState defaultStateLongReeds = ((Block)Primal_Blocks.RIVER_REEDS.get()).defaultBlockState();
        PerlinSimplexNoise reedsNoise = new PerlinSimplexNoise(randomsource, List.of(Integer.valueOf(0)));
        for (int dx = -lateralDistance; dx <= lateralDistance; ++dx) {
            for (int dz = -lateralDistance; dz <= lateralDistance; ++dz) {
                for (int dy = -verticalDistance; dy <= verticalDistance; ++dy) {
                    boolean generateDouble;
                    boolean generateShort;
                    double noiseValue = reedsNoise.getValue((double)(origin.getX() + dx) * 0.1, (double)(origin.getZ() + dz) * 0.1, false);
                    if (!(noiseValue > 0.1) || !defaultStateLongReeds.canSurvive((LevelReader)level, (BlockPos)(desiredPosition = desiredPosition.setWithOffset((Vec3i)origin, dx, dy, dz))) || !this.canGenerateHere(level, (BlockPos)desiredPosition)) continue;
                    boolean isUnderwater = level.getBlockState((BlockPos)desiredPosition).is(Blocks.WATER);
                    boolean isUnderwaterAbove = level.getBlockState(desiredPosition.above()).is(Blocks.WATER);
                    boolean isUnderwaterAboveAbove = level.getBlockState(desiredPosition.above().above()).is(Blocks.WATER);
                    boolean bl2 = generateShort = level.getRandom().nextInt(0, 3) == 0;
                    if (generateShort) continue;
                    int age = level.getRandom().nextInt(1, 5) >= 4 ? 1 : 0;
                    boolean bl3 = generateDouble = level.getRandom().nextInt(0, 3) == 0;
                    if (isUnderwater && !generateDouble && this.canGenerateHere(level, (BlockPos)desiredPosition) && this.canGenerateHere(level, desiredPosition.above()) && this.canGenerateHere(level, desiredPosition.above().above())) {
                        if (isUnderwater && isUnderwaterAbove && isUnderwaterAboveAbove || !level.setBlock((BlockPos)desiredPosition, (BlockState)((BlockState)((BlockState)defaultStateLongReeds.setValue(RiverReeds.HALF, (Comparable)((Object)TripleBlockHalf.LOWER))).setValue((Property)RiverReeds.AGE, (Comparable)Integer.valueOf(age))).setValue((Property)RiverReeds.WATERLOGGED, (Comparable)Boolean.valueOf(isUnderwater)), 2) || !level.setBlock(desiredPosition.above(), (BlockState)((BlockState)((BlockState)defaultStateLongReeds.setValue(RiverReeds.HALF, (Comparable)((Object)TripleBlockHalf.MIDDLE))).setValue((Property)RiverReeds.AGE, (Comparable)Integer.valueOf(age))).setValue((Property)RiverReeds.WATERLOGGED, (Comparable)Boolean.valueOf(isUnderwaterAbove)), 2) || !level.setBlock(desiredPosition.above().above(), (BlockState)((BlockState)((BlockState)defaultStateLongReeds.setValue(RiverReeds.HALF, (Comparable)((Object)TripleBlockHalf.UPPER))).setValue((Property)RiverReeds.AGE, (Comparable)Integer.valueOf(age))).setValue((Property)RiverReeds.WATERLOGGED, (Comparable)Boolean.valueOf(isUnderwaterAboveAbove)), 2)) continue;
                        ++i;
                        continue;
                    }
                    if (!this.canGenerateHere(level, (BlockPos)desiredPosition) || !this.canGenerateHere(level, desiredPosition.above()) || isUnderwater && isUnderwaterAbove) continue;
                    if (level.setBlock((BlockPos)desiredPosition, (BlockState)((BlockState)((BlockState)defaultStateLongReeds.setValue(RiverReeds.HALF, (Comparable)((Object)TripleBlockHalf.LOWER))).setValue((Property)RiverReeds.AGE, (Comparable)Integer.valueOf(age))).setValue((Property)RiverReeds.WATERLOGGED, (Comparable)Boolean.valueOf(isUnderwater)), 2) && level.setBlock(desiredPosition.above(), (BlockState)((BlockState)((BlockState)defaultStateLongReeds.setValue(RiverReeds.HALF, (Comparable)((Object)TripleBlockHalf.UPPER))).setValue((Property)RiverReeds.AGE, (Comparable)Integer.valueOf(age))).setValue((Property)RiverReeds.WATERLOGGED, (Comparable)Boolean.valueOf(isUnderwaterAbove)), 2)) {
                        ++i;
                        continue;
                    }
                    if (!level.setBlock((BlockPos)desiredPosition, (BlockState)defaultStateShortReeds.setValue((Property)RiverReeds.WATERLOGGED, (Comparable)Boolean.valueOf(isUnderwater)), 2)) continue;
                    ++i;
                }
            }
        }
        return i > 0;
    }

    public boolean canGenerateHere(WorldGenLevel level, BlockPos pos) {
        return level.getBlockState(pos).isAir() || level.getBlockState(pos).is(Blocks.WATER);
    }
}

