/*
 * Decompiled with CFR 0.152.
 */
package org.primal;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class Primal_Config {
    public final ForgeConfigSpec.BooleanValue enableBearSingleSpawn;
    public final ForgeConfigSpec.IntValue bearSingleSpawnWeight;
    public final ForgeConfigSpec.IntValue bearSingleMinGroup;
    public final ForgeConfigSpec.IntValue bearSingleMaxGroup;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> bearSingleExtraBiomes;
    public final ForgeConfigSpec.BooleanValue enableBearGroupSpawn;
    public final ForgeConfigSpec.IntValue bearGroupSpawnWeight;
    public final ForgeConfigSpec.IntValue bearGroupMinGroup;
    public final ForgeConfigSpec.IntValue bearGroupMaxGroup;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> bearGroupExtraBiomes;
    public final ForgeConfigSpec.BooleanValue enableCrocodileNormalSpawn;
    public final ForgeConfigSpec.IntValue crocodileNormalSpawnWeight;
    public final ForgeConfigSpec.IntValue crocodileNormalMinGroup;
    public final ForgeConfigSpec.IntValue crocodileNormalMaxGroup;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> crocodileNormalExtraBiomes;
    public final ForgeConfigSpec.BooleanValue enableCrocodileWarmSpawn;
    public final ForgeConfigSpec.IntValue crocodileWarmSpawnWeight;
    public final ForgeConfigSpec.IntValue crocodileWarmMinGroup;
    public final ForgeConfigSpec.IntValue crocodileWarmMaxGroup;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> crocodileWarmExtraBiomes;
    public final ForgeConfigSpec.BooleanValue enableSingleSharkSpawn;
    public final ForgeConfigSpec.IntValue sharkSingleSpawnWeight;
    public final ForgeConfigSpec.IntValue sharkSingleMinGroup;
    public final ForgeConfigSpec.IntValue sharkSingleMaxGroup;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> sharkSingleExtraBiomes;
    public final ForgeConfigSpec.BooleanValue enableSharkGroupSpawn;
    public final ForgeConfigSpec.IntValue sharkGroupSpawnWeight;
    public final ForgeConfigSpec.IntValue sharkGroupMinGroup;
    public final ForgeConfigSpec.IntValue sharkGroupMaxGroup;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> sharkGroupExtraBiomes;
    public final ForgeConfigSpec.BooleanValue polarBearModelChange;
    public final ForgeConfigSpec.BooleanValue polarBearIncreasesHealth;
    public final ForgeConfigSpec.BooleanValue foxModelChange;
    public final ForgeConfigSpec.ConfigValue<List<? extends List<? extends String>>> eggData;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> extraPlaceableEggs;
    public final ForgeConfigSpec.BooleanValue riverReedsSpawnInWorld;
    public final ForgeConfigSpec.IntValue riverReedsPatchRarity;
    public final ForgeConfigSpec.IntValue riverReedsPatchSpreadXZ;
    public final ForgeConfigSpec.IntValue riverReedsPatchSpreadY;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> riverReedsExtraBiomes;
    public final ForgeConfigSpec.BooleanValue seaShellsSpawnInWorld;
    public final ForgeConfigSpec.IntValue seaShellsPatchRarity;
    public final ForgeConfigSpec.IntValue seaShellsPatchTries;
    public final ForgeConfigSpec.IntValue seaShellsPatchSpreadXZ;
    public final ForgeConfigSpec.IntValue seaShellsPatchSpreadY;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> seaShellsExtraBiomes;
    public final ForgeConfigSpec.BooleanValue eagleNestSpawnInWorld;
    public final ForgeConfigSpec.IntValue eagleNestRarity;
    public final ForgeConfigSpec.IntValue eagleNestTries;
    public final ForgeConfigSpec.IntValue eagleNestSpreadXZ;
    public final ForgeConfigSpec.IntValue eagleNestSpreadY;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> eagleNestExtraBiomes;

    public Primal_Config(ForgeConfigSpec.Builder builder) {
        builder.comment("Misc Settings").push("misc");
        this.eggData = builder.comment("List of egg data: each entry is [block_id, entity_id].\nThis is used for the nest block, for eggs that can hatch, add the block to the animal_egg tag to be placeable or to the next config\nPrimal eggs are already defined").defineList("eggData", List.of(List.of("minecraft:turtle_egg", "minecraft:turtle"), List.of("minecraft:sniffer_egg", "minecraft:sniffer"), List.of("nomansland:tortoise_egg", "nomansland:tortoise")), obj -> {
            if (!(obj instanceof List)) {
                return false;
            }
            List inner = (List)obj;
            if (inner.size() != 2) {
                return false;
            }
            return inner.get(0) instanceof String && inner.get(1) instanceof String;
        });
        builder.comment("To add egg blocks directly instead of modifying the animal_egg tag");
        this.extraPlaceableEggs = builder.defineList("extraPlaceableEggs", List.of(), o -> {
            String s;
            return o instanceof String && (s = (String)o).contains(":");
        });
        builder.pop();
        builder.comment("Mob Settings").push("mob");
        builder.push("replaced_models");
        builder.comment("Toggle model replacements for certain mobs");
        this.polarBearModelChange = builder.define("polarBearModelChange", true);
        this.polarBearIncreasesHealth = builder.define("polarBearIncreasesHealth", true);
        this.foxModelChange = builder.define("foxModelChange", true);
        builder.pop();
        builder.comment("Primal Mobs Spawn - tweak natural spawn\n(Eagles only spawn on nests, tweak the nest spawn in world section)");
        builder.push("bear");
        builder.push("single");
        builder.comment("Enable or disable bear single spawning\nDefault=true");
        this.enableBearSingleSpawn = builder.define("enableBearSingleSpawn", true);
        builder.comment("Spawn weight for single bears (higher = more common)\nDefault=20");
        this.bearSingleSpawnWeight = builder.defineInRange("bearSingleSpawnWeight", 20, 1, Integer.MAX_VALUE);
        builder.comment("Minimum group size for single bears, it MUST be lesser than max group size\nDefault=1");
        this.bearSingleMinGroup = builder.defineInRange("bearSingleMinGroup", 1, 1, Integer.MAX_VALUE);
        builder.comment("Maximum group size for single bears, it MUST be greater than min group size\nDefault=1");
        this.bearSingleMaxGroup = builder.defineInRange("bearSingleMaxGroup", 1, 1, Integer.MAX_VALUE);
        builder.comment("Extra biomes (separated from biome tag) where single bears can spawn.\nMust be written as full biome IDs (e.g. \"minecraft:plains\", \"nomansland:maple_forest\")\nYou can use biome tags too, just put a # before (e.g. \"#minecraft:is_forest\", \"#nomansland:is_river\")\nDefault = []");
        this.bearSingleExtraBiomes = builder.defineList("bearSingleExtraBiomes", List.of(), o -> {
            String s;
            return o instanceof String && (s = (String)o).contains(":");
        });
        builder.pop();
        builder.push("group");
        builder.comment("Enable or disable bear group spawning (with babies)\nDefault=true");
        this.enableBearGroupSpawn = builder.define("enableBearGroupSpawn", true);
        builder.comment("Spawn weight for bear groups (higher = more common)\nDefault=5");
        this.bearGroupSpawnWeight = builder.defineInRange("bearGroupSpawnWeight", 5, 1, Integer.MAX_VALUE);
        builder.comment("Minimum group size for bear groups, it MUST be lesser than max group size\nDefault=2");
        this.bearGroupMinGroup = builder.defineInRange("bearGroupMinGroup", 2, 1, Integer.MAX_VALUE);
        builder.comment("Maximum group size for bear groups, it MUST be greater than min group size\nDefault=2");
        this.bearGroupMaxGroup = builder.defineInRange("bearGroupMaxGroup", 2, 1, Integer.MAX_VALUE);
        builder.comment("Extra biomes (separated from biome tag) where bear groups can spawn.\nMust be written as full biome IDs (e.g. \"minecraft:plains\", \"nomansland:maple_forest\")\nYou can use biome tags too, just put a # before (e.g. \"#minecraft:is_forest\", \"#nomansland:is_river\")\nDefault = []");
        this.bearGroupExtraBiomes = builder.defineList("bearGroupExtraBiomes", List.of(), o -> {
            String s;
            return o instanceof String && (s = (String)o).contains(":");
        });
        builder.pop();
        builder.pop();
        builder.push("crocodile");
        builder.push("normal");
        builder.comment("Enable or disable crocodile spawning in swampy/jungle biomes\nDefault=true");
        this.enableCrocodileNormalSpawn = builder.define("enableCrocodileNormalSpawn", true);
        builder.comment("Spawn weight for crocodiles in swampy/jungle biomes (higher = more common)\nDefault=20");
        this.crocodileNormalSpawnWeight = builder.defineInRange("crocodileNormalSpawnWeight", 20, 1, Integer.MAX_VALUE);
        builder.comment("Minimum group size for crocodiles in swampy/jungle biomes, it MUST be lesser than max group size\nDefault=1");
        this.crocodileNormalMinGroup = builder.defineInRange("crocodileNormalMinGroup", 1, 1, Integer.MAX_VALUE);
        builder.comment("Maximum group size for crocodiles in swampy/jungle biomes, it MUST be greater than min group size\nDefault=1");
        this.crocodileNormalMaxGroup = builder.defineInRange("crocodileNormalMaxGroup", 1, 1, Integer.MAX_VALUE);
        builder.comment("Extra biomes (separated from biome tag) where normal crocodiles can spawn.\nMust be written as full biome IDs (e.g. \"minecraft:plains\", \"nomansland:maple_forest\")\nYou can use biome tags too, just put a # before (e.g. \"#minecraft:is_forest\", \"#nomansland:is_river\")\nDefault = []");
        this.crocodileNormalExtraBiomes = builder.defineList("crocodileNormalExtraBiomes", List.of(), o -> {
            String s;
            return o instanceof String && (s = (String)o).contains(":");
        });
        builder.pop();
        builder.push("warm");
        builder.comment("Enable or disable crocodile spawning in warm biomes\nDefault=true");
        this.enableCrocodileWarmSpawn = builder.define("enableCrocodileWarmSpawn", true);
        builder.comment("Spawn weight for crocodiles in warm biomes (higher = more common)\nDefault=3");
        this.crocodileWarmSpawnWeight = builder.defineInRange("crocodileWarmSpawnWeight", 3, 1, Integer.MAX_VALUE);
        builder.comment("Minimum group size for crocodiles in warm biomes, it MUST be lesser than max group size\nDefault=1");
        this.crocodileWarmMinGroup = builder.defineInRange("crocodileWarmMinGroup", 1, 1, Integer.MAX_VALUE);
        builder.comment("Maximum group size for crocodiles in warm biomes, it MUST be greater than min group size\nDefault=1");
        this.crocodileWarmMaxGroup = builder.defineInRange("crocodileWarmMaxGroup", 1, 1, Integer.MAX_VALUE);
        builder.comment("Extra biomes (separated from biome tag) where warm crocodiles can spawn\nMust be written as full biome IDs (e.g. \"minecraft:plains\", \"nomansland:maple_forest\")\nYou can use biome tags too, just put a # before (e.g. \"#minecraft:is_forest\", \"#nomansland:is_river\")\nDefault = []");
        this.crocodileWarmExtraBiomes = builder.defineList("crocodileWarmExtraBiomes", List.of(), o -> {
            String s;
            return o instanceof String && (s = (String)o).contains(":");
        });
        builder.pop();
        builder.pop();
        builder.push("shark");
        builder.push("single");
        builder.comment("Enable or disable single shark spawning\nDefault=true");
        this.enableSingleSharkSpawn = builder.define("enableSingleSharkSpawn", true);
        builder.comment("Spawn weight for single sharks (higher = more common)\nDefault=5");
        this.sharkSingleSpawnWeight = builder.defineInRange("sharkSingleSpawnWeight", 5, 1, Integer.MAX_VALUE);
        builder.comment("Minimum group size for single sharks, it MUST be lesser than max group size\nDefault=1");
        this.sharkSingleMinGroup = builder.defineInRange("sharkSingleMinGroup", 1, 1, Integer.MAX_VALUE);
        builder.comment("Maximum group size for single sharks, it MUST be greater than min group size\nDefault=1");
        this.sharkSingleMaxGroup = builder.defineInRange("sharkSingleMaxGroup", 1, 1, Integer.MAX_VALUE);
        builder.comment("Extra biomes (separated from biome tag) where single sharks can spawn.\nMust be written as full biome IDs (e.g. \"minecraft:plains\", \"nomansland:maple_forest\")\nYou can use biome tags too, just put a # before (e.g. \"#minecraft:is_forest\", \"#nomansland:is_river\")\nDefault = []");
        this.sharkSingleExtraBiomes = builder.defineList("sharkSingleExtraBiomes", List.of(), o -> {
            String s;
            return o instanceof String && (s = (String)o).contains(":");
        });
        builder.pop();
        builder.push("group");
        builder.comment("Enable or disable group shark spawning\nDefault=true");
        this.enableSharkGroupSpawn = builder.define("enableSharkGroupSpawn", true);
        builder.comment("Spawn weight for shark groups (higher = more common)\nDefault=1");
        this.sharkGroupSpawnWeight = builder.defineInRange("sharkGroupSpawnWeight", 1, 1, Integer.MAX_VALUE);
        builder.comment("Minimum group size for shark groups, it MUST be lesser than max group size\nDefault=1");
        this.sharkGroupMinGroup = builder.defineInRange("sharkGroupMinGroup", 1, 1, Integer.MAX_VALUE);
        builder.comment("Maximum group size for shark groups, it MUST be greater than min group size\nDefault=3");
        this.sharkGroupMaxGroup = builder.defineInRange("sharkGroupMaxGroup", 3, 1, Integer.MAX_VALUE);
        builder.comment("Extra biomes (separated from biome tag) where shark groups can spawn.\nMust be written as full biome IDs (e.g. \"minecraft:plains\", \"nomansland:maple_forest\")\nYou can use biome tags too, just put a # before (e.g. \"#minecraft:is_forest\", \"#nomansland:is_river\")\nDefault = []");
        this.sharkGroupExtraBiomes = builder.defineList("sharkGroupExtraBiomes", List.of(), o -> {
            String s;
            return o instanceof String && (s = (String)o).contains(":");
        });
        builder.pop();
        builder.pop();
        builder.pop();
        builder.comment("World Settings").push("world");
        builder.push("river_reeds");
        builder.comment("Enable or disable river reeds spawning\nDefault=true");
        this.riverReedsSpawnInWorld = builder.define("riverReedsSpawnInWorld", true);
        builder.comment("Patch rarity for river reeds\nDefault=2");
        this.riverReedsPatchRarity = builder.defineInRange("riverReedsPatchRarity", 2, 0, Integer.MAX_VALUE);
        builder.comment("Patch horizontal spread (XZ) for river reeds\nDefault=8");
        this.riverReedsPatchSpreadXZ = builder.defineInRange("riverReedsPatchSpreadXZ", 8, 0, Integer.MAX_VALUE);
        builder.comment("Patch vertical spread (Y) for river reeds\nDefault=5");
        this.riverReedsPatchSpreadY = builder.defineInRange("riverReedsPatchSpreadY", 5, 0, Integer.MAX_VALUE);
        builder.comment("Extra biomes (separated from biome tag) where river reeds can spawn.\nMust be written as full biome IDs (e.g. \"minecraft:plains\", \"nomansland:maple_forest\")\nYou can use biome tags too, just put a # before (e.g. \"#minecraft:is_forest\", \"#nomansland:is_river\")\nDefault = []");
        this.riverReedsExtraBiomes = builder.defineList("riverReedsExtraBiomes", List.of(), o -> {
            String s;
            return o instanceof String && (s = (String)o).contains(":");
        });
        builder.pop();
        builder.push("seashells");
        builder.comment("Enable or disable seashells spawning\nDefault=true");
        this.seaShellsSpawnInWorld = builder.define("seaShellsSpawnInWorld", true);
        builder.comment("Patch rarity for seashells\nDefault=5");
        this.seaShellsPatchRarity = builder.defineInRange("seaShellsPatchRarity", 5, 0, Integer.MAX_VALUE);
        builder.comment("Number of tries per patch for seashells\nDefault=96");
        this.seaShellsPatchTries = builder.defineInRange("seaShellsPatchTries", 96, 0, Integer.MAX_VALUE);
        builder.comment("Patch horizontal spread (XZ) for seashells\nDefault=6");
        this.seaShellsPatchSpreadXZ = builder.defineInRange("seaShellsPatchSpreadXZ", 6, 0, Integer.MAX_VALUE);
        builder.comment("Patch vertical spread (Y) for seashells\nDefault=2");
        this.seaShellsPatchSpreadY = builder.defineInRange("seaShellsPatchSpreadY", 2, 0, Integer.MAX_VALUE);
        builder.comment("Extra biomes (separated from biome tag) where seashells can spawn.\nMust be written as full biome IDs (e.g. \"minecraft:plains\", \"nomansland:maple_forest\")\nYou can use biome tags too, just put a # before (e.g. \"#minecraft:is_forest\", \"#nomansland:is_river\")\nDefault = []");
        this.seaShellsExtraBiomes = builder.defineList("seaShellsExtraBiomes", List.of(), o -> {
            String s;
            return o instanceof String && (s = (String)o).contains(":");
        });
        builder.pop();
        builder.push("eagle_nest");
        builder.comment("Enable or disable eagle nest spawning\nDefault=true");
        this.eagleNestSpawnInWorld = builder.define("eagleNestSpawnInWorld", true);
        builder.comment("Rarity of eagle nests (higher = rarer)\nDefault=30");
        this.eagleNestRarity = builder.defineInRange("eagleNestRarity", 30, 0, Integer.MAX_VALUE);
        builder.comment("Number of tries per patch for eagle nests\nDefault=12");
        this.eagleNestTries = builder.defineInRange("eagleNestTries", 12, 0, Integer.MAX_VALUE);
        builder.comment("Patch horizontal spread (XZ) for eagle nests\nDefault=1");
        this.eagleNestSpreadXZ = builder.defineInRange("eagleNestSpreadXZ", 1, 0, Integer.MAX_VALUE);
        builder.comment("Patch vertical spread (Y) for eagle nests\nDefault=0");
        this.eagleNestSpreadY = builder.defineInRange("eagleNestSpreadY", 0, 0, Integer.MAX_VALUE);
        builder.comment("Extra biomes (separated from biome tag) where eagle nests can spawn.\nMust be written as full biome IDs (e.g. \"minecraft:plains\", \"nomansland:maple_forest\")\nYou can use biome tags too, just put a # before (e.g. \"#minecraft:is_forest\", \"#nomansland:is_river\")\nDefault = []");
        this.eagleNestExtraBiomes = builder.defineList("eagleNestExtraBiomes", List.of(), o -> {
            String s;
            return o instanceof String && (s = (String)o).contains(":");
        });
        builder.pop();
        builder.pop();
    }
}

