/*
 * Decompiled with CFR 0.152.
 */
package org.primal.biome_modifiers.features;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import org.primal.Primal_Main;
import org.primal.block.SeashellsBlock;
import org.primal.registry.Primal_Blocks;
import org.primal.registry.Primal_Tags;
import org.primal.registry.Primal_WorldGen;
import org.primal.util.MiscUtil;
import org.primal.worldgen.SeashellsFeature;

public class Seashells_BiomeModifier
implements BiomeModifier {
    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            MiscUtil.createBiomeModifier(biome, builder, Primal_Tags.Biome.SPAWNS_SEASHELLS, ((List)Primal_Main.COMMON_CONFIG.seaShellsExtraBiomes.get()).stream().map(Object::toString).toList(), GenerationStep.Decoration.VEGETAL_DECORATION, (Boolean)Primal_Main.COMMON_CONFIG.seaShellsSpawnInWorld.get(), Feature.f_65761_, Seashells_BiomeModifier.createSeashells((Integer)Primal_Main.COMMON_CONFIG.seaShellsPatchTries.get(), (Integer)Primal_Main.COMMON_CONFIG.seaShellsPatchSpreadXZ.get(), (Integer)Primal_Main.COMMON_CONFIG.seaShellsPatchSpreadY.get()), PlacementUtils.f_195353_, (Integer)Primal_Main.COMMON_CONFIG.seaShellsPatchRarity.get());
        }
    }

    private static RandomPatchConfiguration createSeashells(int tries, int xzSpread, int ySpread) {
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.m_146263_();
        for (int i = 1; i <= 4; ++i) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                builder.m_146271_((Object)((BlockState)((BlockState)((Block)Primal_Blocks.SEASHELLS.get()).m_49966_().m_61124_((Property)SeashellsBlock.AMOUNT, (Comparable)Integer.valueOf(i))).m_61124_((Property)SeashellsBlock.FACING, (Comparable)direction)), 1);
            }
        }
        return new RandomPatchConfiguration(tries, xzSpread, ySpread, PlacementUtils.m_206498_((Feature)((SeashellsFeature)((Object)Primal_WorldGen.SEASHELLS.get())), (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(builder)), (BlockPredicate)BlockPredicate.f_190394_));
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)MiscUtil.createBiomeModifierSerializer("seashells_patch_spawn").get();
    }

    public static Codec<? extends BiomeModifier> makeCodec() {
        return Codec.unit(Seashells_BiomeModifier::new);
    }
}

