/*
 * Decompiled with CFR 0.152.
 */
package org.primal.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.primal.Primal_Main;
import org.primal.block_entity.NestBlockEntity;
import org.primal.registry.Primal_BlockEntities;
import org.primal.registry.Primal_Sounds;
import org.primal.registry.Primal_Tags;
import org.primal.util.AnimalEgg;
import org.primal.util.VariantHolderPrimal;

public class NestBlock
extends BaseEntityBlock {
    public static final BooleanProperty HAS_EGG = BooleanProperty.m_61465_((String)"has_egg");
    public static final IntegerProperty HATCH = BlockStateProperties.f_61416_;
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)((Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), p_55164_ -> {
        p_55164_.put(Direction.NORTH, NORTH);
        p_55164_.put(Direction.EAST, EAST);
        p_55164_.put(Direction.SOUTH, SOUTH);
        p_55164_.put(Direction.WEST, WEST);
    })));

    public NestBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(true))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(true))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HAS_EGG, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, HAS_EGG, HATCH});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level blockgetter = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(!blockgetter.m_8055_(blockpos.m_122012_()).m_60713_((Block)this)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(!blockgetter.m_8055_(blockpos.m_122029_()).m_60713_((Block)this)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(!blockgetter.m_8055_(blockpos.m_122019_()).m_60713_((Block)this)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(!blockgetter.m_8055_(blockpos.m_122024_()).m_60713_((Block)this)));
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (facing != Direction.DOWN && facing != Direction.UP) {
            return facingState.m_60713_((Block)this) ? (BlockState)state.m_61124_((Property)PROPERTY_BY_DIRECTION.get(facing), (Comparable)Boolean.valueOf(false)) : (BlockState)state.m_61124_((Property)PROPERTY_BY_DIRECTION.get(facing), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)PROPERTY_BY_DIRECTION.get(rotation.m_55954_(Direction.NORTH)), (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)PROPERTY_BY_DIRECTION.get(rotation.m_55954_(Direction.SOUTH)), (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)PROPERTY_BY_DIRECTION.get(rotation.m_55954_(Direction.EAST)), (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)PROPERTY_BY_DIRECTION.get(rotation.m_55954_(Direction.WEST)), (Comparable)((Boolean)state.m_61143_((Property)WEST)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)PROPERTY_BY_DIRECTION.get(mirror.m_54848_(Direction.NORTH)), (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)PROPERTY_BY_DIRECTION.get(mirror.m_54848_(Direction.SOUTH)), (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)PROPERTY_BY_DIRECTION.get(mirror.m_54848_(Direction.EAST)), (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)PROPERTY_BY_DIRECTION.get(mirror.m_54848_(Direction.WEST)), (Comparable)((Boolean)state.m_61143_((Property)WEST)));
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        NestBlockEntity eggBlockEntity = NestBlock.getBlockEntity(level, pos);
        if (((Boolean)state.m_61143_((Property)HAS_EGG)).booleanValue() && eggBlockEntity != null && newState.m_60734_().m_49966_().m_60795_()) {
            ItemStack eggStack = new ItemStack((ItemLike)eggBlockEntity.getEgg().m_41720_(), eggBlockEntity.getEgg().m_41613_());
            NestBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)eggStack);
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    public void m_213646_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull ItemStack stack, boolean dropExperience) {
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        ItemStack stack = player.m_21120_(hand);
        if ((player.m_36341_() || stack.m_41619_()) && ((Boolean)state.m_61143_((Property)HAS_EGG)).booleanValue()) {
            return NestBlock.removeEgg((LivingEntity)player, level, pos, state, true) ? InteractionResult.m_19078_((boolean)level.f_46443_) : InteractionResult.PASS;
        }
        if (this.isItemPlaceable(stack)) {
            return NestBlock.tryPlaceEgg((LivingEntity)player, level, pos, state, stack) ? InteractionResult.m_19078_((boolean)level.f_46443_) : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public static boolean tryPlaceEgg(@Nullable LivingEntity entity, Level level, BlockPos pos, BlockState state, ItemStack stack) {
        if (!((Boolean)state.m_61143_((Property)HAS_EGG)).booleanValue()) {
            if (!level.f_46443_) {
                NestBlock.placeEgg(entity, level, pos, state, stack, false);
            }
            return true;
        }
        if (((Boolean)state.m_61143_((Property)HAS_EGG)).booleanValue() && NestBlock.getBlockEntity(level, pos).getEgg().m_150930_(stack.m_41720_()) && NestBlock.getBlockEntity(level, pos).getEggsAmount() + 1 <= NestBlock.getMaxEggAmount(stack)) {
            if (!level.f_46443_) {
                NestBlock.placeEgg(entity, level, pos, state, stack, true);
            }
            return true;
        }
        return false;
    }

    private static boolean removeEgg(@Nullable LivingEntity entity, Level level, BlockPos pos, BlockState state, boolean pop) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof NestBlockEntity) {
            NestBlockEntity nestBlockEntity = (NestBlockEntity)blockEntity;
            ItemStack eggStack = new ItemStack((ItemLike)nestBlockEntity.getEgg().m_41720_(), 1);
            nestBlockEntity.removeEgg(entity);
            if (nestBlockEntity.getEgg().m_41619_()) {
                BlockState blockstate = (BlockState)state.m_61124_((Property)HAS_EGG, (Comparable)Boolean.valueOf(false));
                level.m_7731_(pos, blockstate, 3);
                level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)blockstate));
            }
            if (pop) {
                NestBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)eggStack);
            }
            return true;
        }
        return false;
    }

    private static void placeEgg(@Nullable LivingEntity entity, Level level, BlockPos pos, BlockState state, ItemStack stack, boolean addToEgg) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof NestBlockEntity) {
            NestBlockEntity nestBlockEntity = (NestBlockEntity)blockEntity;
            if (addToEgg) {
                copyStack = stack.m_255036_(1);
                stack.m_41774_(1);
                nestBlockEntity.addEgg(copyStack, entity);
            } else {
                copyStack = stack.m_255036_(1);
                stack.m_41774_(1);
                nestBlockEntity.setEgg(copyStack, entity);
                BlockState blockstate = (BlockState)state.m_61124_((Property)HAS_EGG, (Comparable)Boolean.valueOf(true));
                level.m_7731_(pos, blockstate, 3);
                level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)blockstate));
            }
            level.m_5594_(null, pos, (SoundEvent)Primal_Sounds.PLACES_EGG.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public boolean isItemPlaceable(ItemStack stack) {
        BlockItem blockItem;
        Item item = stack.m_41720_();
        return item instanceof BlockItem && ((blockItem = (BlockItem)item).m_40614_().m_49966_().m_204336_(Primal_Tags.Block.IS_ANIMAL_EGG) || ((List)Primal_Main.COMMON_CONFIG.extraPlaceableEggs.get()).contains(BuiltInRegistries.f_256975_.m_7981_((Object)blockItem.m_40614_()).toString()));
    }

    public static int getMaxEggAmount(ItemStack eggStack) {
        BlockItem blockItem;
        Block eggBlock;
        Optional<Property> eggPropertyOpt;
        Item item = eggStack.m_41720_();
        if (item instanceof BlockItem && (eggPropertyOpt = (eggBlock = (blockItem = (BlockItem)item).m_40614_()).m_49966_().m_61147_().stream().filter(property -> property.m_61708_().equals("eggs") && property instanceof IntegerProperty).findFirst()).isPresent()) {
            IntegerProperty property2 = (IntegerProperty)eggPropertyOpt.get();
            return property2.m_6908_().stream().max(Integer::compare).orElse(1);
        }
        return 1;
    }

    public static Optional<BlockState> getEggBlockState(ItemStack eggStack) {
        Item item = eggStack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block eggBlock = blockItem.m_40614_();
            BlockState eggState = eggBlock.m_49966_();
            Optional<Property> eggProperty = eggBlock.m_49966_().m_61147_().stream().filter(property -> property.m_61708_().equals("eggs") && property instanceof IntegerProperty).findFirst();
            if (eggProperty.isPresent()) {
                eggState = (BlockState)eggBlock.m_49966_().m_61124_((Property)((IntegerProperty)eggProperty.get()), (Comparable)Integer.valueOf(eggStack.m_41613_()));
            }
            return Optional.of(eggState);
        }
        return Optional.empty();
    }

    public static NestBlockEntity getBlockEntity(Level level, BlockPos pos) {
        return (NestBlockEntity)level.m_7702_(pos);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape defaultBox = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
        if (level instanceof Level) {
            Level level1 = (Level)level;
            if (NestBlock.getBlockEntity(level1, pos) == null || !((Boolean)state.m_61143_((Property)HAS_EGG)).booleanValue()) {
                return defaultBox;
            }
            ItemStack eggStack = NestBlock.getBlockEntity(level1, pos).getEgg();
            if (NestBlock.getEggBlockState(eggStack).isPresent()) {
                BlockState eggBlock = NestBlock.getEggBlockState(eggStack).get();
                VoxelShape eggShape = eggBlock.m_60808_(level, pos);
                AABB bounds = eggShape.m_83215_();
                VoxelShape eggBox = Block.m_49796_((double)(bounds.f_82288_ * 16.0), (double)(bounds.f_82289_ * 16.0 + 4.0), (double)(bounds.f_82290_ * 16.0), (double)(bounds.f_82291_ * 16.0), (double)(bounds.f_82292_ * 16.0 + 4.0), (double)(bounds.f_82293_ * 16.0));
                defaultBox = Shapes.m_83110_((VoxelShape)defaultBox, (VoxelShape)eggBox);
            }
        }
        return defaultBox;
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new NestBlockEntity((BlockEntityType)Primal_BlockEntities.NEST_BLOCK_ENTITY.get(), pos, state);
    }

    public void m_213898_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (NestBlock.getBlockEntity((Level)level, pos) != null) {
            NestBlock.serverTick((Level)level, pos, state, NestBlock.getBlockEntity((Level)level, pos));
        }
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)HAS_EGG);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, NestBlockEntity blockEntity) {
        Optional<BlockState> eggState;
        ItemStack eggStack = blockEntity.getEgg();
        if (!eggStack.m_41619_() && (eggState = NestBlock.getEggBlockState(eggStack)).isPresent() && (eggState.get().m_204336_(Primal_Tags.Block.IS_ANIMAL_EGG) || ((List)Primal_Main.COMMON_CONFIG.extraPlaceableEggs.get()).contains(BuiltInRegistries.f_256975_.m_7981_((Object)eggState.get().m_60734_()).toString()))) {
            Optional<Property> eggProperty = eggState.get().m_60734_().m_49966_().m_61147_().stream().filter(property -> property.m_61708_().equals("eggs") && property instanceof IntegerProperty).findFirst();
            NestBlock.randomEggTick(state, eggState.get(), level, pos, level.m_213780_(), eggProperty.orElse(null));
        }
    }

    protected static void randomEggTick(@NotNull BlockState nestState, @NotNull BlockState eggState, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random, @Nullable IntegerProperty eggsProperty) {
        HashMap<String, String> eggMap = new HashMap<String, String>();
        List eggDataList = (List)Primal_Main.COMMON_CONFIG.eggData.get();
        for (List pair : eggDataList) {
            if (pair.size() < 2) continue;
            eggMap.put((String)pair.get(0), (String)pair.get(1));
        }
        ResourceLocation eggBlockId = BuiltInRegistries.f_256975_.m_7981_((Object)eggState.m_60734_());
        Optional entityType = BuiltInRegistries.f_256780_.m_6612_(ResourceLocation.parse((String)eggMap.getOrDefault(eggBlockId.toString(), "")));
        if (level.f_46441_.m_188503_(10) == 0 && (eggState.m_60734_() instanceof AnimalEgg || eggMap.containsKey(BuiltInRegistries.f_256975_.m_7981_((Object)eggState.m_60734_()).toString()))) {
            int i = (Integer)nestState.m_61143_((Property)HATCH);
            if (i < 2) {
                level.m_5594_(null, pos, (SoundEvent)Primal_Sounds.EGG_CRACK.get(), SoundSource.BLOCKS, 0.7f, 0.9f + random.m_188501_() * 0.2f);
                level.m_7731_(pos, (BlockState)nestState.m_61124_((Property)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
                level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)nestState));
            } else {
                level.m_5594_(null, pos, (SoundEvent)Primal_Sounds.EGG_HATCH.get(), SoundSource.BLOCKS, 0.7f, 0.9f + random.m_188501_() * 0.2f);
                if (eggsProperty != null) {
                    for (int j = 0; j < (Integer)eggState.m_61143_((Property)eggsProperty); ++j) {
                        Entity entity;
                        NestBlock.removeEgg(null, level, pos, nestState, false);
                        level.m_46796_(2001, pos, Block.m_49956_((BlockState)nestState));
                        Block block = eggState.m_60734_();
                        if (block instanceof AnimalEgg) {
                            AnimalEgg animalEgg = (AnimalEgg)block;
                            Animal animal = (Animal)((EntityType)animalEgg.getAnimal().get()).m_20615_(level);
                            if (animal == null) continue;
                            Holder holder = level.m_204166_(pos);
                            animal.m_6863_(true);
                            if (animal instanceof VariantHolderPrimal) {
                                VariantHolderPrimal variantWhenHatches = (VariantHolderPrimal)animal;
                                if (animal instanceof VariantHolder) {
                                    VariantHolder variantHolder = (VariantHolder)animal;
                                    VariantHolderPrimal variantHolderCast = variantWhenHatches;
                                    if (variantHolderCast.getRareVariant(animal) != null && variantWhenHatches.getRareVariantProbability(level)) {
                                        variantHolder.m_28464_(variantHolderCast.getRareVariant(animal));
                                    } else {
                                        variantHolderCast.setVariantFromBiome(animal, (Holder<Biome>)holder);
                                    }
                                }
                            }
                            animal.m_7678_((double)pos.m_123341_() + 0.3 + (double)j * 0.2, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.3, 0.0f, 0.0f);
                            level.m_7967_((Entity)animal);
                            continue;
                        }
                        if (!entityType.isPresent() || (entity = ((EntityType)entityType.get()).m_20615_(level)) == null) continue;
                        if (entity instanceof AgeableMob) {
                            AgeableMob ageable = (AgeableMob)entity;
                            ageable.m_6863_(true);
                            if (entity instanceof Turtle) {
                                Turtle turtle = (Turtle)entity;
                                turtle.m_30219_(pos);
                            }
                        }
                        entity.m_7678_((double)pos.m_123341_() + 0.3 + (double)j * 0.2, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.3, 0.0f, 0.0f);
                        level.m_7967_(entity);
                    }
                } else if (entityType.isPresent()) {
                    NestBlock.removeEgg(null, level, pos, nestState, false);
                    Entity entity = ((EntityType)entityType.get()).m_20615_(level);
                    if (entity != null) {
                        if (entity instanceof AgeableMob) {
                            AgeableMob ageable = (AgeableMob)entity;
                            ageable.m_6863_(true);
                        }
                        entity.m_7678_((double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), 0.0f, 0.0f);
                        level.m_7967_(entity);
                    }
                }
                NestBlockEntity nestBlockEntity = NestBlock.getBlockEntity(level, pos);
                BlockState emptyNestState = (BlockState)((BlockState)nestState.m_61124_((Property)HAS_EGG, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0));
                level.m_7731_(pos, emptyNestState, 3);
                level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)emptyNestState));
                nestBlockEntity.updateBlock();
            }
        }
    }
}

