/*
 * Decompiled with CFR 0.152.
 */
package org.primal.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.primal.block.ShortRiverReeds;
import org.primal.block.properties.TripleBlockHalf;
import org.primal.registry.Primal_Blocks;
import org.primal.registry.Primal_Tags;

public class RiverReeds
extends BushBlock
implements BonemealableBlock,
SimpleWaterloggedBlock {
    public static final EnumProperty<TripleBlockHalf> HALF = EnumProperty.m_61587_((String)"half", TripleBlockHalf.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty AGE = BlockStateProperties.f_61405_;

    public RiverReeds(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HALF, (Comparable)((Object)TripleBlockHalf.LOWER))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF}).m_61104_(new Property[]{WATERLOGGED}).m_61104_(new Property[]{AGE});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean isUnderwater = fluidstate.m_76152_() == Fluids.f_76193_;
        BlockState finalState = (BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isUnderwater));
        return (BlockState)finalState.m_61124_(HALF, (Comparable)((Object)TripleBlockHalf.LOWER));
    }

    public void m_6402_(@NotNull Level level, BlockPos pos, @NotNull BlockState state, LivingEntity placer, @NotNull ItemStack stack) {
        BlockPos blockPosAbove = pos.m_7494_();
        BlockPos blockPosAboveAbove = pos.m_7494_().m_7494_();
        if (state.m_61143_(HALF) == TripleBlockHalf.LOWER && !level.f_46443_) {
            if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() && level.m_213780_().m_188499_()) {
                level.m_7731_(blockPosAbove, RiverReeds.copyWaterloggedFrom((LevelReader)level, blockPosAbove, (BlockState)this.m_49966_().m_61124_(HALF, (Comparable)((Object)TripleBlockHalf.MIDDLE))), 3);
                level.m_7731_(blockPosAboveAbove, RiverReeds.copyWaterloggedFrom((LevelReader)level, blockPosAboveAbove, (BlockState)this.m_49966_().m_61124_(HALF, (Comparable)((Object)TripleBlockHalf.UPPER))), 3);
            } else {
                level.m_7731_(blockPosAbove, RiverReeds.copyWaterloggedFrom((LevelReader)level, blockPosAbove, (BlockState)this.m_49966_().m_61124_(HALF, (Comparable)((Object)TripleBlockHalf.UPPER))), 3);
            }
        }
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        TripleBlockHalf half;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (!((half = (TripleBlockHalf)((Object)state.m_61143_(HALF))) != TripleBlockHalf.LOWER && half != TripleBlockHalf.MIDDLE || facing != Direction.UP || facingState.m_60713_((Block)this))) {
            return Blocks.f_50016_.m_49966_();
        }
        if (half == TripleBlockHalf.UPPER && facing == Direction.DOWN && !facingState.m_60713_((Block)this)) {
            return Blocks.f_50016_.m_49966_();
        }
        if ((facing == Direction.UP || facing == Direction.DOWN) && facingState.m_60713_((Block)this)) {
            int age = (Integer)facingState.m_61143_((Property)AGE);
            return (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        BlockState blockBelow = level.m_8055_(pos.m_7495_());
        BlockState blockAbove = level.m_8055_(pos.m_7494_());
        if (state.m_61143_(HALF) == TripleBlockHalf.UPPER) {
            return blockBelow.m_60713_((Block)this);
        }
        if (state.m_61143_(HALF) == TripleBlockHalf.MIDDLE) {
            return blockAbove.m_60713_((Block)this) && blockBelow.m_60713_((Block)this);
        }
        return super.m_7898_(state, level, pos);
    }

    protected boolean m_6266_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return super.m_6266_(state, level, pos) || state.m_204336_(Primal_Tags.Block.RIVER_REED_SOIL);
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public static BlockState copyWaterloggedFrom(LevelReader level, BlockPos pos, BlockState state) {
        return state.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(level.m_46801_(pos))) : state;
    }

    public long m_7799_(BlockState state, BlockPos pos) {
        return Mth.m_14130_((int)pos.m_123341_(), (int)pos.m_6625_(state.m_61143_(HALF) == TripleBlockHalf.LOWER ? 0 : (state.m_61143_(HALF) == TripleBlockHalf.MIDDLE ? 1 : 2)).m_123342_(), (int)pos.m_123343_());
    }

    public boolean m_7370_(@NotNull LevelReader levelReader, @NotNull BlockPos blockPos, @NotNull BlockState blockState, boolean b) {
        return true;
    }

    public boolean m_214167_(@NotNull Level level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        return true;
    }

    public void m_214148_(@NotNull ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        this.performBonemeal(level, random, pos, state, true);
    }

    public void performBonemeal(@NotNull ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state, boolean canSpread) {
        if ((Integer)state.m_61143_((Property)AGE) == 0) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
        } else {
            BlockPos lowestPos;
            BlockState blockBelow = level.m_8055_(pos.m_7495_());
            if (state.m_61143_(HALF) == TripleBlockHalf.UPPER && blockBelow.m_60713_((Block)this)) {
                pos = pos.m_7495_();
            }
            if (level.m_8055_(pos).m_61143_(HALF) == TripleBlockHalf.MIDDLE && level.m_8055_(pos.m_7495_()).m_60713_((Block)this)) {
                pos = pos.m_7495_();
            }
            if (level.m_6425_(lowestPos = pos).m_192917_((Fluid)Fluids.f_76193_) && RiverReeds.isValidPosForRiverReed((LevelReader)level, pos.m_7494_().m_7494_()) && !level.m_8055_(pos.m_7494_().m_7494_()).m_60713_((Block)this)) {
                BlockState defaultState = this.m_49966_();
                level.m_7731_(lowestPos, (BlockState)((BlockState)((BlockState)defaultState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_61124_(HALF, (Comparable)((Object)TripleBlockHalf.LOWER))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
                level.m_7731_(lowestPos.m_7494_(), (BlockState)((BlockState)((BlockState)defaultState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(lowestPos.m_7494_()).m_192917_((Fluid)Fluids.f_76193_)))).m_61124_(HALF, (Comparable)((Object)TripleBlockHalf.MIDDLE))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
                level.m_7731_(lowestPos.m_7494_().m_7494_(), (BlockState)((BlockState)((BlockState)defaultState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(lowestPos.m_7494_().m_7494_()).m_192917_((Fluid)Fluids.f_76193_)))).m_61124_(HALF, (Comparable)((Object)TripleBlockHalf.UPPER))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
            } else if (canSpread) {
                this.setRiverReedsNear((Level)level, lowestPos, level.m_213780_().m_188499_() ? 2 : 1);
            }
        }
    }

    protected void setRiverReedsNear(Level level, BlockPos initialPos, int lateralDistance) {
        BlockPos.MutableBlockPos check = new BlockPos.MutableBlockPos();
        for (int dx = -lateralDistance; dx <= lateralDistance; ++dx) {
            for (int dz = -lateralDistance; dz <= lateralDistance; ++dz) {
                check.m_122178_(initialPos.m_123341_() + dx, initialPos.m_123342_(), initialPos.m_123343_() + dz);
                ShortRiverReeds reeds = (ShortRiverReeds)((Object)Primal_Blocks.SHORT_RIVER_REEDS.get());
                FluidState fluidstate = level.m_6425_((BlockPos)check);
                if (!reeds.m_7898_(reeds.m_49966_(), (LevelReader)level, (BlockPos)check) || level.m_213780_().m_216332_(0, 3) != 0 || check.m_123341_() == initialPos.m_123341_() && check.m_123343_() == initialPos.m_123343_() && check.m_123342_() == initialPos.m_123342_() || !level.m_8055_((BlockPos)check).m_60795_() && (!fluidstate.m_192917_((Fluid)Fluids.f_76193_) || fluidstate.m_76186_() != 8 || !level.m_8055_((BlockPos)check).m_60713_(Blocks.f_49990_))) continue;
                BlockState finalState = reeds.m_49966_();
                if (fluidstate.m_192917_((Fluid)Fluids.f_76193_)) {
                    finalState = (BlockState)finalState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
                }
                level.m_7731_((BlockPos)check, finalState, 2);
                Block block = level.m_8055_((BlockPos)check).m_60734_();
                if (!(block instanceof ShortRiverReeds)) continue;
                ShortRiverReeds shortRiverReeds = (ShortRiverReeds)block;
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                if (level.m_213780_().m_216332_(0, 3) != 0) continue;
                shortRiverReeds.m_214148_(serverLevel, level.m_213780_(), (BlockPos)check, level.m_8055_((BlockPos)check));
            }
        }
    }

    public static boolean isValidPosForRiverReed(LevelReader level, BlockPos pos) {
        return level.m_8055_(pos).m_60795_() || level.m_8055_(pos).m_60713_(Blocks.f_49990_) || level.m_8055_(pos).m_60713_((Block)Primal_Blocks.RIVER_REEDS.get());
    }

    public boolean m_6724_(@NotNull BlockState state) {
        return state.m_61143_(HALF) == TripleBlockHalf.LOWER;
    }

    public void m_213898_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.m_45524_(pos, 0) >= 6 && level.m_213780_().m_216332_(1, 50) == 1) {
            this.performBonemeal(level, random, pos, state, false);
        }
    }
}

