/*
 * Decompiled with CFR 0.152.
 */
package org.primal.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.primal.block.RiverReeds;
import org.primal.block.properties.TripleBlockHalf;
import org.primal.registry.Primal_Blocks;
import org.primal.registry.Primal_Tags;

public class ShortRiverReeds
extends BushBlock
implements BonemealableBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public ShortRiverReeds(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean isUnderwater = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isUnderwater));
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7898_(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        FluidState fluidstate = level.m_6425_(pos);
        return super.m_7898_(state, level, pos) || super.m_7898_(state, level, pos) && fluidstate.m_192917_((Fluid)Fluids.f_76193_) && fluidstate.m_76186_() == 8;
    }

    protected boolean m_6266_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return super.m_6266_(state, level, pos) || state.m_204336_(Primal_Tags.Block.RIVER_REED_SOIL);
    }

    public boolean m_7370_(@NotNull LevelReader level, BlockPos pos, @NotNull BlockState blockState, boolean b) {
        return RiverReeds.isValidPosForRiverReed(level, pos.m_7494_());
    }

    public boolean m_214167_(@NotNull Level level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        return true;
    }

    public void m_214148_(@NotNull ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        boolean spawnTriple;
        BlockState defaultState = ((Block)Primal_Blocks.RIVER_REEDS.get()).m_49966_();
        BlockState lowerRiverReed = (BlockState)defaultState.m_61124_(RiverReeds.HALF, (Comparable)((Object)TripleBlockHalf.LOWER));
        BlockState middleRiverReed = (BlockState)defaultState.m_61124_(RiverReeds.HALF, (Comparable)((Object)TripleBlockHalf.MIDDLE));
        BlockState upperRiverReed = (BlockState)defaultState.m_61124_(RiverReeds.HALF, (Comparable)((Object)TripleBlockHalf.UPPER));
        BlockPos posAbove = pos.m_7494_();
        BlockPos posAboveAbove = pos.m_7494_().m_7494_();
        boolean bl = spawnTriple = level.m_213780_().m_188499_() && level.m_6425_(pos).m_76152_() == Fluids.f_76193_;
        if (spawnTriple && RiverReeds.isValidPosForRiverReed((LevelReader)level, posAboveAbove)) {
            if (level.m_6425_(pos).m_76152_() == Fluids.f_76193_) {
                lowerRiverReed = (BlockState)lowerRiverReed.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            }
            if (level.m_6425_(posAbove).m_76152_() == Fluids.f_76193_) {
                middleRiverReed = (BlockState)middleRiverReed.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            }
            if (level.m_6425_(posAboveAbove).m_76152_() == Fluids.f_76193_) {
                upperRiverReed = (BlockState)upperRiverReed.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            }
            level.m_7731_(pos, lowerRiverReed, 2);
            level.m_7731_(posAbove, middleRiverReed, 2);
            level.m_7731_(posAboveAbove, upperRiverReed, 2);
        } else {
            if (level.m_6425_(pos).m_76152_() == Fluids.f_76193_) {
                lowerRiverReed = (BlockState)lowerRiverReed.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            }
            if (level.m_6425_(posAbove).m_76152_() == Fluids.f_76193_) {
                upperRiverReed = (BlockState)upperRiverReed.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            }
            level.m_7731_(pos, lowerRiverReed, 2);
            level.m_7731_(posAbove, upperRiverReed, 2);
        }
    }

    public void m_213898_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.m_45524_(pos, 0) >= 6 && level.m_213780_().m_216332_(1, 50) == 1) {
            this.m_214148_(level, random, pos, state);
        }
    }

    public boolean m_6724_(@NotNull BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED);
    }
}

