/*
 * Decompiled with CFR 0.152.
 */
package org.primal.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.primal.client.model.entity.BearModel;
import org.primal.client.renderer.entity.layer.BearBarrelsLayer;
import org.primal.client.renderer.entity.layer.BearCollarLayer;
import org.primal.client.renderer.entity.layer.BearHoneyLayer;
import org.primal.client.renderer.entity.layer.BearSleepLayer;
import org.primal.entity.animal.BearEntity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;

@OnlyIn(value=Dist.CLIENT)
public final class BearRenderer
extends GeoEntityRenderer<BearEntity> {
    public BearRenderer(EntityRendererProvider.Context context) {
        super(context, (GeoModel)new BearModel());
        this.addRenderLayer(new BearCollarLayer((GeoRenderer<BearEntity>)this));
        this.addRenderLayer(new BearBarrelsLayer((GeoRenderer<BearEntity>)this));
        this.addRenderLayer(new BearHoneyLayer((GeoRenderer<BearEntity>)this));
        this.addRenderLayer(new BearSleepLayer((GeoRenderer<BearEntity>)this));
        this.f_114477_ = 1.0f;
    }

    public void render(@NotNull BearEntity entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        if (entity.m_6162_()) {
            this.f_114477_ *= 0.5f;
        }
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public void scaleModelForRender(float widthScale, float heightScale, PoseStack poseStack, BearEntity animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay) {
        GeoBone bone = (GeoBone)model.getBone("head").get();
        float headScale = animatable.m_6162_() ? 2.0f : 1.0f;
        bone.updateScale(headScale, headScale, headScale);
        if (animatable.m_6162_()) {
            heightScale = 0.5f;
            widthScale = 0.5f;
        }
        super.scaleModelForRender(widthScale, heightScale, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
    }

    public float getMotionAnimThreshold(BearEntity animatable) {
        return animatable.m_20069_() ? 0.0f : 0.0015f;
    }
}

