/*
 * Decompiled with CFR 0.152.
 */
package org.primal.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.primal.client.model.entity.CrocodileModel;
import org.primal.entity.animal.CrocodileEntity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class CrocodileRenderer
extends GeoEntityRenderer<CrocodileEntity> {
    public CrocodileRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new CrocodileModel());
        this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer<CrocodileEntity>((GeoRenderer)this){

            public ResourceLocation getTextureResource(CrocodileEntity crocodile) {
                return ResourceLocation.fromNamespaceAndPath((String)"primal", (String)("textures/entity/crocodile/" + crocodile.getVariant().m_7912_() + ".png"));
            }
        });
        this.f_114477_ = 1.1f;
    }

    public void render(CrocodileEntity entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        if (entity.m_6162_()) {
            this.f_114477_ *= 0.3f;
        }
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public void scaleModelForRender(float widthScale, float heightScale, PoseStack poseStack, CrocodileEntity animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay) {
        if (animatable.m_6162_()) {
            heightScale = 0.3f;
            widthScale = 0.3f;
        }
        super.scaleModelForRender(widthScale, heightScale, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
    }

    protected void applyRotations(CrocodileEntity animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick) {
        if (animatable.m_5842_()) {
            float yaw = Mth.m_14179_((float)partialTick, (float)animatable.f_19859_, (float)animatable.m_146908_());
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - yaw));
            float pitch = Mth.m_14179_((float)partialTick, (float)animatable.f_19860_, (float)animatable.m_146909_());
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-pitch));
        } else {
            super.applyRotations((Entity)animatable, poseStack, ageInTicks, rotationYaw, partialTick);
        }
    }

    public float getMotionAnimThreshold(CrocodileEntity animatable) {
        return super.getMotionAnimThreshold((GeoAnimatable)animatable);
    }
}

